/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.entry;

import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CachedProperty;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.InvalidTenantContainmentException;
import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.cache.MLProp;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.IntBitField;
import com.cognos.cm.util.csv.CSVWriter;
import java.util.List;

public abstract class AbstractCacheEntry
implements CacheEntry {
    private int objectId = -1;
    protected final ICache cache;
    private String cachedProperty;
    protected MLProp mlStrings;
    private InternalStoreId storeId2;
    private int owner = -2;
    private int tenantId = 0;
    private int versionNumber = 1;
    private short type;
    private int bits;
    private static final IntBitField intBitField = new IntBitField();
    private static final IntBitField.Bits outputBits = intBitField.allocateBits(8);
    private static final IntBitField.Bits deployBits = intBitField.allocateBits(2);
    private static final IntBitField.Bits disabledBits = intBitField.allocateBits(2);
    private static final IntBitField.Bits hasRecipients = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasRecipientsEmail = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasSecurity = intBitField.allocateBits(1);
    private static final IntBitField.Bits inCognosNS = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasExID = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasCredNamespace = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasExclusiveLock = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasMessage = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasChildMutex = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasChildWithPolicy = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasBurstChildren = intBitField.allocateBits(1);
    private static final IntBitField.Bits hasBurstChildrenOnly = intBitField.allocateBits(1);
    private static final IntBitField.Bits firstChildHasMaxName = intBitField.allocateBits(1);
    private static final IntBitField.Bits unusedBit31 = intBitField.allocateBits(5);

    public AbstractCacheEntry(int tenantId, ICache cache, String name, int localeId, int objectId, int _type) {
        this.cache = cache;
        this.objectId = objectId;
        this.tenantId = tenantId;
        if (name != null) {
            this.addToMLNameProp(name, localeId);
        }
        this.setType(_type);
        this.setFirstChildHasMaxName(true);
    }

    @Override
    public void addInternalSecurityReference(int objectId, String camId) {
        if (this.getHasExID()) {
            throw new CacheException("CacheEntry::addInternalSecurityReference", "Illegal call to addInternalSecurityReference. Object already has a CAMID.");
        }
        this.setCachedPropertyValue(camId);
        if (!this.getInCognosNS()) {
            this.setInCognosNS(true);
        }
    }

    @Override
    public void addName(String name, int localeId) {
        this.addToMLNameProp(name, localeId);
        this.getParent().notifyChildNameChange(this);
    }

    protected void addToMLNameProp(String name, int localeId) {
        if (null == this.mlStrings) {
            this.mlStrings = new MLProp();
        }
        this.mlStrings.add(name, localeId);
    }

    @Override
    public void addSecurityReference(int objectId, String camId) {
        int i;
        if (this.getHasExID()) {
            throw new CacheException("CacheEntry::addSecurityReference", "Illegal call to addSecurityReference. Object already has a CAMID.");
        }
        for (i = 2; i < camId.length() && camId.charAt(i) != ':'; ++i) {
        }
        if (i < camId.length()) {
            ++i;
        }
        String str = "::" + String.valueOf(objectId) + ":" + camId.substring(i);
        this.setCachedPropertyValue(str);
    }

    @Override
    public void freeNames() {
        if (null != this.mlStrings) {
            this.mlStrings.clear();
        }
    }

    @Override
    public int getDefaultNameLocale(int[] locales) {
        MLEntry entry = this.getDefaultNameStringEntry(locales);
        return entry.getLocaleCode();
    }

    protected MLEntry getDefaultNameStringEntry(int[] locales) {
        if (null != this.mlStrings) {
            return this.mlStrings.getDefaultEntry(locales);
        }
        return null;
    }

    @Override
    public String getExactName(int localeId) {
        if (null != this.mlStrings) {
            return this.mlStrings.get(localeId);
        }
        return null;
    }

    @Override
    public int getLocale() {
        return 0;
    }

    @Override
    public MLProp getMLProp() {
        return this.mlStrings;
    }

    @Override
    public String getName(int[] locales) {
        MLEntry entry = this.getDefaultNameStringEntry(locales);
        if (null == entry) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean hasName(String name) {
        if (null != this.mlStrings) {
            return this.mlStrings.containsValue(name);
        }
        return false;
    }

    @Override
    public void setLocale(int localeId) {
    }

    @Override
    public boolean getHasBurstChildren() {
        return hasBurstChildren.isSet(this.bits);
    }

    @Override
    public void setHasBurstChildren(boolean value) {
        this.bits = hasBurstChildren.setBits(this.bits, value);
    }

    @Override
    public boolean getHasBurstChildrenOnly() {
        return hasBurstChildrenOnly.isSet(this.bits);
    }

    @Override
    public void setHasBurstChildrenOnly(boolean value) {
        this.bits = hasBurstChildrenOnly.setBits(this.bits, value);
    }

    @Override
    public boolean getHasChildWithPolicy() {
        return hasChildWithPolicy.isSet(this.bits);
    }

    @Override
    public void setHasChildWithPolicy(boolean value) {
        this.bits = hasChildWithPolicy.setBits(this.bits, value);
    }

    @Override
    public boolean getHasChildMutex() {
        return hasChildMutex.isSet(this.bits);
    }

    @Override
    public void setHasChildMutex(boolean value) {
        this.bits = hasChildMutex.setBits(this.bits, value);
    }

    @Override
    public boolean getHasCredNamespace() {
        return hasCredNamespace.isSet(this.bits);
    }

    @Override
    public void setHasCredNamespace(boolean value) {
        this.bits = hasCredNamespace.setBits(this.bits, value);
    }

    @Override
    public boolean getHasExclusiveLock() {
        return hasExclusiveLock.isSet(this.bits);
    }

    @Override
    public void setHasExclusiveLock(boolean value) {
        this.bits = hasExclusiveLock.setBits(this.bits, value);
    }

    @Override
    public boolean getHasExID() {
        return hasExID.isSet(this.bits);
    }

    @Override
    public void setHasExID(boolean value) {
        this.bits = hasExID.setBits(this.bits, value);
    }

    @Override
    public boolean getHasMessage() {
        return hasMessage.isSet(this.bits);
    }

    @Override
    public void setHasMessage(boolean value) {
        this.bits = hasMessage.setBits(this.bits, value);
    }

    @Override
    public boolean getHasRecipients() {
        return hasRecipients.isSet(this.bits);
    }

    @Override
    public void setHasRecipients(boolean value) {
        this.bits = hasRecipients.setBits(this.bits, value);
    }

    @Override
    public boolean getHasRecipientsEmail() {
        return hasRecipientsEmail.isSet(this.bits);
    }

    @Override
    public void setHasRecipientsEmail(boolean value) {
        this.bits = hasRecipientsEmail.setBits(this.bits, value);
    }

    @Override
    public boolean getHasSecurity() {
        return hasSecurity.isSet(this.bits);
    }

    @Override
    public void setHasSecurity(boolean value) {
        this.bits = hasSecurity.setBits(this.bits, value);
    }

    @Override
    public boolean getInCognosNS() {
        return inCognosNS.isSet(this.bits);
    }

    @Override
    public void setInCognosNS(boolean value) {
        this.bits = inCognosNS.setBits(this.bits, value);
    }

    @Override
    public boolean getIsLast() {
        return this.equals(this.getCache().getLastEntryCache().getLastEntry(this.getParent(), this.getType()));
    }

    @Override
    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public int getSharedAllDescendantsLocksCount() {
        return this.cache.getLockCounts().getSharedAllDescendantsLocksCount(this.objectId);
    }

    @Override
    public int getSharedExclusiveDescendantLocksCount() {
        return this.cache.getLockCounts().getSharedExclusiveDescendantLocksCount(this.objectId);
    }

    @Override
    public int getSharedLocksCount() {
        return this.cache.getLockCounts().getSharedLocksCount(this.objectId);
    }

    @Override
    public InternalStoreId getStoreId2() {
        return this.storeId2;
    }

    @Override
    public void setMLProp(MLProp mlStrings) {
        this.mlStrings = mlStrings;
    }

    @Override
    public void setOwner(int objectId) {
        this.owner = objectId;
    }

    @Override
    public void setStoreId2(InternalStoreId storeId) {
        this.storeId2 = storeId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    private void setType(int type) {
        if (type < 0 || type > Short.MAX_VALUE) {
            throw new IllegalArgumentException("type: " + type + " is greater than capacity of the maximum value for a short");
        }
        this.type = (short)type;
    }

    @Override
    public int getOutputFormat() {
        return outputBits.getBits(this.bits);
    }

    @Override
    public void setOutputFormat(int value) {
        this.bits = outputBits.setBits(this.bits, value);
    }

    @Override
    public int getDeploymentObjectUsage() {
        return deployBits.getBits(this.bits);
    }

    @Override
    public void setDeploymentObjectUsage(int value) {
        if (value < 0 || value > 3) {
            throw new IllegalArgumentException("deploymentObjectUsage exceeds the maximum (3): " + value);
        }
        this.bits = deployBits.setBits(this.bits, value);
    }

    @Override
    public void setDisabled(Boolean disabled) {
        int value = null == disabled ? 0 : (disabled != false ? 1 : 2);
        this.bits = disabledBits.setBits(this.bits, value);
    }

    @Override
    public Boolean getDisabled() {
        Boolean retVal = null;
        if (disabledBits.getBits(this.bits) == 1) {
            retVal = Boolean.TRUE;
        } else if (disabledBits.getBits(this.bits) == 2) {
            retVal = Boolean.FALSE;
        }
        return retVal;
    }

    @Override
    public void setSharedAllDescendantsLocksCount(int count) {
        this.cache.getLockCounts().setSharedAllDescendantsLocksCount(this.objectId, count);
    }

    @Override
    public void setSharedExclusiveDescendantLocksCount(int count) {
        this.cache.getLockCounts().setSharedExclusiveDescendantLocksCount(this.objectId, count);
    }

    @Override
    public void setSharedLocksCount(int count) {
        this.cache.getLockCounts().setSharedLocksCount(this.objectId, count);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractCacheEntry) {
            return this.objectId == ((AbstractCacheEntry)obj).objectId;
        }
        return false;
    }

    public int hashCode() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        int oldId = this.objectId;
        this.objectId = objectId;
        this.cache.changeEntryId(oldId, this);
    }

    @Override
    public String getClassName() {
        return this.cache.getClassName(this.getType());
    }

    @Override
    public boolean isSecurityObject() {
        return this.getHasExID() || this.getInCognosNS();
    }

    @Override
    public boolean isExternalSecurityObject() {
        return this.getHasExID() && !this.getInCognosNS();
    }

    @Override
    public boolean isRoot() {
        return this.objectId == 0;
    }

    protected String getCachedPropertyValue() {
        return this.cachedProperty;
    }

    private String setCachedPropertyValue(CachedProperty property, String value) {
        this.cache.setQuickLookupValue(property, value, this);
        this.cachedProperty = value;
        return this.cachedProperty;
    }

    @Override
    public void setCachedPropertyValue(String value) {
        CachedProperty prop = this.getCachedProperty();
        this.setCachedPropertyValue(prop, value);
    }

    @Override
    public boolean isCachedPropertyCaseSensitive() {
        int id = AbstractCacheEntry.getCachedPropertyID(this.getType());
        return id == 9;
    }

    protected CachedProperty getCachedProperty() {
        int id = AbstractCacheEntry.getCachedPropertyID(this.getType());
        return this.cache.getCachedPropertyType(id);
    }

    private static int getCachedPropertyID(int _type) {
        if (AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.HISTORY)) {
            return 15;
        }
        if (AbstractCacheEntry.typeIsSecurityObject(_type)) {
            return 9;
        }
        if (AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.SCHEDULE)) {
            return 14;
        }
        if (AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.DISPATCHER)) {
            return 5;
        }
        if (AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.GENERICDOCUMENT)) {
            return 16;
        }
        return -1;
    }

    private static boolean typeIsSecurityObject(int _type) {
        return AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.ACCOUNT) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.DISTRIBUTIONLIST) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.GROUP) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.NAMESPACE) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.NAMESPACEFOLDER) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.ROLE) || AbstractCacheEntry.typeMatchesClass(_type, CMObjectClass.PRINTER);
    }

    private static boolean typeMatchesClass(int _type, CMObjectClass clazz) {
        return clazz != null && _type == clazz.getID();
    }

    @Override
    public boolean matchesQuickLookupProperty(String nameValue) {
        if (this.cachedProperty != null) {
            if (this.isCachedPropertyCaseSensitive()) {
                return this.cachedProperty.equals(nameValue);
            }
            return this.cachedProperty.equalsIgnoreCase(nameValue);
        }
        return false;
    }

    @Override
    public String getQuickLookupProperty() {
        return this.cachedProperty;
    }

    @Override
    public boolean getFirstChildHasMaxName() {
        return firstChildHasMaxName.isSet(this.bits);
    }

    protected void setFirstChildHasMaxName(boolean b) {
        this.bits = firstChildHasMaxName.setBits(this.bits, b);
    }

    @Override
    public boolean hasMultipleNames() {
        return this.getMLProp().size() > 1;
    }

    @Override
    public int compareTo(CacheEntry other) {
        MLEntry thisMaxName = this.getMLProp().getMaxEntry();
        MLEntry otherMaxName = other.getMLProp().getMaxEntry();
        if (thisMaxName == null) {
            if (otherMaxName == null) {
                return this.getObjectId() - other.getObjectId();
            }
            return -1;
        }
        if (otherMaxName == null) {
            return 1;
        }
        return thisMaxName.compareTo(otherMaxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllNames(List<String> names, List<Integer> locales) {
        AbstractCacheEntry abstractCacheEntry = this;
        synchronized (abstractCacheEntry) {
            MLProp mlStrings = this.getMLProp();
            if (null != mlStrings) {
                mlStrings.clear();
            } else {
                mlStrings = new MLProp();
                this.setMLProp(mlStrings);
            }
            mlStrings.setAll(names, locales);
        }
        this.getParent().notifyChildNameChange(this);
    }

    @Override
    public void notifyChildNameChange(CacheEntry child) {
        if (this.getFirstChildHasMaxName() && child == this.getFirstChild()) {
            this.setFirstChildHasMaxName(false);
        }
    }

    @Override
    public void markDeleted() {
        this.setType(CMObjectClass._DELETEDOBJECT.getID());
    }

    ICache getCache() {
        return this.cache;
    }

    @Override
    public void setTenantId(int tenantId) {
        this.validateTenantContainment(this.getParent(), this, tenantId);
        this.tenantId = tenantId;
    }

    protected void validateTenantContainment(CacheEntry parent, CacheEntry child, int newChildTenantId) {
        if (!MultiTenancyUtils.isValidContainment(parent.getTenantId(), newChildTenantId) && !this.cache.ignoreInvalidTenantContainment()) {
            throw new InvalidTenantContainmentException("AbstractCacheEntry::validateTenantContainment", "Illegal tenant containment. Parent storeID=" + this.getCache().getStoreId(parent, true) + ", Child objectClass=" + child.getClassName());
        }
    }

    @Override
    public int getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setVersionNumber(int version) {
        this.versionNumber = version;
    }

    @Override
    public int getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void incrementVersionNumber() {
        if (this.versionNumber == Integer.MAX_VALUE) {
            this.versionNumber = 0;
        }
        ++this.versionNumber;
    }

    protected void buildExtraDumpFields(StringBuilder buf) {
        if (buf.length() != 0) {
            buf.append("; ");
        }
        if (this.cachedProperty != null) {
            if (AbstractCacheEntry.typeMatchesClass(this.type, CMObjectClass.HISTORY)) {
                buf.append("eventID");
            } else if (AbstractCacheEntry.typeIsSecurityObject(this.type)) {
                buf.append("CAMID");
            } else if (AbstractCacheEntry.typeMatchesClass(this.type, CMObjectClass.SCHEDULE)) {
                buf.append("taskID");
            } else if (AbstractCacheEntry.typeMatchesClass(this.type, CMObjectClass.DISPATCHER)) {
                buf.append("dispatcherPath");
            } else {
                buf.append("cachedProperty");
            }
            buf.append("=").append(this.cachedProperty);
        }
    }

    public static void dumpHeader(CSVWriter csv) {
        csv.writeRaw("cmid").writeRaw("pcmid").writeRaw("version").writeRaw("flags").writeRaw("tenant").writeRaw("class").writeRaw("storeID").writeRaw("owner").writeRaw("name").writeRaw("misc").endRecord();
    }

    public void dump(CSVWriter csv) {
        csv.write(this.getObjectId());
        csv.write(this.getParent().getObjectId());
        csv.write(this.getVersionNumber());
        csv.writeFormattedRaw("0x%08X", (Object)this.bits);
        csv.write(this.getTenantId());
        csv.writeRaw(this.getClassName());
        csv.writeRaw(this.getStoreId2().stringValue());
        csv.write(this.getOwner());
        csv.write(this.cache.getName(this, null));
        StringBuilder buf = new StringBuilder();
        this.buildExtraDumpFields(buf);
        csv.write(buf.toString());
    }
}

