/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.entry;

import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.entry.CacheEntryWithVersion;
import com.cognos.cm.cache.entry.LinkedCacheEntry;
import com.cognos.cm.cache.entry.StubCacheEntry;
import com.cognos.cm.server.CMRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class CacheEntryFactory {
    private final ICache cache;
    private final Map<Integer, Constructor<?>> constructorMap;

    public CacheEntryFactory(ICache cache) {
        this.cache = cache;
        this.constructorMap = new HashMap();
    }

    public void initialize() throws CMRuntimeException {
        String[] classesWithVersion = new String[]{"output", "graphic", "dashboard", "dataSource", "dataSourceConnection", "dataSourceSignon", "visualization", "userInterfaceProfile"};
        this.updateConstructorMap(CacheEntryWithVersion.class, classesWithVersion);
    }

    protected void updateConstructorMap(Class<? extends CacheEntry> clazz, String ... classNames) {
        Constructor<?> constructor = this.getConstructor(clazz);
        for (String className : classNames) {
            this.constructorMap.put(this.cache.getSpecialClassId(className), constructor);
        }
    }

    private Constructor<?> getConstructor(Class<? extends CacheEntry> cacheEntryClass) {
        Constructor<? extends CacheEntry> constructor;
        Class[] params = new Class[]{Integer.TYPE, ICache.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        try {
            constructor = cacheEntryClass.getConstructor(params);
        }
        catch (SecurityException e) {
            throw new CMRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CMRuntimeException(e);
        }
        return constructor;
    }

    public CacheEntry createCacheEntry(int tenantId, int objectID, int objectClass, CacheEntryName name) {
        CacheEntry cacheEntry;
        try {
            if (this.constructorMap.containsKey(objectClass)) {
                Constructor<?> entryConstructor = this.constructorMap.get(objectClass);
                cacheEntry = (CacheEntry)entryConstructor.newInstance(tenantId, this.cache, name.name, name.localeID, objectID, objectClass);
            } else {
                cacheEntry = new LinkedCacheEntry(tenantId, this.cache, name.name, name.localeID, objectID, objectClass);
            }
        }
        catch (InvocationTargetException e) {
            throw new CMRuntimeException(e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            throw new CMRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new CMRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new CMRuntimeException(e);
        }
        return cacheEntry;
    }

    public CacheEntry createStubCacheEntry(ICache cache, int objectId) {
        return new StubCacheEntry(cache, objectId);
    }

    public static class CacheEntryName {
        private String name;
        private int localeID;

        public CacheEntryName(String name, int localeId) {
            this.name = name;
            this.localeID = localeId;
        }
    }
}

