/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.entry;

import com.cognos.cm.cache.CacheAssert;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.cache.MLEntryTimestampValue;
import com.cognos.cm.cache.MLProp;
import com.cognos.cm.cache.UniqueNameGenerator;
import com.cognos.cm.cache.entry.AbstractCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.entry.ChildIterator;
import com.cognos.cm.cache.entry.EntryTreeNavigator;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cmutils.collections.TraverseOrder;
import com.cognos.cmutils.collections.TreeNavigator;

public class LinkedCacheEntry
extends AbstractCacheEntry {
    private static final String ALREADY_LINKED = "Child entry is already linked";
    private static final String UNLINK_NON_CHILD = "Attempting to unlink non-child";
    private volatile CacheEntry parent = CacheTypes.UNSET;
    private volatile CacheEntry firstChild = CacheTypes.UNSET;
    private volatile CacheEntry sibling = CacheTypes.UNSET;

    public LinkedCacheEntry(int tenantId, ICache cache, String name, int localeId, int objectId, int type) {
        super(tenantId, cache, name, localeId, objectId, type);
    }

    @Override
    public synchronized void linkChild(CacheEntry newChild) {
        CacheAssert.assertTrue(newChild.getParent() == CacheTypes.UNSET && newChild.getSibling() == CacheTypes.UNSET, ALREADY_LINKED);
        this.validateTenantContainment(this, newChild, newChild.getTenantId());
        newChild.setParent(this);
        if (this.getFirstChildHasMaxName()) {
            this.compareAndLinkMaxNameChild(newChild);
        } else {
            this.findAndLinkMaxNameChild(newChild);
        }
        this.updateFlagsPostLink(newChild);
    }

    private void compareAndLinkMaxNameChild(CacheEntry newChild) {
        if (this.getFirstChild() == CacheTypes.UNSET || newChild.compareTo(this.getFirstChild()) > 0) {
            newChild.setSibling(this.getFirstChild());
            this.setFirstChild(newChild);
        } else {
            newChild.setSibling(this.getFirstChild().getSibling());
            this.getFirstChild().setSibling(newChild);
        }
    }

    private void findAndLinkMaxNameChild(CacheEntry newChild) {
        CacheEntry maxNameChild = newChild;
        CacheEntry precedesMaxNameChild = CacheTypes.UNSET;
        CacheEntry previous = CacheTypes.UNSET;
        for (CacheEntry entry : this.children()) {
            if (entry.compareTo(maxNameChild) > 0) {
                maxNameChild = entry;
                precedesMaxNameChild = previous;
            }
            previous = entry;
        }
        if (maxNameChild != newChild) {
            this.unlinkChild(maxNameChild, precedesMaxNameChild);
            maxNameChild.setParent(this);
            maxNameChild.setSibling(newChild);
        }
        newChild.setSibling(this.getFirstChild());
        this.setFirstChild(maxNameChild);
        this.setFirstChildHasMaxName(true);
    }

    private CacheEntry findMaxNameChild() {
        CacheEntry maxNameEntry = this.getFirstChild();
        for (CacheEntry child : this.children()) {
            if (child.compareTo(maxNameEntry) <= 0) continue;
            maxNameEntry = child;
        }
        return maxNameEntry;
    }

    private void updateFlagsPostLink(CacheEntry child) {
        this.updateLastChild(child);
        if (child.getHasSecurity()) {
            this.setHasChildWithPolicy(true);
        }
        if (child.getHasRecipients()) {
            this.setHasBurstChildren(true);
            if (this.isOnlyChild(child)) {
                this.setHasBurstChildrenOnly(true);
                this.setOutputFormat(child.getOutputFormat());
            }
            if (this.getOutputFormat() != 255 && this.getOutputFormat() != child.getOutputFormat()) {
                this.setOutputFormat(255);
            }
        } else {
            this.setHasBurstChildrenOnly(false);
        }
    }

    private void updateLastChild(CacheEntry child) {
        this.getCache().getLastEntryCache().clearLastEntryOfClass(this, child.getType(), child.getTenantId());
    }

    private boolean isOnlyChild(CacheEntry child) {
        return child == this.getFirstChild() && child.getSibling() == CacheTypes.UNSET;
    }

    @Override
    public synchronized void unlinkChild(CacheEntry child) {
        CacheAssert.assertTrue(child.getParent() == this, UNLINK_NON_CHILD);
        CacheEntry precedingSibling = this.findPrecedingSibling(child);
        this.unlinkChild(child, precedingSibling);
    }

    private void unlinkChild(CacheEntry child, CacheEntry precedingSibling) {
        if (precedingSibling == CacheTypes.UNSET) {
            this.setFirstChildHasMaxName(false);
            this.setFirstChild(child.getSibling());
        } else {
            precedingSibling.setSibling(child.getSibling());
        }
        child.setSibling(CacheTypes.UNSET);
        child.setParent(CacheTypes.UNSET);
    }

    @Override
    public synchronized void adoptChildren(CacheEntry entry) {
        CacheEntry child = entry.getFirstChild();
        while (child != CacheTypes.UNSET) {
            CacheEntry sibling = child.getSibling();
            entry.unlinkChild(child);
            this.linkChild(child);
            child = sibling;
        }
    }

    @Override
    public Iterable<CacheEntry> children() {
        return new ChildIterator(this);
    }

    @Override
    public Iterable<CacheEntry> descendantsOrSelf(TraverseOrder order) {
        return order.createIterator((TreeNavigator)new EntryTreeNavigator(this));
    }

    @Override
    public CacheEntry getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CacheEntry parent) {
        this.checkForCircularReference(parent);
        this.parent = parent != null ? parent : CacheTypes.UNSET;
    }

    @Override
    public CacheEntry getSibling() {
        return this.sibling;
    }

    @Override
    public void setSibling(CacheEntry entry) {
        this.checkForCircularReference(entry);
        this.sibling = entry;
    }

    protected void setFirstChild(CacheEntry entry) {
        this.checkForCircularReference(entry);
        this.firstChild = entry == null ? CacheTypes.UNSET : entry;
    }

    @Override
    public CacheEntry getFirstChild() {
        return this.firstChild;
    }

    @Override
    public String generateUniqueName() {
        UniqueNameGenerator nameGenerator = this.cache.getUniqueNameGenerator();
        return nameGenerator.getTimestampValue(this).getValue();
    }

    @Override
    public MLEntryTimestampValue getLatestTimestamp() {
        MLEntryTimestampValue maxTimestamp = null;
        MLProp mlProp = this.getMLProp();
        MLEntry mlEntry = mlProp.getMaxEntry();
        if (mlEntry instanceof MLEntryTimestampValue) {
            maxTimestamp = (MLEntryTimestampValue)mlEntry;
        }
        return maxTimestamp;
    }

    @Override
    public MLEntryTimestampValue getLatestChildTimestamp() {
        CacheEntry maxChild = this.getFirstChildHasMaxName() ? this.getFirstChild() : this.findMaxNameChild();
        return maxChild != CacheTypes.UNSET ? maxChild.getLatestTimestamp() : null;
    }

    private CacheEntry findPrecedingSibling(CacheEntry child) {
        CacheEntry precedingSibling = this.getFirstChild();
        if (precedingSibling == child) {
            return CacheTypes.UNSET;
        }
        while (precedingSibling.getSibling() != child) {
            CacheAssert.assertTrue((precedingSibling = precedingSibling.getSibling()) != CacheTypes.UNSET, "Entry is not correctly linked as a child");
        }
        return precedingSibling;
    }

    private void checkForCircularReference(CacheEntry entry) {
        if (this.isSameEntry(entry)) {
            throw new CMRuntimeException(new CMException("cmFoundCircularCMIDsInCache", "detail", "{" + this.getObjectId() + "}"));
        }
    }

    private boolean isSameEntry(CacheEntry entry) {
        return entry == this || entry != null && entry != CacheTypes.UNSET && entry.getObjectId() == this.getObjectId();
    }

    @Override
    public boolean hasChildren() {
        return this.firstChild != CacheTypes.UNSET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChildNameChange(CacheEntry child) {
        super.notifyChildNameChange(child);
        LinkedCacheEntry linkedCacheEntry = this;
        synchronized (linkedCacheEntry) {
            this.unlinkChild(child);
            this.linkChild(child);
        }
    }
}

