/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.cache.query.QueryObjectID_List_Object;
import com.cognos.cm.store.InternalStoreId;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class CacheEntryIterator {
    public static Iterable<CacheEntry> create(Collection<InternalStoreId> objects) {
        final Iterator<InternalStoreId> it = objects.iterator();
        return new EntryIterator(){

            @Override
            protected CacheEntry getNext() {
                while (it.hasNext()) {
                    InternalStoreId id = (InternalStoreId)it.next();
                    CacheEntry entry = CMCacheJavaImpl.gblCache.getObjectWithStoreId(id);
                    if (entry == null) continue;
                    return entry;
                }
                return null;
            }
        };
    }

    public static Iterable<CacheEntry> create(QueryObjectID_List query2) {
        final ListIterator<QueryObjectID_List_Object> it = query2.begin();
        return new EntryIterator(){

            @Override
            protected CacheEntry getNext() {
                while (it.hasNext()) {
                    QueryObjectID_List_Object obj = (QueryObjectID_List_Object)it.next();
                    CacheEntry entry = obj.getCacheEntry();
                    if (!CMCacheJavaImpl.gblCache.isObjectValid(entry)) continue;
                    return entry;
                }
                return null;
            }
        };
    }

    public static Iterable<CacheEntry> create(int[] cmids, int size) {
        return new IntEntryIterator(cmids, size);
    }

    private static class IntEntryIterator
    extends EntryIterator {
        private int pos = 0;
        private int size;
        private int[] ids;

        IntEntryIterator(int[] ids, int size) {
            this.ids = ids;
            this.size = size;
            this.next();
        }

        @Override
        protected CacheEntry getNext() {
            while (this.pos < this.size) {
                int objid = this.ids[this.pos];
                ++this.pos;
                try {
                    if (!CMCacheJavaImpl.gblCache.isObjectValid(objid)) continue;
                    return CMCacheJavaImpl.gblCache.getObjectWithId(objid);
                }
                catch (CacheException cacheException) {
                }
            }
            return null;
        }
    }

    private static abstract class EntryIterator
    implements Iterable<CacheEntry>,
    Iterator<CacheEntry> {
        private CacheEntry next = this.getNext();

        protected abstract CacheEntry getNext();

        @Override
        public Iterator<CacheEntry> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CacheEntry next() {
            CacheEntry result = this.next;
            this.next = this.getNext();
            return result;
        }
    }
}

