/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheLockHandlerJavaImpl;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.CachedProperty;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.MutableInteger;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.PolicyCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheEntryFilter;
import com.cognos.cm.cache.query.FilteredQueryObjectID_List;
import com.cognos.cm.cache.query.ICacheQuery;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.cache.query.QueryPathStep;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.store.CMCacheAccessDenied;
import java.util.ArrayList;

public class CacheQuery
implements ICacheQuery {
    private static final String[] debugPropertyStrings = new String[]{"Name", "IsBurstOutput", "Property 2", "HasSecurity", "Parent", "Disabled", "SearchPath", "ExternalID", "HasCredentialNamespace", "DispatcherPath"};
    private static final Integer GRANTED = new Integer(0);
    static final int ACCESS_READ = 1;
    static final int ACCESS_TRAVERSE = 2;
    static final int ACCESS_WRITE = 4;
    static final int ACCESS_SETPOLICY = 8;
    static final int ACCESS_EXECUTE = 16;
    static final int ACCESS_DISABLED = 32;
    static final int ALL_ACCESS = 31;
    private static final int LOCALE_MASK = 65534;
    private ICache cache;
    private int forAction;
    private QueryObjectID_List results;
    private ICacheAccessMan m_accessMan;
    private int m_LockManagerHandle;
    private int m_LockType;
    private static final int FORMAT_LAYOUTDATAXML = 12;
    private static final int FORMAT_MHT = 10;

    public CacheQuery(ICache cache) {
        this.cache = cache;
        this.results = QueryObjectID_List.EMPTY;
    }

    private boolean ISGRANTED(int f, int p) {
        return (f & p) != 0;
    }

    private boolean DISABLED(int f) {
        return this.ISGRANTED(f, 32);
    }

    private int LOCALE(int x) {
        return 0xFFFE & x;
    }

    private int MAPPEDLOCALE(int x) {
        return this.LOCALE(x >> 16);
    }

    private void parseQueryStep(QueryObjectID_List parentObjects, QueryPathStep step, MutableInteger numFailed, boolean bLastStep) {
        if (this.useAccessManager() && (step.axis_ == 11 || step.axis_ == 12)) {
            this.m_accessMan.checkTraverseAccessTree(parentObjects);
        }
        for (int iparentid = 0; iparentid < parentObjects.size(); ++iparentid) {
            CacheEntry parentEntry = parentObjects.entryAt(iparentid);
            if (step.axis_ == 11) {
                this.processParentAxis(step, parentEntry.getObjectId());
                continue;
            }
            if (step.axis_ == 12 || step.axis_ == 14) {
                this.processAncestorAxis(step, parentEntry.getObjectId(), bLastStep, numFailed);
                continue;
            }
            this.processOtherAxis(step, parentObjects, parentEntry.getObjectId(), iparentid, bLastStep, numFailed);
        }
    }

    private boolean useAccessManager() {
        return this.m_accessMan != null && this.m_accessMan.getPassportId() != null;
    }

    private void processOtherAxis(QueryPathStep step, QueryObjectID_List parentObjects, int parentObject, int currentObjectId, boolean bLastStep, MutableInteger numFailed) {
        CacheEntry entry;
        QueryObjectID_List stepObjects = this.newResultsList();
        if (step.m_bHasLastFunction) {
            CacheEntry entry2;
            int iLastObj = this.cache.executeLastFunction(parentObject, step.m_iRetentionClass);
            if (iLastObj >= 0 && step.TestCacheEntry(iLastObj, this, entry2 = this.cache.getObjectWithId(iLastObj), null, false)) {
                stepObjects.add(entry2, null);
            }
        } else if (step.axis_ == 7 || step.axis_ == 8) {
            this.processDescendantAxis(step, stepObjects, parentObjects, parentObject, currentObjectId, bLastStep, numFailed);
        } else {
            boolean bQuickFound = this.testQuickLookup(step, false, parentObject, stepObjects);
            if (!bQuickFound) {
                this.cache.getChildrenOf(this, parentObject, stepObjects, step, null);
            }
        }
        if (step.axis_ == 8 && (!bLastStep || this.forAction != 2 || numFailed.intValue() == 0) && step.TestCacheEntry(parentObject, this, entry = this.cache.getObjectWithId(parentObject), null, false)) {
            stepObjects.add(entry, null);
        }
        if (bLastStep && stepObjects.size() > 0 && this.forAction == 7) {
            this.cache.getLastEntryCache().clearAllLastEntries(this.cache.getObjectWithId(parentObject));
        }
        MutableReference policyRef = new MutableReference(parentObjects.acquiredPolicyAt(currentObjectId));
        step.objects.moveList(this, stepObjects, step, policyRef);
    }

    private void processDescendantAxis(QueryPathStep step, QueryObjectID_List stepObjects, QueryObjectID_List parentObjects, int parentObject, int currentObjectId, boolean bLastStep, MutableInteger numFailed) {
        boolean bQuickFound = this.testQuickLookup(step, true, parentObject, stepObjects);
        if (!bQuickFound && !step.m_bwillSelectNone) {
            QueryObjectID_List children = this.newResultsList();
            this.cache.getAllChildrenOf(parentObject, children, this.useAccessManager() ? parentObjects.acquiredPolicyAt(currentObjectId) : null);
            QueryObjectID_List descendants = this.newResultsList();
            numFailed.increment(this.GetDescendants(step, children, descendants, bLastStep, true));
            MutableReference policyRef = new MutableReference(parentObjects.acquiredPolicyAt(currentObjectId));
            stepObjects.moveList(this, descendants, null, policyRef);
            stepObjects.moveList(this, children, step, policyRef);
        }
    }

    private void processAncestorAxis(QueryPathStep step, int parentObject, boolean bLastStep, MutableInteger numFailed) {
        CacheEntry entry;
        for (entry = this.cache.getObjectWithId(parentObject).getParent(); entry != CacheTypes.UNSET && !entry.isRoot() && !step.objects.contains(entry); entry = entry.getParent()) {
            if (!step.TestCacheEntry(entry.getObjectId(), this, entry, null, true)) continue;
            step.objects.add(entry, null);
        }
        if (step.axis_ == 14 && (!bLastStep || this.forAction != 2 || 0 == numFailed.intValue()) && step.TestCacheEntry(parentObject, this, entry = this.cache.getObjectWithId(parentObject), null, false)) {
            step.objects.add(entry, null);
        }
    }

    private void processParentAxis(QueryPathStep step, int parentObject) {
        CacheEntry parentEntry = this.cache.getObjectWithId(parentObject);
        CacheEntry grandParentEntry = parentEntry.getParent();
        if (grandParentEntry == CacheTypes.UNSET) {
            grandParentEntry = parentEntry;
        }
        int obj_id = grandParentEntry.getObjectId();
        if (!step.objects.contains(grandParentEntry) && step.TestCacheEntry(obj_id, this, grandParentEntry, null, true)) {
            step.objects.add(grandParentEntry, null);
        }
    }

    private boolean testQuickLookup(QueryPathStep step, boolean bDescendant, int parentObject, QueryObjectID_List stepObjects) {
        if (AdvancedSettings.QUICK_LOOKUP_ENABLED) {
            boolean bQuickFound = false;
            if (step.isSimple() && step.m_bwillSelectNone) {
                bQuickFound = false;
            } else if (step.isSimple() && (step.m_bquickLookupGloballyUnique || !bDescendant) && step.m_quickLookupValue > 0 && CMCacheJavaImpl.gblCache.isObjectValid(step.m_quickLookupValue)) {
                CacheEntry validEntry = CMCacheJavaImpl.gblCache.getObjectWithId(step.m_quickLookupValue);
                if (!bDescendant && validEntry.getParent().getObjectId() != parentObject) {
                    return false;
                }
                if (bDescendant && (step.m_quickLookupValue == parentObject || !CMCacheJavaImpl.gblCache.isAncestor(step.m_quickLookupValue, parentObject))) {
                    step.m_bwillSelectNone = true;
                    return false;
                }
                CacheEntry entry = validEntry;
                if (step.TestCacheEntry(step.m_quickLookupValue, this, entry, null, false)) {
                    stepObjects.add(entry, null);
                    bQuickFound = true;
                }
            }
            if (step.m_bquickLookupGloballyUnique && !bQuickFound) {
                step.m_bwillSelectNone = true;
            }
            return bQuickFound;
        }
        return false;
    }

    @Override
    @Deprecated
    public void freeMem() {
        this.results.empty();
    }

    @Override
    public void setLockManagerInfo(int iHandle, int lockType) {
        this.m_LockType = lockType;
        if (iHandle < 0) {
            try {
                this.m_LockManagerHandle = CacheLockHandlerJavaImpl.getGlobalLockHandler().getCurrentHandle();
            }
            catch (CMException e) {
                throw new CMRuntimeException(e);
            }
        } else {
            this.m_LockManagerHandle = iHandle;
        }
    }

    @Override
    public void setAccMan(ICacheAccessMan accMan) {
        this.m_accessMan = accMan;
    }

    @Override
    public void setAction(int for_action) {
        this.forAction = for_action;
    }

    @Override
    public int getAction() {
        return this.forAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void Parse(String sQuery, int[] startObjects, int numStartObjects) {
        int steplen;
        if (sQuery.length() == 0) {
            return;
        }
        this.results = this.newResultsList();
        ArrayList<QueryPathStep> stepList = new ArrayList<QueryPathStep>();
        if (sQuery.equals("/")) {
            this.results.add(this.cache.getObjectWithId(0));
            return;
        }
        int path_offset = 1;
        int iCurrentStep = -1;
        if (sQuery.startsWith("F")) {
            path_offset = 0;
        }
        do {
            ++iCurrentStep;
            QueryPathStep step = new QueryPathStep(this);
            stepList.add(step);
            steplen = step.Parse(sQuery, path_offset);
            path_offset += steplen;
        } while (steplen > 0);
        if (stepList.size() > 0) {
            stepList.remove(stepList.size() - 1);
        }
        QueryObjectID_List rootObject = this.newResultsList();
        QueryObjectID_List parentObjects = null;
        int iStepNum = 0;
        if (startObjects == null) {
            rootObject.add(this.cache.getObjectWithId(0));
            parentObjects = rootObject;
        } else {
            QueryPathStep step = (QueryPathStep)stepList.get(iStepNum);
            for (int iobj = 0; iobj < numStartObjects; ++iobj) {
                MutableReference testPolicyRef;
                CacheEntry entry;
                int obj_id = startObjects[iobj];
                if (!this.cache.isObjectValid(obj_id) || !step.TestCacheEntry(obj_id, this, entry = this.cache.getObjectWithId(obj_id), testPolicyRef = new MutableReference(null), true)) continue;
                step.objects.add(entry, (PolicyCacheEntry)testPolicyRef.getReference());
            }
            ++iStepNum;
            parentObjects = step.objects;
        }
        MutableInteger numFailed = new MutableInteger(0);
        int lastStepNum = iCurrentStep - 1;
        while (iStepNum <= lastStepNum) {
            QueryPathStep step = (QueryPathStep)stepList.get(iStepNum);
            if (step.axis_ > 100) {
                int iFunction = step.axis_ - 100;
                if (iFunction == 19 || iFunction == 32 || iFunction == 36) {
                    String dataSrcName = step.stepnametest_;
                    if (startObjects == null) {
                        this.cache.getDataSources(dataSrcName, 0, step.objects, this.m_accessMan, null);
                        if (iFunction == 32) {
                            this.cache.getPersonalDataSources(dataSrcName, 0, step.objects, this.m_accessMan, null);
                        }
                    } else {
                        this.cache.getDataSources(startObjects, step.objects, this.m_accessMan, null);
                    }
                } else if (iFunction == 28) {
                    CacheEntry entry = this.cache.getObjectWithStoreId(step.stepnametest_);
                    if (entry != null) {
                        step.objects.add(entry);
                    }
                } else {
                    if (iFunction != 15) throw new CacheException("cache query uses unsupported function: " + sQuery);
                    String camid = step.stepnametest_;
                    CachedProperty idProperty = this.cache.getCachedPropertyType(9);
                    CacheEntry entry = this.cache.quickLookup(idProperty, camid);
                    if (entry != null) {
                        step.objects.add(entry);
                    }
                }
            } else {
                this.parseQueryStep(parentObjects, step, numFailed, iStepNum >= lastStepNum);
            }
            parentObjects = step.objects;
            ++iStepNum;
        }
        QueryPathStep lastStep = (QueryPathStep)stepList.get(lastStepNum);
        this.results.moveList(this, lastStep.objects, lastStep, null);
        stepList.clear();
        if (this.m_accessMan != null) {
            this.m_accessMan.checkTraverseAccessTree(this.results);
        }
        this.results.sort();
    }

    @Override
    public QueryObjectID_List newResultsList() {
        CacheEntryFilter filter = CacheEntryFilter.NO_FILTERING;
        if (this.m_accessMan != null) {
            filter = this.m_accessMan.getFilter();
        }
        QueryObjectID_List resultsList = filter != CacheEntryFilter.NO_FILTERING ? new FilteredQueryObjectID_List(filter) : new QueryObjectID_List();
        return resultsList;
    }

    @Override
    public int GetDescendants(QueryPathStep step, QueryObjectID_List parentObjects, QueryObjectID_List descendants, boolean bLastStep, boolean bThrowIfDenied) {
        int numFailed = 0;
        for (int iparentid = 0; iparentid < parentObjects.size(); ++iparentid) {
            QueryObjectID_List descendant_children = this.newResultsList();
            CacheEntry parentEntry = parentObjects.entryAt(iparentid);
            int numchildrenfailed = 0;
            MutableReference testPolicyRef = new MutableReference(null);
            if (parentEntry.getHasSecurity() && this.useAccessManager()) {
                testPolicyRef.setValue(parentObjects.acquiredPolicyAt(iparentid));
                if (!this.m_accessMan.checkTraverseAccessObject(parentEntry.getObjectId(), testPolicyRef)) continue;
            }
            this.cache.getAllChildrenOf(parentEntry.getObjectId(), descendant_children, (PolicyCacheEntry)testPolicyRef.getReference());
            if (descendant_children.size() > 0) {
                QueryObjectID_List children_descendants = this.newResultsList();
                numFailed += (numchildrenfailed += this.GetDescendants(step, descendant_children, children_descendants, bLastStep, bThrowIfDenied));
                descendants.moveList(this, children_descendants, null, null);
                descendants.moveList(this, descendant_children, step, null);
            }
            if (!bLastStep || this.forAction != 7 || descendants.size() <= 0) continue;
            this.cache.getLastEntryCache().clearAllLastEntries(parentEntry);
        }
        return numFailed;
    }

    @Override
    public int getNumberOfResultObjects() {
        return this.results.size();
    }

    @Override
    public int getNumberOfResultDistinctClasses() {
        return this.results.numDistinctClasses();
    }

    @Override
    public void getResultObjects(ArrayList<Integer> endobjects) {
        endobjects.addAll(this.results.getObjectIdArray());
    }

    @Override
    public void getResultClasses(ArrayList<Integer> class_ids) {
        class_ids.addAll(this.results.getClassTypeArray());
    }

    @Override
    public void getResultDistinctClasses(ArrayList<Integer> class_ids) {
        class_ids.addAll(this.results.getDistinctClassTypeArray());
    }

    @Override
    public int getResultSelectionInfo() {
        return this.results.getSelectionInfo();
    }

    @Override
    public String getObjectPath(int object_num, int[] pLocales, int numLocales) {
        if (object_num >= this.results.size()) {
            throw new CacheException("CacheQuery.getObjectPath", "Index out of range.");
        }
        ArrayList<CacheEntry> parents = new ArrayList<CacheEntry>();
        this.cache.getParentsPath(this.results.entryAt(object_num).getObjectId(), parents);
        int numpaths = 0;
        if (parents.size() <= 0) {
            return "/";
        }
        String[] sympath = new String[parents.size() + 1];
        for (int i = 0; i < parents.size(); ++i) {
            sympath[numpaths++] = this.cache.getName(parents.get(i), pLocales);
        }
        int obj = this.results.entryAt(object_num).getObjectId();
        sympath[numpaths++] = this.cache.getName(obj, pLocales);
        StringBuffer path = new StringBuffer();
        for (int i = 1; i < numpaths; ++i) {
            path.append("/");
            path.append(sympath[i]);
        }
        return path.toString();
    }

    @Override
    public void trimObjects(int obj_first, int obj_last) {
        if (obj_first >= this.results.size() || obj_last >= this.results.size() || obj_first < 0 || obj_last < 0) {
            throw new CacheException("CacheQuery.trimObjects", "Index out of range.");
        }
        if (obj_last >= obj_first) {
            this.results.trimObjects(obj_first, obj_last);
        }
    }

    @Override
    public String getObjectStringProperty(int obj_num, int requested_prop, int[] pLocales) {
        String sProp = null;
        if (obj_num >= this.results.size()) {
            throw new CacheException("CacheQuery.getObjectStringProperty", "Index out of range: index=" + obj_num + " . Property is " + debugPropertyStrings[requested_prop]);
        }
        CacheEntry entry = this.results.entryAt(obj_num);
        sProp = this.cache.getStringProperty(entry.getObjectId(), requested_prop, pLocales);
        return sProp;
    }

    @Override
    public int getObjectIntProperty(int obj_num, int requested_prop) {
        int ret;
        if (obj_num >= this.results.size()) {
            throw new CacheException("CacheQuery.getObjectIntProperty", "Index out of range. Property is " + debugPropertyStrings[requested_prop]);
        }
        CacheEntry entry = this.results.entryAt(obj_num);
        switch (requested_prop) {
            case 5: {
                ret = entry.getParent().getObjectId();
                break;
            }
            case 1: {
                boolean b = entry.getHasRecipients() || entry.getHasRecipientsEmail();
                ret = b ? 1 : 0;
                break;
            }
            case 15: {
                ret = entry.getHasRecipients() ? 1 : 0;
                break;
            }
            case 16: {
                ret = entry.getHasRecipientsEmail() ? 1 : 0;
                break;
            }
            case 9: {
                ret = entry.getHasCredNamespace() ? 1 : 0;
                break;
            }
            case 12: {
                ret = entry.getOutputFormat();
                break;
            }
            case 11: {
                ret = entry.getLocale();
                break;
            }
            default: {
                ret = -1;
            }
        }
        if (ret == -1) {
            throw new CacheException("CacheQuery.getObjectIntProperty", "Invalid property specified.");
        }
        return ret;
    }

    @Override
    public ArrayList<Integer> CheckAppActionAccess(int obj_num, int numActions, int deletecheck) {
        ArrayList<Integer> iRets = new ArrayList<Integer>();
        PolicyCacheEntry policy = null;
        CacheEntry entry = this.results.entryAt(obj_num);
        policy = this.results.acquiredPolicyAt(obj_num);
        if (policy == null || policy.getPolicyBytes() == null) {
            for (int i = 0; i < numActions; ++i) {
                iRets.add(GRANTED);
            }
        } else {
            try {
                this.m_accessMan.checkAppActionAccess(iRets, policy);
            }
            catch (AAAException aaaExcp) {
                throw new CMRuntimeException(aaaExcp);
            }
            if (!(deletecheck != 1 && deletecheck != 2 || this.m_accessMan.checkAccessPolicy("write", policy))) {
                boolean bFailed = true;
                if (deletecheck == 2) {
                    boolean bl = bFailed = !this.m_accessMan.checkAccessPolicy("setPolicy", policy);
                }
                if (bFailed) {
                    try {
                        bFailed = !this.cache.getCMCallbacks().CurrentUserIsObjectOwner(entry.getParent().getObjectId());
                    }
                    catch (CMException cme) {
                        throw new CMRuntimeException(cme);
                    }
                }
                if (bFailed) {
                    throw new CMCacheAccessDenied("write", policy.getObjID());
                }
            }
        }
        return iRets;
    }

    private boolean isCacheEntryOutputFormatSupported(CacheEntry entry, int[] supportedFormats) {
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (entry.getOutputFormat() != supportedFormats[i]) continue;
            return true;
        }
        return false;
    }

    private boolean areSupportedFormatsProvided(int[] supportedFormats) {
        return supportedFormats != null && supportedFormats.length != 0;
    }

    @Override
    public int getDefaultOutput(int obj_num, int grantedAccess, int[] pLocales, int numLocales, int format, int[] supportedFormats) throws CMException {
        int preferredLocale = this.LOCALE(pLocales[0]);
        int preferredLocaleMapped = numLocales == 2 ? this.LOCALE(pLocales[1]) : preferredLocale;
        CacheEntry baseEntry = this.results.entryAt(obj_num);
        int baseObjectID = baseEntry.getObjectId();
        CacheEntry cacheEntry = this.cache.getObjectWithId(baseObjectID);
        int reportVersionType = this.cache.getSpecialClassId("reportVersion");
        if (cacheEntry.getType() != reportVersionType && null == (cacheEntry = this.getLastReportVersionChildFromObject(baseObjectID, reportVersionType))) {
            return -1;
        }
        return this.getDefaultOutputForReportVersion(cacheEntry, grantedAccess, preferredLocale, preferredLocaleMapped, format, supportedFormats);
    }

    private CacheEntry getLastReportVersionChildFromObject(int parentId, int reportVersionType) {
        CacheEntry cacheEntry = null;
        int lastReportVersionId = this.cache.executeLastFunction(parentId, reportVersionType);
        if (-1 != lastReportVersionId) {
            cacheEntry = this.cache.getObjectWithId(lastReportVersionId);
        }
        return cacheEntry;
    }

    private int getDefaultOutputForReportVersion(CacheEntry entryReportVersion, int grantedAccess, int preferredLocale, int preferredLocaleMapped, int format, int[] supportedFormats) throws CMException {
        if (entryReportVersion.getFirstChild() == CacheTypes.UNSET) {
            return 0;
        }
        if (this.useAccessManager()) {
            if (entryReportVersion.getHasSecurity()) {
                grantedAccess &= 0xFFFFFFE0;
                PolicyCacheEntry policy = this.m_accessMan.getObjectPolicy(entryReportVersion.getObjectId(), null);
                if (policy != null) {
                    if (this.m_accessMan.checkAccessPolicy("read", policy)) {
                        grantedAccess |= 1;
                    }
                    if (this.m_accessMan.checkAccessPolicy("traverse", policy)) {
                        grantedAccess |= 2;
                    }
                    if (this.m_accessMan.checkAccessPolicy("write", policy)) {
                        grantedAccess |= 4;
                    }
                    if (this.m_accessMan.checkAccessPolicy("setPolicy", policy)) {
                        grantedAccess |= 8;
                    }
                }
            }
            if (entryReportVersion.getDisabled() != null) {
                grantedAccess = entryReportVersion.getDisabled().booleanValue() ? (grantedAccess |= 0x20) : (grantedAccess &= 0xFFFFFFDF);
            }
            int reportVersionPerms = grantedAccess;
            if (this.DISABLED(grantedAccess) && !this.ISGRANTED(grantedAccess, 12)) {
                reportVersionPerms &= 0xFFFFFFEC;
            }
            if (!this.ISGRANTED(reportVersionPerms, 2) && !this.cache.getCMCallbacks().CurrentUserIsObjectOwner(entryReportVersion.getObjectId())) {
                return -1;
            }
            if (!this.ISGRANTED(grantedAccess, 1)) {
                return 0;
            }
        }
        DefaultOutputEntry exactLocaleMatch = new DefaultOutputEntry();
        DefaultOutputEntry exactMappedLocaleMatch = new DefaultOutputEntry();
        DefaultOutputEntry mappedLocaleMatch = new DefaultOutputEntry();
        DefaultOutputEntry noMatchDefault = new DefaultOutputEntry();
        int output_type = this.getCache().getSpecialClassId("output");
        for (CacheEntry childentry = entryReportVersion.getFirstChild(); childentry != CacheTypes.UNSET; childentry = childentry.getSibling()) {
            if (childentry.getType() != output_type || this.areSupportedFormatsProvided(supportedFormats) && !this.isCacheEntryOutputFormatSupported(childentry, supportedFormats)) continue;
            int childPermissions = grantedAccess;
            boolean requiresPermCheck = false;
            if (this.useAccessManager()) {
                if (childentry.getHasRecipients() || childentry.getHasRecipientsEmail()) {
                    return 0;
                }
                if (childentry.getDisabled() != null && childentry.getDisabled().booleanValue()) {
                    childPermissions |= 0x20;
                }
                requiresPermCheck = this.DISABLED(childPermissions) && !childentry.getHasSecurity() && !this.ISGRANTED(childPermissions, 1) && !this.ISGRANTED(childPermissions, 12) || childentry.getHasSecurity();
            }
            DefaultOutputEntry entry = null;
            int currentFormat = childentry.getOutputFormat();
            boolean formatMatches = currentFormat == format;
            int outputLocale = childentry.getLocale();
            int outputLocaleMapped = this.MAPPEDLOCALE(outputLocale);
            outputLocale = this.LOCALE(outputLocale);
            if (!formatMatches && !this.isVisibleFormat(currentFormat)) continue;
            if (outputLocale == preferredLocale) {
                if (formatMatches && !requiresPermCheck) {
                    return childentry.getObjectId();
                }
                entry = exactLocaleMatch;
            } else {
                entry = outputLocale == preferredLocaleMapped ? exactMappedLocaleMatch : (outputLocaleMapped == preferredLocaleMapped ? mappedLocaleMatch : noMatchDefault);
            }
            if (entry.objID == 0) {
                entry.objID = childentry.getObjectId();
                entry.formatMatches = formatMatches;
                entry.requiresPermCheck = requiresPermCheck;
                continue;
            }
            if (formatMatches && (!entry.formatMatches || entry.requiresPermCheck && !requiresPermCheck)) {
                entry.objID = childentry.getObjectId();
                entry.formatMatches = formatMatches;
                entry.requiresPermCheck = requiresPermCheck;
                continue;
            }
            if (!entry.requiresPermCheck || requiresPermCheck) continue;
            entry.objID = childentry.getObjectId();
            entry.formatMatches = formatMatches;
            entry.requiresPermCheck = requiresPermCheck;
        }
        if (exactLocaleMatch.objID != 0) {
            if (exactLocaleMatch.requiresPermCheck) {
                return 0;
            }
            return exactLocaleMatch.objID;
        }
        if (exactMappedLocaleMatch.objID != 0) {
            if (exactMappedLocaleMatch.requiresPermCheck) {
                return 0;
            }
            return exactMappedLocaleMatch.objID;
        }
        if (mappedLocaleMatch.objID != 0) {
            if (mappedLocaleMatch.requiresPermCheck) {
                return 0;
            }
            return mappedLocaleMatch.objID;
        }
        if (noMatchDefault.objID != 0) {
            if (noMatchDefault.requiresPermCheck) {
                return 0;
            }
            return noMatchDefault.objID;
        }
        return -1;
    }

    private boolean isVisibleFormat(int format) {
        return format != 12 && format != 10;
    }

    @Override
    public ICache getCache() {
        return this.cache;
    }

    @Override
    public QueryObjectID_List getResults() {
        return this.results;
    }

    @Override
    public ICacheAccessMan getAccessMan() {
        return this.m_accessMan;
    }

    public int getLockManagerHandle() {
        return this.m_LockManagerHandle;
    }

    public int getLockType() {
        return this.m_LockType;
    }

    protected void setAccessMan(ICacheAccessMan accessMan) {
        this.m_accessMan = accessMan;
    }

    @Override
    public QueryPathStep createPathStep() {
        return new QueryPathStep(this);
    }

    private static class DefaultOutputEntry {
        int objID = 0;
        boolean formatMatches = false;
        boolean requiresPermCheck = false;

        DefaultOutputEntry() {
        }
    }
}

