/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheFreeList;
import com.cognos.cm.cache.query.CacheQuery;
import com.cognos.cm.cache.query.ICacheQuery;
import java.util.HashMap;
import java.util.Map;

public class CacheQueryCache {
    private long max_objects;
    private Map<Integer, CacheQuery> map_;
    private CacheFreeList freelist_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheQuery QUERY_IDToPtr(int queryId) {
        if ((long)queryId > this.max_objects) {
            throw new CacheException("CacheQueryCache.QUERY_IDToPtr", "Object id > maximum allowed object id.");
        }
        Integer key = new Integer(queryId);
        CacheQueryCache cacheQueryCache = this;
        synchronized (cacheQueryCache) {
            if (!this.map_.containsKey(key)) {
                this.map_.put(key, this.createCacheQuery());
            }
            return this.map_.get(key);
        }
    }

    protected CacheQuery createCacheQuery() {
        return new CacheQuery(CMCacheJavaImpl.gblCache);
    }

    public CacheQueryCache(long max_num_objs) {
        this.max_objects = max_num_objs;
        this.map_ = new HashMap<Integer, CacheQuery>();
        this.freelist_ = new CacheFreeList(max_num_objs);
    }

    public synchronized int allocateQuery() {
        return this.freelist_.allocateBlock();
    }

    public synchronized void deleteQuery(int id) {
        this.map_.remove(new Integer(id));
        this.freelist_.freeBlock(id);
    }
}

