/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.query.QueryPathPredicate;
import com.cognos.cm.cache.query.QueryPathStep;

public class CacheQueryParser {
    QueryPathStep step;
    String s;
    int offset;

    CacheQueryParser(QueryPathStep step, String s) {
        this(step, s, 0);
    }

    CacheQueryParser(QueryPathStep step, String s, int offset) {
        this.step = step;
        this.s = s;
        this.offset = offset;
    }

    char charAt() {
        return this.s.charAt(this.offset);
    }

    boolean charEquals(char equalsChar) {
        boolean equals = this.offset < this.s.length() ? this.s.charAt(this.offset) == equalsChar : false;
        return equals;
    }

    boolean hasNext() {
        return this.offset < this.s.length();
    }

    void next() {
        ++this.offset;
    }

    void next(int increment) {
        this.offset += increment;
    }

    int getOffset() {
        return this.offset;
    }

    public String substring(int length) {
        return this.s.substring(this.offset, this.offset + length);
    }

    boolean matches(String substr) {
        return this.s.regionMatches(this.offset, substr, 0, substr.length());
    }

    int parseInt() {
        int subIdx1 = this.offset;
        while (this.hasNext() && this.charAt() >= '0' && this.charAt() <= '9') {
            this.next();
        }
        int ret = 0;
        if (this.offset > subIdx1) {
            String substr = this.s.substring(subIdx1, this.offset);
            ret = Integer.parseInt(substr);
        }
        return ret;
    }

    QueryPathPredicate parsePredicate() {
        QueryPathPredicate preds = null;
        if (!this.charEquals('/') && !(preds = new QueryPathPredicate(this, this.step)).isValid()) {
            preds = null;
        }
        return preds;
    }

    String parseLiteral(int length) {
        String subString = this.s.substring(this.offset, this.offset + length);
        this.next(subString.length());
        return subString;
    }

    public String toString() {
        return this.s.substring(this.offset);
    }
}

