/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CheckTraverseAccessTreeEntry;
import java.util.ArrayList;

public class CheckTraverseAccessTree {
    private ICacheAccessMan accessMan;
    private CheckTraverseAccessTreeEntry root;

    public CheckTraverseAccessTree(ICacheAccessMan accessMan, CheckTraverseAccessTreeEntry root) {
        this.accessMan = accessMan;
        this.root = root;
    }

    private CacheEntry getCacheEntry(int objId) {
        return CMCacheJavaImpl.gblCache.getObjectWithId(objId);
    }

    private boolean isObjectDisabled(int objId) {
        return CMCacheJavaImpl.gblCache.isObjectDisabled(objId);
    }

    private boolean currentUserIsObjectOwner(int objId) {
        return CMCacheJavaImpl.gblCache.currentUserIsObjectOwner(objId);
    }

    private void checkAccess(CheckTraverseAccessTreeEntry entry, MissingPolicyHandler missingPolicy) {
        int objectID = entry.getObjectID();
        boolean hasSecurity = this.getCacheEntry(objectID).getHasSecurity();
        if (!entry.isAccessChecked() && entry.hasChildren()) {
            if (hasSecurity && !entry.hasPolicy()) {
                entry.setPolicy(this.accessMan.findPolicy(objectID));
                if (!entry.hasPolicy()) {
                    missingPolicy.handle(objectID);
                }
            }
            if (hasSecurity && entry.hasPolicy()) {
                entry.grantAccess(this.canAccess(entry));
                if (entry.isAccessDenied()) {
                    this.invalidateDescendants(entry);
                }
            }
        }
        for (CheckTraverseAccessTreeEntry child = entry.getFirstChild(); child != null; child = child.getSibling()) {
            if (!child.hasChildren()) continue;
            this.checkAccess(child, missingPolicy);
        }
    }

    private boolean canAccess(CheckTraverseAccessTreeEntry entry) {
        int objectID = entry.getObjectID();
        boolean hasAccess = this.accessMan.checkTraverseAccessPolicy(entry.getPolicy());
        boolean isOwner = false;
        boolean isDisabled = false;
        if (hasAccess) {
            isDisabled = this.isObjectDisabled(objectID);
        }
        if (!hasAccess || isDisabled) {
            isOwner = this.currentUserIsObjectOwner(objectID);
        }
        if (!hasAccess && isOwner) {
            hasAccess = true;
        }
        if (hasAccess && isDisabled && !isOwner) {
            hasAccess = this.accessMan.checkDisabledAccessPolicy(entry.getPolicy());
        }
        return hasAccess;
    }

    private void invalidateDescendants(CheckTraverseAccessTreeEntry parent) {
        for (CheckTraverseAccessTreeEntry child = parent.getFirstChild(); child != null; child = child.getSibling()) {
            child.grantAccess(false);
            this.invalidateDescendants(child);
        }
    }

    public void checkAccess() {
        ArrayList<Integer> policiesToLoad = new ArrayList<Integer>();
        CheckTraverseAccessTreeEntry root = this.getRoot();
        this.checkAccess(root, id -> policiesToLoad.add(id));
        if (!policiesToLoad.isEmpty()) {
            this.accessMan.getAndCachePolicies(policiesToLoad);
        }
        this.checkAccess(root, id -> this.throwMissingPolicyException(id));
    }

    private void throwMissingPolicyException(int id) {
        throw new CacheException("Could not find policy for object id (" + id + ")");
    }

    public CheckTraverseAccessTreeEntry getRoot() {
        return this.root;
    }

    private static interface MissingPolicyHandler {
        public void handle(int var1);
    }
}

