/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.PolicyCacheEntry;

public class CheckTraverseAccessTreeEntry {
    private int id;
    private PolicyCacheEntry policy;
    private boolean accessDenied;
    private boolean accessChecked;
    private CheckTraverseAccessTreeEntry sibling;
    private CheckTraverseAccessTreeEntry parent;
    private CheckTraverseAccessTreeEntry firstChild;

    public CheckTraverseAccessTreeEntry(int obj, PolicyCacheEntry policy) {
        this.policy = policy;
        this.id = obj;
    }

    public void setPolicy(PolicyCacheEntry policy) {
        this.policy = policy;
    }

    public PolicyCacheEntry getPolicy() {
        return this.policy;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public boolean isAccessDenied() {
        return this.accessDenied;
    }

    public boolean isAccessChecked() {
        return this.accessChecked;
    }

    public void grantAccess(boolean value) {
        this.accessDenied = !value;
        this.accessChecked = true;
    }

    public int getObjectID() {
        return this.id;
    }

    public void setParent(CheckTraverseAccessTreeEntry parent) {
        this.parent = parent;
    }

    public CheckTraverseAccessTreeEntry getParent() {
        return this.parent;
    }

    public CheckTraverseAccessTreeEntry getFirstChild() {
        return this.firstChild;
    }

    public boolean hasChildren() {
        return this.firstChild != null;
    }

    public CheckTraverseAccessTreeEntry getSibling() {
        return this.sibling;
    }

    public void addChild(CheckTraverseAccessTreeEntry child) {
        child.setParent(this);
        if (this.firstChild == null) {
            this.firstChild = child;
        } else {
            this.firstChild.addSibling(child);
        }
    }

    private void addSibling(CheckTraverseAccessTreeEntry sibling) {
        CheckTraverseAccessTreeEntry entry = this;
        while (entry.sibling != null) {
            entry = entry.sibling;
        }
        entry.sibling = sibling;
    }

    public CheckTraverseAccessTreeEntry findChild(int id) {
        CheckTraverseAccessTreeEntry child = this.firstChild;
        while (child != null) {
            if (child.id == id) {
                return child;
            }
            child = child.sibling;
        }
        return null;
    }
}

