/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.PolicyCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheQuery;
import com.cognos.cm.cache.query.QueryObjectID_List_Object;
import com.cognos.cm.cache.query.QueryPathStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class QueryObjectID_List {
    protected static final QueryObjectID_List EMPTY = new QueryObjectID_List(){

        @Override
        protected List<QueryObjectID_List_Object> allocate() {
            return Collections.emptyList();
        }
    };
    private List<QueryObjectID_List_Object> list_ = this.allocate();
    private boolean atLeastOneHasPolicies_ = false;
    private boolean atLeastOneIsBurstOutput_ = false;

    private void q_sort() {
        Collections.sort(this.list_);
    }

    protected List<QueryObjectID_List_Object> allocate() {
        return new ArrayList<QueryObjectID_List_Object>();
    }

    public ListIterator<QueryObjectID_List_Object> begin() {
        return this.list_.listIterator();
    }

    public void moveList(CacheQuery query2, QueryObjectID_List list, QueryPathStep step, MutableReference policyRef) {
        for (int i = 0; i < list.size(); ++i) {
            CacheEntry entry = list.entryAt(i);
            if (null != step && !step.TestCacheEntry(entry.getObjectId(), query2, entry, policyRef, false)) continue;
            this.list_.add((QueryObjectID_List_Object)list.objectAt(i).clone());
        }
        if (list.atLeastOneHasPolicies_) {
            this.atLeastOneHasPolicies_ = true;
        }
        if (list.atLeastOneIsBurstOutput_) {
            this.atLeastOneIsBurstOutput_ = true;
        }
    }

    public void add(CacheEntry entry) {
        this.add(entry, null);
    }

    public void add(CacheEntry entry, PolicyCacheEntry policy) {
        QueryObjectID_List_Object newObject = new QueryObjectID_List_Object(entry);
        newObject.setPolicy(policy);
        if (null != entry) {
            if (entry.getHasSecurity()) {
                this.atLeastOneHasPolicies_ = true;
            }
            if (entry.getHasRecipients() || entry.getHasRecipientsEmail()) {
                this.atLeastOneIsBurstOutput_ = true;
            }
        } else {
            this.atLeastOneHasPolicies_ = true;
            this.atLeastOneIsBurstOutput_ = true;
        }
        this.list_.add(newObject);
    }

    public void sort() {
        this.q_sort();
        for (int i = 1; i < this.list_.size(); ++i) {
            int previous;
            int current = this.entryAt(i).getObjectId();
            if (current != (previous = this.entryAt(i - 1).getObjectId())) continue;
            this.list_.remove(i--);
        }
    }

    public int size() {
        return this.list_.size();
    }

    public QueryObjectID_List_Object objectAt(int index) {
        return this.get(index);
    }

    public CacheEntry entryAt(int index) {
        if (index > this.list_.size()) {
            throw new IllegalStateException("The object ID list does not contain a value at that position");
        }
        QueryObjectID_List_Object object = this.get(index);
        return object.getCacheEntry();
    }

    public boolean contains(CacheEntry entry) {
        for (QueryObjectID_List_Object object : this.list_) {
            if (null == object || entry != object.getCacheEntry()) continue;
            return true;
        }
        return false;
    }

    public PolicyCacheEntry acquiredPolicyAt(int index) {
        QueryObjectID_List_Object object = this.get(index);
        return object.getInheritedPolicy();
    }

    public void setAcquiredPolicyAt(int index, PolicyCacheEntry policy) {
        QueryObjectID_List_Object object = this.get(index);
        object.setPolicy(policy);
    }

    protected QueryObjectID_List_Object get(int index) {
        return this.list_.get(index);
    }

    public void empty() {
        this.list_.clear();
    }

    public ArrayList<Integer> getObjectIdArray() {
        ArrayList<Integer> objectIdArray = new ArrayList<Integer>(this.list_.size());
        for (int i = 0; i < this.list_.size(); ++i) {
            QueryObjectID_List_Object object = this.get(i);
            objectIdArray.add(object.getCacheEntry().getObjectId());
        }
        return objectIdArray;
    }

    public ArrayList<Integer> getClassTypeArray() {
        ArrayList<Integer> classTypeArray = new ArrayList<Integer>(this.list_.size());
        for (int i = 0; i < this.list_.size(); ++i) {
            QueryObjectID_List_Object object = this.get(i);
            classTypeArray.add(object.getCacheEntry().getType());
        }
        return classTypeArray;
    }

    public Collection<Integer> getDistinctClassTypeArray() {
        HashSet<Integer> classTypes = new HashSet<Integer>();
        classTypes.addAll(this.getClassTypeArray());
        return classTypes;
    }

    public int numDistinctClasses() {
        return this.getDistinctClassTypeArray().size();
    }

    public int getSelectionInfo() {
        int info = 0;
        if (this.atLeastOneHasPolicies_) {
            info |= 1;
        }
        if (this.atLeastOneIsBurstOutput_) {
            info |= 2;
        }
        return info;
    }

    public QueryObjectID_List_Object remove(int index) {
        return this.list_.remove(index);
    }

    public int[] toObjectIdArray() {
        int[] iarray = new int[this.list_.size()];
        Iterator<QueryObjectID_List_Object> iter = this.list_.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iarray[i++] = iter.next().getCacheEntry().getObjectId();
        }
        return iarray;
    }

    public void trimObjects(int obj_first, int obj_last) {
        int numToRemove = obj_last - obj_first + 1;
        for (int i = 0; i < numToRemove; ++i) {
            this.remove(obj_first);
        }
    }

    public void addAll(QueryObjectID_List otherList) {
        for (QueryObjectID_List_Object object : otherList.list_) {
            this.add(object.getCacheEntry(), object.getInheritedPolicy());
        }
    }
}

