/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.CachedProperty;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.cache.MLProp;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheQueryParser;
import com.cognos.cm.cache.query.ICacheQuery;
import com.cognos.cm.cache.query.QueryPathStep;
import com.cognos.cm.properties.CMObjectClass;

public class QueryPathPredicate {
    private int m_iProperty;
    private int m_iValue;
    private String m_sNameValue;
    private String m_sFunctionValue;
    private int m_iExpression;
    private int m_iBoolExpression;
    private QueryPathPredicate m_pNextExpression;
    private MLEntry m_mlEntry;

    public QueryPathPredicate() {
        this.m_iBoolExpression = 1;
        this.m_iExpression = 0;
    }

    public QueryPathPredicate(CacheQueryParser parser, QueryPathStep pStep) {
        this(parser, 1, pStep);
    }

    public QueryPathPredicate(CacheQueryParser parser, int iBoolExpression, QueryPathStep pStep) {
        this.m_pNextExpression = null;
        this.m_iProperty = 0;
        this.m_iBoolExpression = iBoolExpression;
        this.m_iExpression = 0;
        this.m_iValue = -1;
        this.m_sNameValue = null;
        this.Parse(parser, pStep);
    }

    public boolean isValid() {
        if (this.m_iProperty < 1 || this.m_iProperty > 17) {
            return false;
        }
        if (this.m_iProperty < 6 && this.m_iExpression == 0) {
            return false;
        }
        if (this.m_pNextExpression != null) {
            return this.m_pNextExpression.isValid();
        }
        return true;
    }

    public void Parse(CacheQueryParser parser, QueryPathStep pStep) {
        while (parser.hasNext() && !parser.charEquals('/')) {
            if (parser.charEquals('@')) {
                parser.next();
                this.m_iProperty = parser.parseInt();
                if (!parser.charEquals(':')) continue;
                parser.next();
                continue;
            }
            if (parser.charEquals(':')) {
                parser.next();
                this.m_iValue = parser.parseInt();
                if (this.m_iProperty == 1 && pStep.m_iRetentionClass < 0) {
                    pStep.m_iRetentionClass = this.m_iValue;
                }
                if (!parser.charEquals(':')) continue;
                parser.next();
                continue;
            }
            if (parser.matches("and")) {
                parser.next(3);
                this.m_pNextExpression = new QueryPathPredicate(parser, 1, pStep);
                continue;
            }
            if (parser.matches("or")) {
                parser.next(2);
                pStep.setIsSimple(false);
                pStep.m_bwillSelectNone = false;
                this.m_pNextExpression = new QueryPathPredicate(parser, 2, pStep);
                continue;
            }
            if (parser.matches("!=")) {
                parser.next(2);
                pStep.setIsSimple(false);
                this.m_iExpression = 2;
                continue;
            }
            if (parser.matches("<=")) {
                parser.next(2);
                this.m_iExpression = 5;
                continue;
            }
            if (parser.matches(">=")) {
                parser.next(2);
                this.m_iExpression = 6;
                continue;
            }
            if (parser.charEquals('=')) {
                parser.next();
                this.m_iExpression = 1;
                continue;
            }
            if (parser.charEquals('<')) {
                parser.next();
                this.m_iExpression = 3;
                continue;
            }
            if (parser.charEquals('>')) {
                parser.next();
                this.m_iExpression = 4;
                continue;
            }
            if (parser.charEquals('F')) {
                parser.next();
                int iFunc = parser.parseInt();
                switch (iFunc) {
                    case 12: {
                        this.m_iProperty = 6;
                        break;
                    }
                    case 14: {
                        this.m_iProperty = 7;
                        break;
                    }
                    case 10: {
                        this.m_iProperty = 8;
                        pStep.m_bHasLastFunction = true;
                        break;
                    }
                    default: {
                        throw new CacheException("Invalid function specified in cache expression: func-id=" + iFunc + " parser=" + parser);
                    }
                }
                if (!parser.charEquals(':')) continue;
                parser.next();
                continue;
            }
            if (parser.charEquals('L')) {
                parser.next();
                int iLength = parser.parseInt();
                if (parser.charEquals(':')) {
                    parser.next();
                }
                String predicateCompareValue = parser.parseLiteral(iLength);
                if (this.isQuickLookupProperty()) {
                    this.m_sNameValue = predicateCompareValue;
                    if (pStep.isSimple()) {
                        CachedProperty property = CMCacheJavaImpl.gblCache.getCachedPropertyType(this.m_iProperty);
                        CacheEntry e = CMCacheJavaImpl.gblCache.quickLookup(property, this.m_sNameValue);
                        int quickLookupId = -1;
                        if (e != null) {
                            quickLookupId = e.getObjectId();
                        } else {
                            pStep.m_bwillSelectNone = true;
                        }
                        pStep.setQuickLookupValue(quickLookupId, true);
                        if (pStep.axis_ == 1) {
                            pStep.setCardinality(QueryPathStep.Cardinality.ZERO_OR_ONE);
                        }
                    }
                } else if (this.m_iProperty == 4) {
                    this.m_sNameValue = predicateCompareValue;
                    if (pStep.isSimple() && pStep.axis_ == 1) {
                        pStep.setCardinality(QueryPathStep.Cardinality.ZERO_OR_ONE);
                    }
                    this.m_mlEntry = MLEntry.createMLEntry(this.m_sNameValue, 0);
                } else if (this.m_iProperty == 6) {
                    this.m_sFunctionValue = predicateCompareValue;
                }
                this.m_iValue = 1;
                continue;
            }
            parser.next();
        }
    }

    private boolean isQuickLookupProperty() {
        return this.m_iProperty == 9 || this.m_iProperty == 14 || this.m_iProperty == 5 || this.m_iProperty == 15 || this.m_iProperty == 16;
    }

    public boolean TestCacheEntry(int objectId, ICacheQuery query2, CacheEntry entry, MutableReference inheritedPolicy, int userIsObjOwner, boolean previousValue, boolean bReturnPolicies) {
        ICache cache = query2.getCache();
        if (this.m_iBoolExpression == 1 && !previousValue) {
            return false;
        }
        boolean bResult = false;
        int iValue = -1;
        switch (this.m_iProperty) {
            case 17: {
                iValue = entry.getTenantId();
                break;
            }
            case 1: {
                iValue = entry.getType();
                break;
            }
            case 2: {
                iValue = entry.getHasRecipients() || entry.getHasRecipientsEmail() ? 1 : 0;
                break;
            }
            case 3: {
                if (entry.getFirstChild() != CacheTypes.UNSET) {
                    iValue = 1;
                    break;
                }
                iValue = 0;
                break;
            }
            case 7: {
                iValue = entry.getHasSecurity() ? 1 : 0;
                break;
            }
            case 6: {
                ICacheAccessMan accMan = query2.getAccessMan();
                if (accMan != null && accMan.isPolicyCheckingEnabled()) {
                    if (userIsObjOwner == 1) {
                        iValue = 1;
                        break;
                    }
                    int n = iValue = accMan.checkPermissionAccess(objectId, this.m_sFunctionValue, inheritedPolicy) ? 1 : 0;
                    if (iValue >= 1) break;
                    if (userIsObjOwner == 0) {
                        userIsObjOwner = cache.currentUserIsObjectOwner(objectId) ? 1 : 2;
                    }
                    if (userIsObjOwner == 1) {
                        iValue = 1;
                        break;
                    }
                    iValue = 0;
                    break;
                }
                if (entry.getType() == cache.getSpecialClassId("namespace") && objectId != cache.getSpecialId("CognosNamespaceID")) {
                    iValue = accMan.checkSysAdminNamespaceAccess(objectId, this.m_sFunctionValue);
                    break;
                }
                iValue = 1;
                break;
            }
            case 4: {
                MLProp entryMLProp = entry.getMLProp();
                if (entryMLProp == null) break;
                iValue = entryMLProp.containsEntry(this.m_mlEntry) ? 1 : 0;
                break;
            }
            case 5: {
                if (entry.getType() != CMObjectClass.DISPATCHER.getID()) break;
                iValue = entry.matchesQuickLookupProperty(this.m_sNameValue) ? 1 : 0;
                break;
            }
            case 15: {
                if (entry.getType() != CMObjectClass.HISTORY.getID()) break;
                iValue = entry.matchesQuickLookupProperty(this.m_sNameValue) ? 1 : 0;
                break;
            }
            case 16: {
                if (entry.getType() != CMObjectClass.GENERICDOCUMENT.getID()) break;
                iValue = entry.matchesQuickLookupProperty(this.m_sNameValue) ? 1 : 0;
                break;
            }
            case 14: {
                if (entry.getType() != CMObjectClass.SCHEDULE.getID()) break;
                iValue = entry.matchesQuickLookupProperty(this.m_sNameValue) ? 1 : 0;
                break;
            }
            case 9: {
                if (!entry.getHasExID()) break;
                iValue = entry.matchesQuickLookupProperty(this.m_sNameValue) ? 1 : 0;
                break;
            }
            case 8: {
                iValue = 1;
                break;
            }
            case 10: {
                iValue = entry.getHasMessage() ? 1 : 0;
                break;
            }
            case 11: {
                iValue = entry.getDeploymentObjectUsage();
                break;
            }
            case 12: {
                iValue = entry.getHasRecipients() ? 1 : 0;
                break;
            }
            case 13: {
                iValue = entry.getHasRecipientsEmail() ? 1 : 0;
            }
        }
        switch (this.m_iExpression) {
            case 1: {
                bResult = iValue == this.m_iValue;
                break;
            }
            case 2: {
                bResult = iValue != this.m_iValue;
                break;
            }
            case 3: {
                bResult = iValue < this.m_iValue;
                break;
            }
            case 4: {
                bResult = iValue > this.m_iValue;
                break;
            }
            case 5: {
                bResult = iValue <= this.m_iValue;
                break;
            }
            case 6: {
                bResult = iValue >= this.m_iValue;
                break;
            }
            case 0: {
                bResult = iValue != 0;
            }
        }
        switch (this.m_iBoolExpression) {
            case 1: {
                bResult = bResult && previousValue;
                break;
            }
            case 2: {
                boolean bl = bResult = bResult || previousValue;
            }
        }
        if (this.m_pNextExpression != null) {
            bResult = this.m_pNextExpression.TestCacheEntry(objectId, query2, entry, inheritedPolicy, userIsObjOwner, bResult, bReturnPolicies);
        }
        return bResult;
    }

    public QueryPathPredicate next() {
        return this.m_pNextExpression;
    }
}

