/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.query;

import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.PolicyCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheQueryParser;
import com.cognos.cm.cache.query.ICacheQuery;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.cache.query.QueryPathPredicate;

public class QueryPathStep {
    protected static final int QPPREDICATE_BOOL_INVALID = 0;
    protected static final int QPPREDICATE_BOOL_AND = 1;
    protected static final int QPPREDICATE_BOOL_OR = 2;
    protected static final int QPPREDICATE_EXPRESSION_INVALID = 0;
    protected static final int QPPREDICATE_EXPRESSION_EQUAL = 1;
    protected static final int QPPREDICATE_EXPRESSION_NOTEQUAL = 2;
    protected static final int QPPREDICATE_EXPRESSION_LESSTHAN = 3;
    protected static final int QPPREDICATE_EXPRESSION_GRTRTHAN = 4;
    protected static final int QPPREDICATE_EXPRESSION_LESSTHANEQUAL = 5;
    protected static final int QPPREDICATE_EXPRESSION_GRTRTHANEQUAL = 6;
    protected static final int QPPREDICATE_USERISOBJOWNER_DONTKNOW = 0;
    protected static final int QPPREDICATE_USERISOBJOWNER_TRUE = 1;
    protected static final int QPPREDICATE_USERISOBJOWNER_FALSE = 2;
    public int axis_;
    public String nodesymbol_;
    public String stepnametest_;
    public QueryObjectID_List objects;
    public QueryPathPredicate m_pPreds;
    public boolean m_bWildcard;
    public int queryAction_;
    public boolean m_bHasLastFunction;
    public int m_iRetentionClass;
    private boolean m_bSimple;
    public boolean m_bwillSelectNone;
    public int m_quickLookupValue;
    public boolean m_bquickLookupGloballyUnique;
    private Cardinality cardinality;

    protected QueryPathStep(ICacheQuery query2) {
        this.objects = query2.newResultsList();
        this.axis_ = 1;
        this.m_pPreds = null;
        this.m_bWildcard = false;
        this.nodesymbol_ = null;
        this.stepnametest_ = null;
        this.queryAction_ = query2.getAction();
        this.m_bHasLastFunction = false;
        this.m_iRetentionClass = -1;
        this.m_bSimple = true;
        this.m_quickLookupValue = 0;
        this.m_bwillSelectNone = false;
        this.m_bquickLookupGloballyUnique = false;
        this.cardinality = Cardinality.ZERO_OR_MORE;
    }

    public int Parse(String path) {
        return this.Parse(path, 0);
    }

    public int Parse(String path, int iOffset) {
        if (iOffset >= path.length()) {
            return 0;
        }
        int startOffset = iOffset;
        CacheQueryParser parser = new CacheQueryParser(this, path, iOffset);
        boolean funcArgIsNotString = false;
        if (parser.charEquals('/')) {
            parser.next();
        }
        if (parser.charEquals('F')) {
            parser.next();
            this.axis_ = parser.parseInt() + 100;
            if (parser.charEquals('(')) {
                parser.next();
            }
            if (parser.charEquals('L')) {
                parser.next();
            } else {
                if (parser.charEquals('-')) {
                    parser.next();
                }
                funcArgIsNotString = true;
            }
            this.m_bWildcard = true;
        } else {
            this.axis_ = parser.parseInt();
        }
        if (parser.charEquals(':')) {
            parser.next();
        }
        if (parser.charEquals('*')) {
            this.m_bWildcard = true;
            parser.next();
        } else {
            int nodetestlen = parser.parseInt();
            if (!funcArgIsNotString) {
                if (parser.charEquals(':')) {
                    parser.next();
                }
                String sNodeTest = parser.substring(nodetestlen);
                parser.next(nodetestlen);
                if (nodetestlen > 0) {
                    this.stepnametest_ = sNodeTest;
                    this.nodesymbol_ = this.stepnametest_.toLowerCase();
                }
            }
        }
        if (parser.charEquals(')')) {
            parser.next();
        }
        this.m_pPreds = parser.parsePredicate();
        int steplen = parser.getOffset() - startOffset;
        return steplen;
    }

    public boolean TestCacheEntry(int obj, ICacheQuery query2, CacheEntry entry, MutableReference inheritedPolicyRef, boolean bReturnPolicy) {
        ICache gblCache = query2.getCache();
        if (this.queryAction_ == 3 && entry.getType() == gblCache.getSpecialClassId("runHistory")) {
            return false;
        }
        if (query2.getAccessMan() != null && !query2.getAccessMan().getFilter().accept(entry)) {
            return false;
        }
        if (!this.m_bWildcard && this.nodesymbol_ != null && !entry.hasName(this.nodesymbol_)) {
            return false;
        }
        PolicyCacheEntry objPolicy = null;
        if (inheritedPolicyRef != null) {
            objPolicy = (PolicyCacheEntry)inheritedPolicyRef.getReference();
        } else {
            bReturnPolicy = false;
        }
        boolean bPassed = true;
        int userIsObjOwner = 0;
        if (this.m_pPreds != null) {
            MutableReference policyRef = new MutableReference(objPolicy);
            bPassed = this.m_pPreds.TestCacheEntry(obj, query2, entry, policyRef, userIsObjOwner, true, true);
            objPolicy = (PolicyCacheEntry)policyRef.getReference();
            if (bReturnPolicy && objPolicy != null && objPolicy.getObjID() != obj) {
                inheritedPolicyRef.setValue(objPolicy);
            }
        }
        return bPassed;
    }

    public void setQuickLookupValue(int id, boolean bGloballyUnique) {
        if (this.m_quickLookupValue > 0) {
            this.m_bSimple = false;
        } else {
            this.m_quickLookupValue = id;
            this.m_bquickLookupGloballyUnique = bGloballyUnique;
        }
    }

    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setIsSimple(boolean simple) {
        this.m_bSimple = simple;
    }

    public boolean isSimple() {
        return this.m_bSimple;
    }

    public static enum Cardinality {
        ZERO_OR_MORE,
        ZERO_OR_ONE,
        ZERO;

    }
}

