/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache.storeid;

import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.storeid.CacheStoreId;
import com.cognos.cm.store.InternalStoreId;

public class StoreIDMap {
    protected int size_;
    protected int mask_;
    protected int count_;
    private float fillFactor_ = 1.0f;
    protected CacheStoreId[] entries_;

    public StoreIDMap(int size) {
        this.reset(size);
    }

    public StoreIDMap(int size, float ff) {
        this(size);
        this.fillFactor_ = ff;
    }

    private void reset(int size) {
        this.size_ = size;
        this.mask_ = size - 1;
        this.count_ = 0;
        this.entries_ = new CacheStoreId[this.size_];
    }

    public synchronized boolean put(InternalStoreId _sID, CacheEntry entry) {
        CacheStoreId sID = _sID instanceof CacheStoreId ? (CacheStoreId)_sID : new CacheStoreId(_sID);
        int idx = this.getHash(sID);
        for (CacheStoreId e = this.entries_[idx]; e != null; e = e.getNext()) {
            if (!e.equals((Object)sID)) continue;
            return false;
        }
        ++this.count_;
        if (this.requiresReHash()) {
            this.rehash();
            idx = this.getHash(sID);
        }
        sID.setNext(this.entries_[idx]);
        this.entries_[idx] = sID;
        sID.setEntry(entry);
        return true;
    }

    private boolean requiresReHash() {
        return (float)this.count_ > (float)this.size_ * this.fillFactor_;
    }

    public synchronized void remove(InternalStoreId sID) {
        int idx = this.getHash(sID);
        CacheStoreId prev = null;
        for (CacheStoreId ee = this.entries_[idx]; ee != null; ee = ee.getNext()) {
            if (sID.equals((Object)ee)) {
                if (prev != null) {
                    prev.setNext(ee.getNext());
                } else {
                    this.entries_[idx] = ee.getNext();
                }
                --this.count_;
                break;
            }
            prev = ee;
        }
    }

    protected int getHash(InternalStoreId sID) {
        return sID.hashCode() & this.mask_;
    }

    private void rehash() {
        CacheStoreId[] entries = new CacheStoreId[this.getNewSize()];
        int old_size = this.size_;
        this.size_ = this.getNewSize();
        this.mask_ = this.size_ - 1;
        for (int i = 0; i < old_size; ++i) {
            CacheStoreId e = this.entries_[i];
            while (e != null) {
                CacheStoreId n = e.getNext();
                int idx = this.getHash(e);
                e.setNext(entries[idx]);
                entries[idx] = e;
                e = n;
            }
        }
        this.entries_ = entries;
    }

    private int getNewSize() {
        return this.size_ << 1;
    }

    public synchronized CacheEntry get(InternalStoreId sID) {
        for (CacheStoreId e = this.entries_[this.getHash(sID)]; e != null; e = e.getNext()) {
            if (!e.equals((Object)sID)) continue;
            return e.getEntry();
        }
        return null;
    }

    public synchronized boolean containsKey(InternalStoreId storeId) {
        return this.get(storeId) != null;
    }

    public synchronized void clear() {
        this.reset(this.size_);
    }
}

