/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cam;

import com.cognos.CAM.AAAException;
import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.cam.CMAAAProxyBase;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.Servlet;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cmutils.xml.XMLUtils;

public class AAAProvider_OpenIDProxy
extends CMAAAProxyBase {
    public static String AAA_PASSTHROUGH_TAG = "<!-- pass -->";
    private boolean isDisabled;

    public AAAProvider_OpenIDProxy(AAAProvider aaa) {
        super(aaa);
    }

    public void enable(boolean enabled) {
        this.isDisabled = !enabled;
    }

    public boolean isEnabled() {
        return !this.isDisabled;
    }

    @Override
    public String Search(String passport, String query2) throws AAAException {
        if (this.shouldResolveInCM(query2)) {
            try {
                byte[] result = this.getServlet().ExecuteStaticRequest(query2.getBytes("utf-8"), true);
                return new String(result, "utf-8");
            }
            catch (Exception e) {
                throw new AAAException("", (Throwable)e);
            }
        }
        return this.aaa.Search(passport, query2);
    }

    private Servlet getServlet() {
        return ContentManager.servlet_;
    }

    private boolean shouldResolveInCM(String query2) {
        CMStoreXPath path;
        if (this.isDisabled || this.isPassThrough(query2)) {
            return false;
        }
        String value = this.getSearchParamater(query2);
        if (value == null) {
            return false;
        }
        try {
            path = new CMStoreXPath(value);
        }
        catch (CMStoreParseException e) {
            return false;
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        String camid = path.getCAMIDFromFirstStep();
        if (camid == null || camid.equals(ctx.getCurrentUser())) {
            return false;
        }
        CMCAMNamespace ns = CMCAMIDHelper.getNamespaceFromCAMID(camid);
        return ns != null && ns.isOpenID() && (!ns.getID().equals(camid) || path.size() != 1) && ctx.isUserAuthenticatedIntoNamespace(ns.getID());
    }

    private boolean isPassThrough(String query2) {
        int markerPos = 0;
        if (query2.startsWith("<?")) {
            markerPos = query2.indexOf("?>") + 2;
        }
        return query2.startsWith(AAA_PASSTHROUGH_TAG, markerPos);
    }

    private String getSearchParamater(String query2) {
        int searchEnd = query2.indexOf("</search>");
        if (searchEnd == -1) {
            return null;
        }
        int searchStart = query2.lastIndexOf(62, searchEnd - 1);
        return XMLUtils.unescape((String)query2.substring(searchStart + 1, searchEnd));
    }
}

