/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cam.azn;

import com.cognos.CAM.AAAException;
import com.cognos.CAM.AAA_AznRequest_t;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.cam.utils.AAACodec;
import com.cognos.cm.server.CMException;
import java.util.List;

public class AznUtil {
    private AAAProvider aaa_;
    private String passportId_;
    private String additionalInfo_;

    public AznUtil(AAAProvider aaa, String passportId, String additionalInfo) {
        this.aaa_ = aaa;
        this.passportId_ = passportId;
        this.additionalInfo_ = additionalInfo;
    }

    public byte[] createPolicy(String sPropName, String sPropValue) throws AAAException {
        String sXMLValue = sPropValue;
        if (sPropName.equals("userCapabilityPolicies")) {
            sXMLValue = AAACodec.encode(sPropValue);
        }
        if (sXMLValue == null) {
            return null;
        }
        return this.aaa_.CreatePolicy(sXMLValue, this.additionalInfo_);
    }

    public String describePolicy(String sPropName, byte[] policyBlob) throws CMException {
        String xmlPolicy = null;
        try {
            xmlPolicy = this.aaa_.DescribePolicy(this.passportId_, policyBlob, "<properties xmlns=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item></properties>", this.additionalInfo_);
        }
        catch (AAAException ex) {
            throw new CMException((Exception)((Object)ex), "cmNoReadPolicy");
        }
        if (sPropName.equals("userCapabilityPolicies")) {
            xmlPolicy = AAACodec.decode(xmlPolicy);
        }
        return xmlPolicy;
    }

    public int[] bulkCheckAccess(byte[] policies, List<String> permissions, boolean bGrantAll) throws AAAException {
        if (permissions.size() <= 0) {
            return null;
        }
        AAA_AznRequest_t[] tests = new AAA_AznRequest_t[permissions.size()];
        int[] results = new int[permissions.size()];
        if (this.passportId_ != null && this.passportId_.length() > 0) {
            int j;
            for (j = 0; j < permissions.size(); ++j) {
                tests[j] = new AAA_AznRequest_t(policies, permissions.get(j), 0, "");
            }
            this.aaa_.BulkCheckAccess(this.passportId_, tests, this.additionalInfo_);
            for (j = 0; j < tests.length; ++j) {
                results[j] = tests[j].nAccess;
            }
        } else if (bGrantAll) {
            for (int j = 0; j < tests.length; ++j) {
                results[j] = 0;
            }
        } else {
            for (int j = 0; j < tests.length; ++j) {
                results[j] = 1;
            }
        }
        return results;
    }

    public static int[] getAllGrantedResults(List<String> permissions) {
        int[] results = new int[permissions.size()];
        for (int j = 0; j < permissions.size(); ++j) {
            results[j] = 0;
        }
        return results;
    }
}

