/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm;

import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.util.version.Version;
import com.cognos.cmutils.reflect.FieldAccessor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class cmInfo {
    private static Version version = cmInfo.resetVersionObject();
    private static FieldAccessor<String> dbStoreFieldAccessor = cmInfo.resetDbStoreFieldAccessor();
    private static PrintStream out = cmInfo.resetOutputStream();

    protected static Version resetVersionObject() {
        return Version.getVersion(cmInfo.class);
    }

    protected static FieldAccessor<String> resetDbStoreFieldAccessor() {
        return new FieldAccessor(CMDbStoreFactory.class, "DB_VERSION");
    }

    protected static PrintStream resetOutputStream() {
        return System.out;
    }

    protected static void setOutputStream(PrintStream o) {
        out = o;
    }

    protected static void setVersionObject(Version v) {
        version = v;
    }

    protected static void setDbStoreFieldAccessor(FieldAccessor<String> accessor) {
        dbStoreFieldAccessor = accessor;
    }

    public static String getVersion() {
        String value = "@cm_build_version@";
        String s = version.getVersion();
        if (s != null) {
            value = s;
        }
        return value;
    }

    public static String getExtendedVersion() {
        return version.getExtendedVersion();
    }

    public static String getProductName() {
        String productName = "IBM Cognos";
        String implementationTitle = version.getImplementationTitle();
        ArrayList<String> tokens = cmInfo.getTokens(implementationTitle, ",");
        if (tokens.size() > 0) {
            productName = tokens.get(0).trim();
        }
        return productName;
    }

    private static ArrayList<String> getTokens(String input, String delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (input != null) {
            StringTokenizer toker = new StringTokenizer(input, delim);
            while (toker.hasMoreTokens()) {
                tokens.add(toker.nextToken());
            }
        }
        return tokens;
    }

    public static String getComponentName() {
        String componentName = "Content Manager";
        String implementationTitle = version.getImplementationTitle();
        ArrayList<String> tokens = cmInfo.getTokens(implementationTitle, ",");
        if (tokens.size() > 1) {
            componentName = tokens.get(1).trim();
        }
        return componentName;
    }

    public static Object getStoreVersion() {
        return dbStoreFieldAccessor.get();
    }

    public static void main(String[] args) {
        out.println("productName: " + cmInfo.getProductName());
        out.println("componentName: " + cmInfo.getComponentName());
        out.println("version: " + cmInfo.getVersion());
        out.println("extendedVersion: " + cmInfo.getExtendedVersion());
        out.println("storeVersion: " + cmInfo.getStoreVersion());
    }
}

