/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors;

import com.cognos.cm.connectors.AsyncBusMethodProcessor;
import com.cognos.cm.connectors.AsyncResponseProcessor;
import com.cognos.cm.connectors.BusConnectionPool;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncBusConnectionHandler {
    private static final String CLASS_NAME = AsyncBusConnectionHandler.class.getSimpleName();
    private static final Gauge QUEUE_DEPTH_GAUGE = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("p2pd_cm_asyncbus_queuedepth_" + CLASS_NAME)).help("depth of cm async bus queue " + CLASS_NAME)).register();
    private static final Summary EXECUTION_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_asyncbus_operations_" + CLASS_NAME)).help("summary of async bus operation execution " + CLASS_NAME)).register();
    protected ThreadPoolExecutor executorPool;
    protected BusConnectionPool busPool;
    protected URL url;

    public AsyncBusConnectionHandler(String sUrl) throws CMException {
        this(sUrl, AdvancedSettings.ASYNCSERVICEBLOCKINGQUEUECAPACITY, AdvancedSettings.ASYNCSERVICEMINTHREADS, AdvancedSettings.ASYNCSERVICEMAXTHREADS);
    }

    protected AsyncBusConnectionHandler(String sUrl, int queueCapacity, int minThreads, int maxThreads) throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        this.setURL(config, sUrl);
        this.setBusConnectionPool(config);
        this.setThreadPoolExecutor(queueCapacity, minThreads, maxThreads);
    }

    private void setURL(IConfiguration config, String sUrl) throws CMException {
        if (sUrl == null) {
            sUrl = config.getCognosProp("internalDispatcher");
        }
        try {
            this.url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            throw new CMException(e, "cmErrDispatcherURL");
        }
    }

    protected void setBusConnectionPool(IConfiguration config) throws CMException {
        try {
            this.busPool = new BusConnectionPool(this.url.getHost(), this.url.getPort(), this.url.getPath(), config.isInternalSSL(), 2, 100, AdvancedSettings.ASYNCSERVICENOTIFICATIONTIMEOUT);
        }
        catch (CMConfigurationException ex) {
            throw new CMException(ex, "cmUnexpectedError");
        }
    }

    protected void setThreadPoolExecutor(int queueCapacity, int minThreads, int maxThreads) {
        LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        this.executorPool = new ThreadPoolExecutor(minThreads, maxThreads, 60L, TimeUnit.SECONDS, blockingQueue, rejectedExecutionHandler);
        this.executorPool.prestartAllCoreThreads();
    }

    protected AsyncBusMethodProcessor getBusMethodProcessor(BusMethod method, AsyncResponseProcessor responseProcessor) {
        return new AsyncBusMethodProcessor(this.busPool, method, responseProcessor);
    }

    public void execute(BusMethod method, AsyncResponseProcessor responseProcessor) {
        method.addRequestHeaders(this.url.toString());
        AsyncBusMethodProcessor methodProcessor = this.getBusMethodProcessor(method, responseProcessor);
        try {
            method.prepareRequest();
            QUEUE_DEPTH_GAUGE.inc();
            this.executorPool.execute(new MonitoredRunnable(methodProcessor, QUEUE_DEPTH_GAUGE, EXECUTION_SUMMARY));
        }
        catch (CMException e) {
            methodProcessor.setException(e);
            this.logError(e);
        }
    }

    protected void logError(Exception e) {
        CMException cme = new CMException(e, "cmAsyncPostFailed");
        cme.setErrorLevel(40000);
        CMIndications.logException(cme);
    }

    public void terminate() {
        if (null != this.executorPool) {
            this.executorPool.shutdown();
            try {
                this.executorPool.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (null != this.busPool) {
            try {
                this.busPool.terminate();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class MonitoredRunnable
    implements Runnable {
        private final Runnable delegate;
        private final Gauge depth_gauge;
        private final Summary counter;

        MonitoredRunnable(Runnable delegate, Gauge depth_gauge, Summary summary) {
            this.delegate = delegate;
            this.depth_gauge = depth_gauge;
            this.counter = summary;
        }

        @Override
        public void run() {
            Summary.Timer timer = null;
            try {
                timer = this.counter.startTimer();
                this.delegate.run();
            }
            finally {
                this.depth_gauge.dec();
                timer.close();
            }
        }
    }
}

