/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors;

import com.cognos.cm.connectors.AsyncResponseProcessor;
import com.cognos.cm.connectors.BusConnectionPool;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMException;
import java.io.InputStream;

public class AsyncBusMethodProcessor
implements Runnable {
    protected BusConnectionPool busConnectionPool;
    protected BusMethod asyncMethod;
    protected AsyncResponseProcessor responseProcessor;
    protected Exception exception;

    public AsyncBusMethodProcessor(BusConnectionPool connectionPool, BusMethod method, AsyncResponseProcessor responseProcessor) {
        this.busConnectionPool = connectionPool;
        this.asyncMethod = method;
        this.responseProcessor = responseProcessor;
    }

    @Override
    public void run() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        BusConnectionPool.BusConnection busConnection = null;
        AsyncRequestState response = null;
        try {
            busConnection = this.busConnectionPool.get();
            busConnection.execute(this.asyncMethod);
            this.responseProcessor.processStatusCodes(this.asyncMethod);
            InputStream resultStream = this.asyncMethod.getResponseBodyAsStream();
            response = this.responseProcessor.processResponse(resultStream);
            Exception e = response.getException();
            if (null != e) {
                this.setException(e);
                this.logError(e);
            }
        }
        catch (Exception e) {
            this.setException(e);
            this.logError(e);
        }
        finally {
            busConnection.release(this.asyncMethod);
        }
    }

    public void setException(Exception e) {
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    protected void logError(Exception e) {
        CMException cme = new CMException(e, "cmAsyncPostFailed");
        cme.setErrorLevel(40000);
        CMIndications.logException(cme);
    }
}

