/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors;

import com.cognos.cm.connectors.AsyncResponseProcessor;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class AsyncDOMResponseProcessor
implements AsyncResponseProcessor {
    private static final String XP_SOAPFAULT = "//SOAP-ENV:Fault";
    private static final String XP_PRIMARYREQUEST = "//bus:primaryRequest";
    private static final String XP_STATUS = "//bus:status";
    private static final String XP_MESSAGESTRING = "//bus:messageString";
    private static final String XP_ERRORCODE = "//bus:errorCode";
    private static final String XP_FAULTSTRING = "//faultstring";
    private static final String XP_FAULTCODE = "//faultcode";
    AsyncRequestState response = new AsyncRequestState(4);

    private NamespaceContext getNamespaceContext() {
        SimpleNamespaceContext ctx = new SimpleNamespaceContext();
        ctx.addNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        ctx.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        return ctx;
    }

    @Override
    public AsyncRequestState processResponse(InputStream responseStream) throws CMException {
        SAXReader reader = new SAXReader();
        try {
            Document responseDoc = reader.read(responseStream);
            XPath faultPath = responseDoc.createXPath(XP_SOAPFAULT);
            faultPath.setNamespaceContext(this.getNamespaceContext());
            Node faultNode = faultPath.selectSingleNode((Object)responseDoc);
            if (null != faultNode) {
                this.processFault(faultNode);
            } else {
                XPath primaryRequestPath = responseDoc.createXPath(XP_PRIMARYREQUEST);
                primaryRequestPath.setNamespaceContext(this.getNamespaceContext());
                XPath statusPath = responseDoc.createXPath(XP_STATUS);
                statusPath.setNamespaceContext(this.getNamespaceContext());
                Node primaryRequestNode = primaryRequestPath.selectSingleNode((Object)responseDoc);
                Node statusNode = statusPath.selectSingleNode((Object)responseDoc);
                if (null != primaryRequestNode) {
                    this.processPrimaryRequest(primaryRequestNode);
                }
                if (null != statusNode) {
                    this.processStatus(statusNode);
                }
            }
        }
        catch (DocumentException e) {
            CMException cex = new CMException((Exception)((Object)e), "cmAsyncResponseParseFailure");
            throw cex;
        }
        return this.response;
    }

    private void processFault(Node faultNode) {
        Node messageNode = faultNode.selectSingleNode(XP_MESSAGESTRING);
        Node errorCodeNode = faultNode.selectSingleNode(XP_ERRORCODE);
        String message = "";
        String code = "";
        if (null == messageNode) {
            Node faultStringNode = faultNode.selectSingleNode(XP_FAULTSTRING);
            if (null != faultStringNode) {
                message = faultStringNode.getText();
            }
        } else {
            message = messageNode.getText();
        }
        if (null == errorCodeNode) {
            Node faultCodeNode = faultNode.selectSingleNode(XP_FAULTCODE);
            if (null != faultCodeNode) {
                code = faultCodeNode.getText();
            }
        } else {
            code = errorCodeNode.getText();
        }
        CMException cex = new CMException("cmAsyncRemoteFault", new CMException.Parm("FaultCode", code), new CMException.Parm("FaultMessage", message));
        this.response.setException(cex);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processStatus(Node statusNode) throws CMException {
        if (statusNode == null) {
            CMException cex = new CMException("cmAsyncResponseInvalidState");
            throw cex;
        }
        String status = statusNode.getText();
        if (status.equals("working")) {
            this.response.setRequestState(0);
            return;
        }
        if (status.equals("stillWorking")) {
            this.response.setRequestState(0);
            return;
        }
        if (status.equals("complete")) {
            this.response.setRequestState(1);
            return;
        }
        if (status.equals("conversationComplete")) {
            this.response.setRequestState(1);
            return;
        }
        CMException cex = new CMException("cmAsyncResponseInvalidState");
        throw cex;
    }

    private void processPrimaryRequest(Node primaryRequestNode) {
        if (primaryRequestNode != null) {
            String primaryRequestXML = primaryRequestNode.asXML();
            this.response.setPrimaryRequest(primaryRequestXML);
        }
    }

    @Override
    public void processStatusCodes(BusMethod method) {
    }
}

