/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.server.CMException;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;

public class BusConnectionPool {
    String m_host;
    int m_port;
    String m_url;
    boolean m_secure;
    int m_size;
    int m_max = 5;
    int m_cursize;
    int m_timeout;
    CAMFactory m_camFactory;
    LinkedList<BusConnection> m_freeList = new LinkedList();

    public BusConnectionPool(String host, int port, String url, boolean secure, int size, int max, int timeout) throws CMException {
        this.m_host = host;
        this.m_port = port;
        this.m_url = url;
        this.m_secure = secure;
        this.m_cursize = this.m_size = size;
        this.m_max = max;
        this.m_timeout = timeout;
        try {
            this.m_camFactory = new CAMFactory();
            this.m_camFactory.initialize("<initializeDocument><serviceID>CM</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            throw new CMException((Exception)((Object)e), "cmErrCAMSessionFailed");
        }
        for (int i = 0; i < this.m_size; ++i) {
            this.m_freeList.addLast(this.createConnection());
        }
    }

    public synchronized BusConnection get() throws IOException, CMException {
        if (this.m_freeList.size() > 0) {
            return this.m_freeList.removeFirst();
        }
        if (this.m_cursize < this.m_max) {
            ++this.m_cursize;
            return this.createConnection();
        }
        try {
            while (this.m_freeList.size() == 0) {
                this.wait();
            }
            return this.m_freeList.removeFirst();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public synchronized void put(BusConnection con) {
        this.m_freeList.addFirst(con);
        this.notify();
    }

    public synchronized void terminate() throws IOException {
        while (this.m_freeList.size() > 0) {
            BusConnection con = this.m_freeList.removeFirst();
            con.terminate();
        }
        this.m_cursize = 0;
    }

    private BusConnection createConnection() throws CMException {
        return new BusConnection(this, this.m_host, this.m_port, this.m_url, this.m_secure, this.m_camFactory, this.m_timeout);
    }

    public CAMFactory getCAMFactory() {
        return this.m_camFactory;
    }

    public class BusConnection {
        String m_host = null;
        int m_port = 0;
        String m_url = null;
        boolean m_secure = false;
        HttpClient m_client = null;
        BusConnectionPool m_pool = null;

        protected BusConnection(BusConnectionPool pool, String host, int port, String url, boolean secure, CAMFactory camFactory, int timeout) throws CMException {
            this.m_pool = pool;
            this.m_host = host;
            this.m_port = port;
            this.m_url = url;
            this.m_secure = secure;
            try {
                this.m_client = camFactory.createHttpClient(this.m_host, this.m_port, this.m_secure);
                this.m_client.setTimeout(timeout);
            }
            catch (CAMCryptoException e) {
                throw new CMException((Exception)((Object)e), "cmErrCAMSessionFailed");
            }
        }

        public void execute(BusMethod method) throws IOException, HttpException {
            try {
                this.m_client.executeMethod((HttpMethod)method);
            }
            catch (Exception e) {
                this.refreshConnection(method);
                this.m_client.executeMethod((HttpMethod)method);
            }
        }

        public void refreshConnection(BusMethod method) throws IOException {
            method.releaseConnection();
            if (method.hasBeenUsed()) {
                method.renew();
                method.addRequestHeaders(this.m_url);
            }
        }

        public void closeConnection(BusMethod method) throws IOException {
            method.releaseConnection();
        }

        public void release(BusMethod method) {
            method.recycle();
            method.addRequestHeaders(this.m_url);
            if (this.m_pool != null) {
                this.m_pool.put(this);
            }
        }

        protected void terminate() throws IOException {
            this.m_host = null;
            this.m_url = null;
            this.m_pool = null;
            this.m_secure = false;
            this.m_client = null;
        }
    }
}

