/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.ConnectionPool;
import com.cognos.cm.util.TrustedSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;

public class BusSOAPPostMethod
extends BusMethod {
    private String soapActionValue_;
    private String soapHeader_;
    private String soapBody_;
    protected XMLElement fault_;
    protected String messageString_;
    protected String errorCode_;
    protected boolean faultIsServer_;
    protected byte[] signedRequest_;
    private ByteArrayOutputStream m_out = new ByteArrayOutputStream();

    public BusSOAPPostMethod(String soapActionValue) {
        this.soapActionValue_ = soapActionValue;
    }

    public String getName() {
        return "POST";
    }

    @Override
    public void addRequestHeaders(String path) {
        this.setPath(path);
        this.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        this.setRequestHeader("Connection", "Keep-Alive");
        if (this.soapActionValue_ != null) {
            this.setRequestHeader("SOAPAction", this.soapActionValue_);
        }
    }

    public ByteArrayOutputStream getRequestOutputStream() {
        return this.m_out;
    }

    public void setRequestOutputStream(ByteArrayOutputStream out) {
        this.m_out = out;
    }

    @Override
    public void prepareRequest() throws CMException {
        StringBuffer theRequest = new StringBuffer(2000);
        theRequest.append("<?xml version='1.0' encoding='UTF-8'?><SOAP-ENV:Envelope ");
        theRequest.append("xmlns:SOAP-ENV=\"");
        theRequest.append("http://schemas.xmlsoap.org/soap/envelope/");
        theRequest.append("\" xmlns:bus=\"");
        theRequest.append("http://developer.cognos.com/schemas/bibus/3/");
        theRequest.append("\" xmlns:xsi=\"");
        theRequest.append("http://www.w3.org/2001/XMLSchema-instance");
        theRequest.append("\" xmlns:SOAP-ENC=\"");
        theRequest.append("http://schemas.xmlsoap.org/soap/encoding/");
        theRequest.append("\" xmlns:xsd=\"");
        theRequest.append("http://www.w3.org/2001/XMLSchema");
        theRequest.append("\">");
        theRequest.append("<SOAP-ENV:Header>");
        if (this.soapHeader_ == null) {
            this.soapHeader_ = CMExecutionContext.get().getBIBUSheader();
        }
        if (this.soapHeader_ != null) {
            theRequest.append(this.soapHeader_);
        }
        theRequest.append("</SOAP-ENV:Header>");
        theRequest.append("<SOAP-ENV:Body>");
        if (this.soapBody_ != null) {
            theRequest.append(this.soapBody_);
        }
        theRequest.append("</SOAP-ENV:Body>");
        theRequest.append("</SOAP-ENV:Envelope>");
        String sRequest = theRequest.toString();
        this.setRequestOutputStream(this.authorizeRequest(sRequest));
        this.setRequestHeader("Content-Length", String.valueOf(this.getRequestContentLength()));
    }

    protected int getRequestContentLength() {
        return this.m_out.size();
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        conn.write(this.m_out.toByteArray());
        return true;
    }

    protected ByteArrayOutputStream authorizeRequest(String request) throws CMException {
        ByteArrayOutputStream authorizedRequestStream = new ByteArrayOutputStream();
        try {
            TrustedSession session = ConnectionPool.getInstance().getSession();
            this.signedRequest_ = session.getTrustedRequestSession().setMessageTrust("CM", request.getBytes("UTF-8"));
            session.release();
            CMIndications.CMTrace("cmSDSRequest", new CMException.Parm("request", new String(this.signedRequest_, "UTF-8")));
            authorizedRequestStream.write(this.signedRequest_);
        }
        catch (CAMCryptoException e) {
            CMException cmex = new CMException((Exception)((Object)e), "cmErrInitializingSession");
            CMIndications.logException(cmex);
            throw cmex;
        }
        catch (IOException ioe) {
            CMException cmex = new CMException(ioe, "cmErrInitializingSession");
            CMIndications.logException(cmex);
            throw cmex;
        }
        return authorizedRequestStream;
    }

    protected void checkForFaultInfo(String name, String value, XMLElement el) {
        if (name.equalsIgnoreCase("Fault")) {
            if (this.fault_ == null) {
                this.fault_ = el;
            }
        } else if (name.equalsIgnoreCase("messageString")) {
            if (this.messageString_ == null) {
                this.messageString_ = value;
                if (this.messageString_.indexOf("actionNotify") >= 0 || this.messageString_.indexOf("actionnotify") >= 0) {
                    this.faultIsServer_ = false;
                }
            }
        } else if (name.equalsIgnoreCase("faultcode")) {
            if (value != null && value.equalsIgnoreCase("Server")) {
                this.faultIsServer_ = true;
            }
        } else if (name.equalsIgnoreCase("errorCode") && this.errorCode_ == null) {
            this.errorCode_ = value;
        }
    }

    @Override
    public void setBody(Object body) {
        this.soapBody_ = (String)body;
    }

    public void recycle() {
        super.recycle();
        this.m_out = new ByteArrayOutputStream();
    }

    @Override
    public void makeRequestTrusted(CAMFactory camFactory) throws CMException {
    }
}

