/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.CMConnector;

import com.cognos.cm.connectors.BusConnectionPool;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.CMConnector.CMElectPostMethod;
import com.cognos.cm.connectors.CMConnector.CMGetActiveContentManagerPostMethod;
import com.cognos.cm.connectors.CMConnector.CMNotifyPostMethod;
import com.cognos.cm.connectors.CMConnector.CMResponseException;
import com.cognos.cm.connectors.CMConnector.CMResponseTimeoutException;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.ConfigurationFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CMConnector {
    protected static HashMap<URL, CMConnector> theConnections_ = new HashMap();
    protected static HashMap<URL, BusConnectionPool> busConnectionPools_ = new HashMap();
    protected static CMConnectorImplementation implementation = new CMConnectorImplementation();
    private URL url_ = null;
    private int timeout_ = 0;

    private CMConnector(String url) throws CMException {
        try {
            this.url_ = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new CMException(e, "cmErrDispatcherURL");
        }
        String protocol = this.url_.getProtocol();
        boolean secure = protocol != null && protocol.startsWith("https");
        busConnectionPools_.put(this.url_, new BusConnectionPool(this.url_.getHost(), this.url_.getPort(), this.url_.getPath(), secure, 2, 100, 0));
    }

    public static synchronized void terminate() throws IOException {
        implementation.terminate();
    }

    public static CMConnector getConnector(String url) throws CMException {
        return implementation.getConnector(url);
    }

    public static void ping(String url) throws CMException, CMResponseException, CMResponseTimeoutException {
        implementation.ping(url);
    }

    public void setTimeoutInMilliseconds(int timeout) {
        this.timeout_ = timeout;
    }

    public int getTimeoutInMilliseconds() {
        return this.timeout_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMethod(BusConnectionPool.BusConnection obj, BusMethod method) throws Exception {
        if (this.timeout_ <= 0) {
            obj.execute(method);
        } else {
            Thread thread = null;
            CMConnectorRunnable connectorRunnable = null;
            try {
                connectorRunnable = new CMConnectorRunnable(obj, method);
                thread = new Thread(connectorRunnable);
                thread.start();
                try {
                    CMConnectorRunnable cMConnectorRunnable = connectorRunnable;
                    synchronized (cMConnectorRunnable) {
                        connectorRunnable.wait(this.timeout_);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!connectorRunnable.isCompleted()) {
                    throw new CMResponseTimeoutException("cmConnectorTimeoutError");
                }
                Exception ex = connectorRunnable.getException();
                if (ex != null) {
                    throw ex;
                }
            }
            finally {
                if (connectorRunnable != null) {
                    connectorRunnable.reset(method);
                }
                connectorRunnable = null;
                thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void electNotify() throws CMException, CMResponseException, CMResponseTimeoutException {
        try {
            this.setThreadExecutionContext("Election_SESS", "Election_REQ");
            CMElectPostMethod post = new CMElectPostMethod();
            post.addRequestHeaders(this.url_.getPath());
            StringBuffer sb = new StringBuffer(3000);
            sb.append("<bus:");
            sb.append("elect");
            sb.append(" xmlns:SOAP-ENV=\"");
            sb.append("http://schemas.xmlsoap.org/soap/envelope/");
            sb.append("\" xmlns:xsi=\"");
            sb.append("http://www.w3.org/2001/XMLSchema-instance");
            sb.append("\" xmlns:SOAP-ENC=\"");
            sb.append("http://schemas.xmlsoap.org/soap/encoding/");
            sb.append("\" xmlns:xsd=\"");
            sb.append("http://www.w3.org/2001/XMLSchema");
            sb.append("\" xmlns:bus=\"");
            sb.append("http://developer.cognos.com/schemas/bibus/3/");
            sb.append("\" xmlns:cm=\"");
            sb.append("http://developer.cognos.com/schemas/bibus/3/");
            sb.append("\">");
            sb.append("</bus:");
            sb.append("elect");
            sb.append(">");
            String message = sb.toString();
            post.setBody(message);
            post.prepareRequest();
            BusConnectionPool.BusConnection obj = null;
            try {
                BusConnectionPool busPool = busConnectionPools_.get(this.url_);
                if (busPool == null) {
                    throw new CMException("cmUnexpectedError");
                }
                obj = busPool.get();
                this.executeMethod(obj, post);
            }
            catch (IOException e) {
                throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            catch (CMResponseTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CMResponseException(e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            finally {
                if (obj != null) {
                    obj.release(post);
                }
            }
        }
        finally {
            CMExecutionContext.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getActiveContentManager() throws CMException, CMResponseException {
        try {
            this.setThreadExecutionContext("Election_SESS", "Election_REQ");
            CMGetActiveContentManagerPostMethod post = new CMGetActiveContentManagerPostMethod();
            post.addRequestHeaders(this.url_.getPath());
            StringBuffer sb = new StringBuffer(3000);
            sb.append("<bus:");
            sb.append("getActiveContentManager");
            sb.append(" xmlns:SOAP-ENV=\"");
            sb.append("http://schemas.xmlsoap.org/soap/envelope/");
            sb.append("\" xmlns:xsi=\"");
            sb.append("http://www.w3.org/2001/XMLSchema-instance");
            sb.append("\" xmlns:SOAP-ENC=\"");
            sb.append("http://schemas.xmlsoap.org/soap/encoding/");
            sb.append("\" xmlns:xsd=\"");
            sb.append("http://www.w3.org/2001/XMLSchema");
            sb.append("\" xmlns:bus=\"");
            sb.append("http://developer.cognos.com/schemas/bibus/3/");
            sb.append("\" xmlns:cm=\"");
            sb.append("http://developer.cognos.com/schemas/bibus/3/");
            sb.append("\">");
            sb.append("</bus:");
            sb.append("getActiveContentManager");
            sb.append(">");
            String message = sb.toString();
            post.setBody(message);
            post.prepareRequest();
            BusConnectionPool.BusConnection obj = null;
            try {
                BusConnectionPool busPool = busConnectionPools_.get(this.url_);
                if (busPool == null) {
                    throw new CMException("cmUnexpectedError");
                }
                obj = busPool.get();
                this.executeMethod(obj, post);
                post.processResponse();
            }
            catch (IOException e) {
                throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            catch (CMResponseTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CMResponseException(e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            finally {
                if (obj != null) {
                    obj.release(post);
                }
            }
        }
        finally {
            CMExecutionContext.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CMIsActivetNotify(String activeCMURI) throws CMException, CMResponseException {
        try {
            this.setThreadExecutionContext("NotifyCMIsActive_SESS", "NotifyCMIsActive_REQ");
            CMNotifyPostMethod post = new CMNotifyPostMethod();
            post.addRequestHeaders(this.url_.getPath());
            StringBuffer sb = new StringBuffer(3000);
            sb.append("<bus:");
            sb.append("notify");
            sb.append(" xmlns:SOAP-ENV=\"");
            sb.append("http://schemas.xmlsoap.org/soap/envelope/");
            sb.append("\" xmlns:xsi=\"");
            sb.append("http://www.w3.org/2001/XMLSchema-instance");
            sb.append("\" xmlns:SOAP-ENC=\"");
            sb.append("http://schemas.xmlsoap.org/soap/encoding/");
            sb.append("\" xmlns:xsd=\"");
            sb.append("http://www.w3.org/2001/XMLSchema");
            sb.append("\" xmlns:bus=\"");
            sb.append("http://developer.cognos.com/schemas/bibus/3/");
            sb.append("\">");
            sb.append("<notificationActiveContentManager>");
            sb.append("<uri xsi:type=\"xs:string\">");
            sb.append(activeCMURI);
            sb.append("</uri>");
            sb.append("</notificationActiveContentManager>");
            sb.append("<propagate xsi:type=\"xsd:boolean\">true</propagate>");
            sb.append("</bus:");
            sb.append("notify");
            sb.append(">");
            String message = sb.toString();
            post.setBody(message);
            post.prepareRequest();
            BusConnectionPool.BusConnection obj = null;
            try {
                BusConnectionPool busPool = busConnectionPools_.get(this.url_);
                if (busPool == null) {
                    throw new CMException("cmUnexpectedError");
                }
                obj = busPool.get();
                this.executeMethod(obj, post);
            }
            catch (IOException e) {
                throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            catch (CMResponseTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CMResponseException(e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
            finally {
                if (obj != null) {
                    obj.release(post);
                }
            }
        }
        finally {
            CMExecutionContext.tearDown();
        }
    }

    private void setThreadExecutionContext(String sessionContext, String requestContext) {
        CMExecutionContext.setUp();
        CMExecutionContext thisExecutionContext = CMExecutionContext.get();
        String strSessionContentLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        thisExecutionContext.setPreference(CMPreference.CONTENTLOCALE, strSessionContentLocale);
        thisExecutionContext.setPreference(CMPreference.PRODUCTLOCALE, strSessionContentLocale);
        thisExecutionContext.setBIBUSheader(CMExecutionContext.getDefaultBIBUSheader(strSessionContentLocale, strSessionContentLocale, sessionContext, requestContext));
        thisExecutionContext.setRequestContext("Election_REQ");
        thisExecutionContext.setSessionContext("Election_SESS");
    }

    public static void setImplementation_test(CMConnectorImplementation impl) {
        implementation = impl;
    }

    public static void resetImplementation_test() {
        implementation = new CMConnectorImplementation();
    }

    private static class PingRunnable
    implements Runnable {
        private String host_;
        private int port_;
        private boolean completed_ = false;
        private Exception exception_ = null;

        PingRunnable(String host, int port) {
            this.host_ = host;
            this.port_ = port;
        }

        public Exception getException() {
            return this.exception_;
        }

        public boolean isCompleted() {
            return this.completed_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket sock = new Socket(this.host_, this.port_);
                sock.close();
                this.completed_ = true;
            }
            catch (Exception e) {
                this.exception_ = e;
            }
            finally {
                PingRunnable pingRunnable = this;
                synchronized (pingRunnable) {
                    this.notify();
                }
            }
        }
    }

    class CMConnectorRunnable
    implements Runnable {
        private BusConnectionPool.BusConnection obj_;
        private BusMethod method_;
        private Exception exception_;
        private boolean completed_ = false;
        private Object syncObject_ = new Object();

        CMConnectorRunnable(BusConnectionPool.BusConnection obj, BusMethod method) {
            this.obj_ = obj;
            this.method_ = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(BusMethod method) {
            Object object = this.syncObject_;
            synchronized (object) {
                if (this.obj_ != null) {
                    try {
                        this.obj_.closeConnection(method);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception getException() {
            Object object = this.syncObject_;
            synchronized (object) {
                return this.exception_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCompleted() {
            Object object = this.syncObject_;
            synchronized (object) {
                return this.completed_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                object = this.syncObject_;
                synchronized (object) {
                    this.exception_ = null;
                    this.completed_ = false;
                }
                this.obj_.execute(this.method_);
            }
            catch (Exception ex) {
                Object object2 = this.syncObject_;
                synchronized (object2) {
                    this.exception_ = ex;
                }
            }
            object = this.syncObject_;
            synchronized (object) {
                this.completed_ = true;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    static class CMConnectorImplementation {
        CMConnectorImplementation() {
        }

        protected CMConnector getConnector(String url) throws CMException {
            URL urlObject = null;
            try {
                urlObject = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new CMException(e, "cmErrDispatcherURL");
            }
            CMConnector theConnection = theConnections_.get(urlObject);
            if (theConnection == null) {
                theConnection = new CMConnector(url);
                theConnections_.put(urlObject, theConnection);
            }
            theConnection.setTimeoutInMilliseconds(0);
            return theConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ping(String url) throws CMException, CMResponseException, CMResponseTimeoutException {
            URL urlObject = null;
            try {
                urlObject = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new CMException(e, "cmErrDispatcherURL");
            }
            String host = urlObject.getHost();
            int port = urlObject.getPort();
            PingRunnable pingRunnable = new PingRunnable(host, port);
            Thread t = new Thread(pingRunnable);
            t.start();
            try {
                PingRunnable pingRunnable2 = pingRunnable;
                synchronized (pingRunnable2) {
                    pingRunnable.wait(AdvancedSettings.CMSYNC_SHORTNETWORKINTERRUPTIONTIME);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Exception ex = pingRunnable.getException();
            if (ex != null) {
                try {
                    throw ex;
                }
                catch (UnknownHostException e) {
                    throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
                }
                catch (BindException e) {
                    throw new CMResponseTimeoutException("cmConnectorTimeoutError", new CMException.Parm("connector", url));
                }
                catch (ConnectException e) {
                    throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
                }
                catch (NoRouteToHostException e) {
                    throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
                }
                catch (ProtocolException e) {
                    throw new CMException(e, "cmErrDispatcherURL");
                }
                catch (IOException e) {
                    throw new CMResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
                }
                catch (Exception e) {
                    throw new CMException(e, "cmErrDispatcherURL");
                }
            }
            if (!pingRunnable.isCompleted()) {
                throw new CMResponseException("cmConnectorIOError", new CMException.Parm("connector", "CM"), true, null);
            }
        }

        protected synchronized void terminate() throws IOException {
            Collection<BusConnectionPool> col;
            if (busConnectionPools_ != null && (col = busConnectionPools_.values()) != null) {
                Iterator<BusConnectionPool> iter = col.iterator();
                while (iter.hasNext()) {
                    iter.next().terminate();
                }
            }
        }
    }
}

