/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.MDSRVConnector;

import com.cognos.cm.connectors.AsyncDOMResponseProcessor;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.MDSRVConnector.MDSRVBusConnectionHandler;
import com.cognos.cm.connectors.MDSRVConnector.MDSRVPostMethod;
import com.cognos.cm.server.CMException;
import java.util.List;

public class MDSRVConnector {
    private static MDSRVBusConnectionHandler connectionHandler = null;
    private static boolean isActive = false;
    private static final String ACCOUNTS_START = "&lt;accounts&gt;";
    private static final String ACCOUNTS_END = "&lt;/accounts&gt;";
    private static final String ACCOUNT_START = "&lt;account&gt;";
    private static final String ACCOUNT_END = "&lt;/account&gt;";
    private static final String CONNECTIONS_START = "&lt;connections&gt;";
    private static final String CONNECTIONS_END = "&lt;/connections&gt;";
    private static final String CONNECTION_START = "&lt;connection&gt;";
    private static final String CONNECTION_END = "&lt;/connection&gt;";
    private static final String CREDENTIALS_START = "&lt;credentials&gt;";
    private static final String CREDENTIALS_END = "&lt;/credentials&gt;";
    private static final String CREDENTIAL_START = "&lt;credential&gt;";
    private static final String CREDENTIAL_END = "&lt;/credential&gt;";
    private static MDSRVConnector theConnector = null;

    private MDSRVConnector() throws CMException {
        if (connectionHandler == null) {
            connectionHandler = new MDSRVBusConnectionHandler();
        }
    }

    public static synchronized MDSRVConnector getMDSRVConnector() throws CMException {
        if (null == theConnector) {
            theConnector = new MDSRVConnector();
            isActive = true;
        }
        return theConnector;
    }

    protected static synchronized void setHandlerForTesting(MDSRVBusConnectionHandler handler) {
        connectionHandler = handler;
    }

    private StringBuffer startAdd(StringBuffer sb) {
        sb.append("<mdsrv1:");
        sb.append("runSpecification");
        sb.append(" xmlns:SOAP-ENV=\"");
        sb.append("http://schemas.xmlsoap.org/soap/envelope/");
        sb.append("\" xmlns:xsi=\"");
        sb.append("http://www.w3.org/2001/XMLSchema-instance");
        sb.append("\" xmlns:SOAP-ENC=\"");
        sb.append("http://schemas.xmlsoap.org/soap/encoding/");
        sb.append("\" xmlns:xsd=\"");
        sb.append("http://www.w3.org/2001/XMLSchema");
        sb.append("\" xmlns:bus=\"");
        sb.append("http://developer.cognos.com/schemas/bibus/3/");
        sb.append("\" xmlns:cm=\"");
        sb.append("http://developer.cognos.com/schemas/bibus/3/");
        sb.append("\" xmlns:mdsrv1=\"");
        sb.append("http://developer.cognos.com/schemas/metadataService/1");
        sb.append("\">");
        return sb;
    }

    private StringBuffer endAdd(StringBuffer sb) {
        sb.append("</mdsrv1:");
        sb.append("runSpecification");
        sb.append(">");
        return sb;
    }

    private StringBuffer addOptions(StringBuffer sb) {
        sb.append("<options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:option[2]\">");
        sb.append("<item xsi:type=\"bus:asynchOptionInt\">");
        sb.append("<name xsi:type=\"bus:asynchOptionEnum\">primaryWaitThreshold</name>");
        sb.append("<value xsi:type=\"xsd:int\">0</value>");
        sb.append("</item>");
        sb.append("</options>");
        return sb;
    }

    private StringBuffer parameters(StringBuffer sb) {
        sb.append("<parameters xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:parameterValue[0]\"/>");
        return sb;
    }

    private void deteleLOBDataSetCommand(StringBuffer sb, List<String> camIDs, List<String> dsConnections, List<String> dsSignons) {
        sb.append("<specification xsi:type=\"bus:metadataServiceSpecification\">");
        sb.append("<value xsi:type=\"bus:specification\">");
        sb.append("&lt;cleanLOBRepository&gt;&lt;input&gt;");
        sb.append(ACCOUNTS_START);
        for (String camID : camIDs) {
            sb.append(ACCOUNT_START);
            sb.append(camID);
            sb.append(ACCOUNT_END);
        }
        sb.append(ACCOUNTS_END);
        if (dsConnections != null && !dsConnections.isEmpty()) {
            sb.append(CONNECTIONS_START);
            for (String connection : dsConnections) {
                sb.append(CONNECTION_START);
                sb.append(connection);
                sb.append(CONNECTION_END);
            }
            sb.append(CONNECTIONS_END);
        }
        if (dsSignons != null && !dsSignons.isEmpty()) {
            sb.append(CREDENTIALS_START);
            for (String credential : dsSignons) {
                sb.append(CREDENTIAL_START);
                sb.append(credential);
                sb.append(CREDENTIAL_END);
            }
            sb.append(CREDENTIALS_END);
        }
        sb.append("&lt;/input&gt;&lt;/cleanLOBRepository&gt;");
        sb.append("</value>");
        sb.append("</specification>");
    }

    public void deleteDataSets(List<String> camIDs) {
        this.deleteDataSets(camIDs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataSets(List<String> camIDs, List<String> dsConnections, List<String> dsSignons) {
        MDSRVPostMethod bpm = new MDSRVPostMethod();
        String requestBody = this.createSOAPBody(camIDs, dsConnections, dsSignons);
        ((BusMethod)bpm).setBody(requestBody);
        MDSRVConnector mDSRVConnector = theConnector;
        synchronized (mDSRVConnector) {
            if (null != connectionHandler) {
                connectionHandler.execute(bpm, new AsyncDOMResponseProcessor());
            }
        }
    }

    protected String createSOAPBody(List<String> camIDs, List<String> dsConnections, List<String> dsSignons) {
        StringBuffer sb = new StringBuffer();
        this.startAdd(sb);
        this.deteleLOBDataSetCommand(sb, camIDs, dsConnections, dsSignons);
        this.parameters(sb);
        this.addOptions(sb);
        this.endAdd(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        MDSRVConnector mDSRVConnector = theConnector;
        synchronized (mDSRVConnector) {
            if (null != connectionHandler) {
                return false == connectionHandler.isProcessing();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MDSRVConnector mDSRVConnector = theConnector;
        synchronized (mDSRVConnector) {
            if (null != connectionHandler) {
                connectionHandler.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminate() {
        if (isActive) {
            isActive = false;
            if (null != theConnector) {
                MDSRVConnector mDSRVConnector = theConnector;
                synchronized (mDSRVConnector) {
                    connectionHandler.terminate();
                    connectionHandler = null;
                }
                theConnector = null;
            }
        }
    }
}

