/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.MSConnector;

import com.cognos.cm.connectors.MSConnector.MSConnector;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.XMLElement;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class DeploymentProgressThread {
    private Timer timer = null;
    private boolean isRunning = false;
    private boolean isExport = false;
    private Deployment deploymentHandle = null;
    private String bibusHeader = null;

    public DeploymentProgressThread(Deployment obj, CMExecutionContext deploymentExeC, boolean export2) {
        this.deploymentHandle = obj;
        this.isExport = export2;
        XMLElement xmlBibusHeaderReceived = deploymentExeC.getBiBusHeaderElement();
        if (xmlBibusHeaderReceived == null) {
            return;
        }
        XMLElement xmlBibusHeader = XMLElement.copyFrom(xmlBibusHeaderReceived);
        XMLElement xmlTracking = xmlBibusHeader.getOptionalChildWithName("tracking");
        if (xmlTracking != null) {
            xmlTracking.deleteChildWithName("conversationContext");
        }
        this.bibusHeader = xmlBibusHeader.makeXML("\t", true, true);
    }

    public void run() {
        this.isRunning = true;
        this.timer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (DeploymentProgressThread.this.isRunning) {
                    DeploymentProgressThread.this.addHistoryDetail();
                } else {
                    this.cancel();
                }
            }
        };
        this.timer.schedule(task, AdvancedSettings.PROGRESS_LOG_FREQUENCY, (long)AdvancedSettings.PROGRESS_LOG_FREQUENCY);
    }

    private void addHistoryDetail() {
        this.setThreadExecutionContext();
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("deployed", Integer.toString(this.deploymentHandle.getNumberOfObjectsDeployed())), new CMException.Parm("failed", Integer.toString(this.deploymentHandle.getNumberOfObjectsFailed()))};
        String code = this.isExport ? "cmDeploymentProgressExport" : "cmDeploymentProgressImport";
        CMException detailEx = new CMException(code, parms);
        String detail = CMError.trimErrorCode(detailEx.getMessage(Locale.getDefault()));
        try {
            MSConnector msd = MSConnector.getMSConnector();
            String eventId = this.deploymentHandle.getEventId();
            if (eventId == null) {
                throw new CMException("cmMissingEventId");
            }
            msd.addHistoryDetail(detail, "info", eventId);
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
            CMExecutionContext.tearDown();
        }
    }

    private void setThreadExecutionContext() {
        CMExecutionContext.setUp();
        CMExecutionContext thisExecutionContext = CMExecutionContext.get();
        String strSessionContentLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        thisExecutionContext.setPreference(CMPreference.CONTENTLOCALE, strSessionContentLocale);
        thisExecutionContext.setPreference(CMPreference.PRODUCTLOCALE, strSessionContentLocale);
        thisExecutionContext.setRequestContext("DeploymentProgress_REQ");
        thisExecutionContext.setSessionContext("DeploymentProgress_SESS");
        thisExecutionContext.setBIBUSheader(this.bibusHeader);
    }

    public void terminateDeploymentProgress() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.isRunning = false;
    }
}

