/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.MSConnector;

import com.cognos.cm.connectors.AsyncDOMResponseProcessor;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.MSConnector.MSBusConnectionHandler;
import com.cognos.cm.connectors.MSConnector.MSPostMethod;
import com.cognos.cm.connectors.MSConnector.MonitorServiceDelegate;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDateUtils;

public class MSConnector
implements MonitorServiceDelegate {
    private MSBusConnectionHandler connectionHandler = new MSBusConnectionHandler();
    private static boolean isActive = false;
    private static MSConnector theConnector = null;

    private MSConnector() throws CMException {
    }

    public static synchronized MSConnector getMSConnector() throws CMException {
        if (null == theConnector) {
            theConnector = new MSConnector();
            isActive = true;
        }
        return theConnector;
    }

    private StringBuffer startAdd(StringBuffer sb) {
        sb.append("<ms1:");
        sb.append("add");
        sb.append(" xmlns:SOAP-ENV=\"");
        sb.append("http://schemas.xmlsoap.org/soap/envelope/");
        sb.append("\" xmlns:xsi=\"");
        sb.append("http://www.w3.org/2001/XMLSchema-instance");
        sb.append("\" xmlns:SOAP-ENC=\"");
        sb.append("http://schemas.xmlsoap.org/soap/encoding/");
        sb.append("\" xmlns:xsd=\"");
        sb.append("http://www.w3.org/2001/XMLSchema");
        sb.append("\" xmlns:bus=\"");
        sb.append("http://developer.cognos.com/schemas/bibus/3/");
        sb.append("\" xmlns:cm=\"");
        sb.append("http://developer.cognos.com/schemas/bibus/3/");
        sb.append("\" xmlns:ms1=\"");
        sb.append("http://developer.cognos.com/schemas/monitorService/1");
        sb.append("\">");
        return sb;
    }

    private StringBuffer endAdd(StringBuffer sb) {
        sb.append("</ms1:");
        sb.append("add");
        sb.append(">");
        return sb;
    }

    private StringBuffer eventId(StringBuffer sb, String eventId) {
        sb.append("<eventID xsi:type=\"xsd:string\">");
        sb.append(eventId);
        sb.append("</eventID>");
        return sb;
    }

    private StringBuffer addOptions(StringBuffer sb) {
        sb.append("<options xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:option[1]\">");
        sb.append("<item xsi:type=\"bus:asynchOptionInt\">");
        sb.append("<name xsi:type=\"bus:asynchOptionEnum\">primaryWaitThreshold</name>");
        sb.append("<value xsi:type=\"xsd:int\">0</value>");
        sb.append("</item>");
        sb.append("</options>");
        return sb;
    }

    private StringBuffer parameters(StringBuffer sb) {
        sb.append("<parameters xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:parameterValue[0]\"/>");
        return sb;
    }

    private StringBuffer historyDetail(StringBuffer sb, String severity, String detail) {
        String now = CMDateUtils.getIsoDate();
        sb.append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">");
        sb.append("<item xsi:type=\"bus:historyDetail\">");
        sb.append("<detail xsi:type=\"bus:stringProp\">");
        sb.append("<schemaInfo xsi:nil=\"true\"/>");
        sb.append("<value xsi:type=\"xsd:string\">");
        sb.append(detail);
        sb.append("</value>");
        sb.append("</detail>");
        sb.append("<detailTime xsi:type=\"bus:dateTimeProp\">");
        sb.append("<schemaInfo xsi:nil=\"true\"/>");
        sb.append("<value xsi:type=\"xsd:dateTime\">");
        sb.append(now);
        sb.append("</value>");
        sb.append("</detailTime>");
        sb.append("<severity xsi:type=\"bus:severityEnumProp\">");
        sb.append("<schemaInfo xsi:nil=\"true\"/>");
        sb.append("<value xsi:type=\"bus:severityEnum\">");
        sb.append(severity);
        sb.append("</value>");
        sb.append("</severity>");
        sb.append("</item>");
        sb.append("</objects>");
        return sb;
    }

    private StringBuffer historyDetailRequestArguments(StringBuffer sb, CMDbStoreTypedNameValuePairArray props) {
        int propSize = props.getSize();
        sb.append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">");
        sb.append("<item xsi:type=\"bus:historyDetailRequestArguments\">");
        sb.append("<options xsi:type=\"bus:optionArrayProp\">");
        sb.append("<schemaInfo xsi:nil=\"true\"/>");
        sb.append("<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:option[" + propSize + "]\">");
        for (int i = 0; i < propSize; ++i) {
            CMTypedNameValuePair pair = props.getPair(i);
            sb.append("<item xsi:type=\"bus:" + pair.getTypeName() + "\">");
            sb.append(props.getXMLItemContent(i, CMProperty.NAME, 0));
            sb.append("</item>");
        }
        sb.append("</value>");
        sb.append("</options>");
        sb.append("</item>");
        sb.append("</objects>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHistoryDetail(String detail, String severity, String eventId) {
        MSPostMethod bpm = new MSPostMethod();
        StringBuffer sb = new StringBuffer();
        this.startAdd(sb);
        this.eventId(sb, eventId);
        this.historyDetail(sb, severity, detail);
        this.parameters(sb);
        this.addOptions(sb);
        this.endAdd(sb);
        ((BusMethod)bpm).setBody(sb.toString());
        MSConnector mSConnector = theConnector;
        synchronized (mSConnector) {
            if (null != this.connectionHandler) {
                this.connectionHandler.execute(bpm, new AsyncDOMResponseProcessor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRunOptionDetail(CMDbStoreTypedNameValuePairArray props, String eventId) {
        MSPostMethod bpm = new MSPostMethod();
        StringBuffer sb = new StringBuffer();
        this.startAdd(sb);
        this.eventId(sb, eventId);
        this.historyDetailRequestArguments(sb, props);
        this.parameters(sb);
        this.addOptions(sb);
        this.endAdd(sb);
        ((BusMethod)bpm).setBody(sb.toString());
        MSConnector mSConnector = theConnector;
        synchronized (mSConnector) {
            if (null != this.connectionHandler) {
                this.connectionHandler.execute(bpm, new AsyncDOMResponseProcessor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        MSConnector mSConnector = theConnector;
        synchronized (mSConnector) {
            if (null != this.connectionHandler) {
                return false == this.connectionHandler.isProcessing();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MSConnector mSConnector = theConnector;
        synchronized (mSConnector) {
            if (null != this.connectionHandler) {
                this.connectionHandler.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminate() {
        if (isActive) {
            isActive = false;
            if (null != theConnector) {
                MSConnector mSConnector = theConnector;
                synchronized (mSConnector) {
                    MSConnector.theConnector.connectionHandler.terminate();
                    MSConnector.theConnector.connectionHandler = null;
                }
                theConnector = null;
            }
        }
    }
}

