/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.SDSConnector;

import com.cognos.cm.connectors.BusConnectionPool;
import com.cognos.cm.connectors.SDSConnector.SDSAddPostMethod;
import com.cognos.cm.connectors.SDSConnector.SDSDeletePostMethod;
import com.cognos.cm.connectors.SDSConnector.SDSResponseException;
import com.cognos.cm.connectors.SDSConnector.SDSSynchronizeSchedulesPostMethod;
import com.cognos.cm.connectors.SDSConnector.SDSUpdatePostMethod;
import com.cognos.cm.connectors.SDSConnector.ScheduleReplicationThread;
import com.cognos.cm.connectors.SDSConnector.SynchronizationEntry;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.notification.CMDbStoreNotification;
import com.cognos.cm.dbstore.notification.CMDbStoreNotificationObserver;
import com.cognos.cm.dbstore.notification.CMDbStoreNotificationObservers;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class SDSConnector
implements CMDbStoreNotificationObserver {
    private static final String DEFAULT_NAMESPACES = " xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:ems1=\"http://developer.cognos.com/schemas/eventManagementService/1";
    private static boolean bEnabled_ = true;
    private static SDSConnector theConnection_;
    private static URL url_;
    private static BusConnectionPool busConnectionPool_;
    protected static ScheduleReplicationThread replicationThread_;
    private static CMProperty[] replicateProps_;
    protected static int idxReplicationStatusProp_;
    protected static int idxVersionProp_;
    private List<CMObjectClass> objectClasses_;

    private SDSConnector() throws CMException {
        if (!SDSConnector.isEnabled()) {
            return;
        }
        IConfiguration config = ConfigurationFactory.getConfig();
        try {
            String url = config.getCognosProp("internalDispatcher");
            try {
                url_ = new URL(url);
            }
            catch (MalformedURLException e) {
                SDSConnector.disableConnector();
                throw new CMException(e, "cmErrDispatcherURL");
            }
            busConnectionPool_ = new BusConnectionPool(url_.getHost(), url_.getPort(), url_.getPath(), config.isInternalSSL(), 2, 100, AdvancedSettings.SCHEDULEREPLICATIONNOTIFICATIONTIMEOUT);
        }
        catch (CMConfigurationException ex) {
            throw new CMException(ex, "cmUnexpectedError");
        }
        CMDbStoreNotificationObservers.addObserver(this);
    }

    public static boolean isEnabled() {
        return bEnabled_ && AdvancedSettings.SCHEDULEREPLICATIONENABLED && !ContentManager.startedSelf_;
    }

    public static void disableConnector() {
        bEnabled_ = false;
    }

    public static void enableConnector() {
        bEnabled_ = true;
    }

    public static synchronized void terminate() throws IOException {
        if (replicationThread_ != null) {
            replicationThread_.terminateReplication();
        }
        if (busConnectionPool_ != null) {
            busConnectionPool_.terminate();
        }
    }

    public static boolean currentRequestIsFromSDS() {
        String service = CMExecutionContext.get().getServiceId();
        return service != null && service.equals("SDS") || replicationThread_ != null && replicationThread_ == Thread.currentThread();
    }

    public static SDSConnector getConnector() throws CMException {
        if (theConnection_ == null) {
            if (!SDSConnector.isEnabled()) {
                return null;
            }
            theConnection_ = new SDSConnector();
        }
        return theConnection_;
    }

    @Override
    public void notify(List<CMDbStoreNotification> notifications) {
        if (replicationThread_ != null && !SDSConnector.currentRequestIsFromSDS()) {
            replicationThread_.addNotifications(notifications);
        }
        this.runReplicator();
    }

    @Override
    public List<CMObjectClass> getObjectClasses() {
        if (this.objectClasses_ == null) {
            this.objectClasses_ = new ArrayList<CMObjectClass>();
            this.objectClasses_.add(CMObjectClass.SCHEDULE);
        }
        return this.objectClasses_;
    }

    public static void setReplicateProps(CMProperty[] newArray) {
        if (replicateProps_ == null) {
            replicateProps_ = newArray;
        } else {
            CMProperty[] newArray2 = new CMProperty[replicateProps_.length + newArray.length];
            System.arraycopy(replicateProps_, 0, newArray2, 0, replicateProps_.length);
            System.arraycopy(newArray, 0, newArray2, replicateProps_.length, newArray.length);
            replicateProps_ = newArray2;
        }
        if (idxReplicationStatusProp_ == -1) {
            for (int i = 0; i < replicateProps_.length; ++i) {
                if (!replicateProps_[i].getName().equals("_scheduleReplicationStatus")) continue;
                idxReplicationStatusProp_ = i;
                break;
            }
        }
        if (idxVersionProp_ == -1) {
            for (int i = 0; i < replicateProps_.length; ++i) {
                if (!replicateProps_[i].getName().equals("version")) continue;
                idxVersionProp_ = i;
                break;
            }
        }
    }

    public static CMProperty[] getReplicateProps() {
        if (idxVersionProp_ == -1) {
            idxVersionProp_ = replicateProps_.length;
            CMProperty[] newArray2 = new CMProperty[replicateProps_.length + 1];
            System.arraycopy(replicateProps_, 0, newArray2, 0, replicateProps_.length);
            replicateProps_ = newArray2;
            SDSConnector.replicateProps_[SDSConnector.idxVersionProp_] = CMProperty.VERSION;
        }
        return replicateProps_;
    }

    protected static Object getSDSDefaultValue(CMProperty sdsProp) {
        if (sdsProp.getType() == CMPropertyTypes.XML_BOOLEAN) {
            return new String("false");
        }
        if (sdsProp.getType() == CMPropertyTypes.XML_INTEGER || sdsProp.getType() == CMPropertyTypes.XML_INT || sdsProp.getType() == CMPropertyTypes.XML_POSITIVEINTEGER) {
            return new Integer(1);
        }
        if (sdsProp.getName().equals("type")) {
            return new String("monthlyAbsolute");
        }
        return null;
    }

    public List<String> addNotify(List<String> adds) throws CMException, SDSResponseException {
        if (!SDSConnector.isEnabled()) {
            return null;
        }
        SDSAddPostMethod post = new SDSAddPostMethod();
        post.addRequestHeaders(url_.getPath());
        StringBuilder sb = new StringBuilder(3000);
        sb.append("<ems1:");
        sb.append("addSchedules");
        sb.append(DEFAULT_NAMESPACES);
        sb.append("\">");
        sb.append("<search xsi:type=\"xsd:string\" xsi:nil=\"true\"/>");
        sb.append("<objects SOAP-ENC:arrayType=\"bus:schedule[]\" xsi:type=\"SOAP-ENC:Array\">");
        for (String schedule : adds) {
            sb.append("<item xsi:type=\"bus:schedule\">");
            sb.append(schedule);
            sb.append("</item>");
        }
        sb.append("</objects>");
        sb.append("<options xsi:nil=\"true\"/>");
        sb.append("</ems1:");
        sb.append("addSchedules");
        sb.append(">");
        String message = this.massageRunOptions(sb.toString(), "addSchedules");
        post.setBody(message);
        post.prepareRequest();
        List<String> taskIDs = null;
        BusConnectionPool.BusConnection obj = null;
        try {
            obj = busConnectionPool_.get();
            obj.execute(post);
            taskIDs = post.processResponse();
        }
        catch (IOException e) {
            throw new SDSResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "SDS"), true, null);
        }
        finally {
            if (obj != null) {
                obj.release(post);
            }
        }
        return taskIDs;
    }

    public boolean deleteNotify(List<String> taskIDs) throws CMException, SDSResponseException {
        if (!SDSConnector.isEnabled()) {
            return false;
        }
        SDSDeletePostMethod post = new SDSDeletePostMethod();
        post.addRequestHeaders(url_.getPath());
        StringBuilder sb = new StringBuilder(2000);
        sb.append("<ems1:");
        sb.append("deleteSchedules");
        sb.append(DEFAULT_NAMESPACES);
        sb.append("\">");
        sb.append("<");
        sb.append("taskIDs");
        sb.append(" xsitype=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[]");
        sb.append("\" xmlns:SOAP-ENC=\"");
        sb.append("http://schemas.xmlsoap.org/soap/encoding/");
        sb.append("\" xmlns:xsi=\"");
        sb.append("http://www.w3.org/2001/XMLSchema-instance");
        sb.append("\"> ");
        for (String taskID : taskIDs) {
            sb.append("<item xsi:type=\"xsd:string\">");
            sb.append(taskID);
            sb.append("</item>");
        }
        sb.append("</");
        sb.append("taskIDs");
        sb.append(">");
        sb.append("</ems1:");
        sb.append("deleteSchedules");
        sb.append(">");
        post.setBody(sb.toString());
        post.prepareRequest();
        BusConnectionPool.BusConnection obj = null;
        try {
            obj = busConnectionPool_.get();
            obj.execute(post);
            post.processResponse();
        }
        catch (IOException e) {
            throw new SDSResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "SDS"), true, null);
        }
        finally {
            if (obj != null) {
                obj.release(post);
            }
        }
        return true;
    }

    public boolean updateNotify(List<String> updates) throws CMException, SDSResponseException {
        if (!SDSConnector.isEnabled()) {
            return false;
        }
        SDSUpdatePostMethod post = new SDSUpdatePostMethod();
        post.addRequestHeaders(url_.getPath());
        StringBuilder sb = new StringBuilder(3000);
        sb.append("<ems1:");
        sb.append("updateSchedules");
        sb.append(DEFAULT_NAMESPACES);
        sb.append("\">");
        sb.append("<updates SOAP-ENC:arrayType=\"bus:schedule[]\" xsi:type=\"SOAP-ENC:Array\">");
        for (String schedule : updates) {
            sb.append("<item xsi:type=\"bus:schedule\">");
            sb.append(schedule);
            sb.append("</item>");
        }
        sb.append("</updates></ems1:");
        sb.append("updateSchedules");
        sb.append(">");
        String message = this.massageRunOptions(sb.toString(), "updateSchedules");
        post.setBody(message);
        post.prepareRequest();
        BusConnectionPool.BusConnection obj = null;
        try {
            obj = busConnectionPool_.get();
            obj.execute(post);
            post.processResponse();
        }
        catch (IOException e) {
            throw new SDSResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "SDS"), true, null);
        }
        finally {
            if (obj != null) {
                obj.release(post);
            }
        }
        return true;
    }

    public XMLElement synchronizeSchedulesNotify(Collection<SynchronizationEntry> scheduleData) throws CMException, SDSResponseException {
        if (!SDSConnector.isEnabled()) {
            return null;
        }
        SDSSynchronizeSchedulesPostMethod post = new SDSSynchronizeSchedulesPostMethod();
        post.addRequestHeaders(url_.getPath());
        StringBuilder sb = new StringBuilder(3000);
        sb.append("<ems1:");
        sb.append("synchronizeSchedules");
        sb.append(DEFAULT_NAMESPACES);
        sb.append("\">");
        sb.append("<");
        sb.append("scheduleData");
        sb.append(" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:scheduleSynchronizationInput[]\">");
        for (SynchronizationEntry entry : scheduleData) {
            sb.append("<item xsi:type=\"bus:scheduleSynchronizationInput\">");
            sb.append("<taskID xsi:type=\"xsd:string\">");
            sb.append(entry.taskID);
            sb.append("</taskID>");
            sb.append("<version xsi:type=\"xsd:integer\">");
            sb.append(entry.version);
            sb.append("</version>");
            sb.append("</item>");
        }
        sb.append("</");
        sb.append("scheduleData");
        sb.append(">");
        sb.append("</ems1:");
        sb.append("synchronizeSchedules");
        sb.append(">");
        post.setBody(sb.toString());
        post.prepareRequest();
        XMLElement synchronizeSchedulesResult = null;
        BusConnectionPool.BusConnection obj = null;
        try {
            obj = busConnectionPool_.get();
            obj.execute(post);
            synchronizeSchedulesResult = post.processResponse();
        }
        catch (IOException e) {
            throw new SDSResponseException((Exception)e, "cmConnectorIOError", new CMException.Parm("connector", "SDS"), true, null);
        }
        finally {
            if (obj != null) {
                obj.release(post);
            }
        }
        return synchronizeSchedulesResult;
    }

    public synchronized void runReplicator() {
        if (!SDSConnector.isEnabled()) {
            return;
        }
        if (replicationThread_ == null) {
            replicationThread_ = new ScheduleReplicationThread();
            replicationThread_.start();
        }
        if (replicationThread_ != null) {
            replicationThread_.runNow();
        }
    }

    protected synchronized void replicatorTerminated() {
        replicationThread_ = null;
    }

    private String massageRunOptions(String request, String requestType) throws CMException {
        XMLElement requestElement = null;
        try {
            XMLDocParser parser = new XMLDocParser();
            XMLDoc requestDoc = parser.readXML(request);
            requestElement = requestDoc.getRootXMLElement();
        }
        catch (CMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMException(e, "cmErrParse");
        }
        XMLElement schedules = requestType.equals("addSchedules") ? requestElement.getChildWithName("objects") : requestElement.getChildWithName("updates");
        if (!schedules.hasChildren()) {
            return request;
        }
        for (XMLElement schedule : schedules.getChildren()) {
            XMLElement optionsValue;
            XMLElement options = schedule.getOptionalChildWithName(CMProperty.OPTIONS.getName());
            if (options == null) {
                options = schedule.addChild(CMSOAPConstants.NS_BIBUS, CMProperty.OPTIONS.getName(), null, null);
            }
            if ((optionsValue = options.getOptionalChildWithName("value")) == null || !optionsValue.hasChildren()) continue;
            ListIterator<XMLElement> optionsIterator = optionsValue.children_.listIterator();
            while (optionsIterator.hasNext()) {
                XMLElement option = optionsIterator.next();
                XMLElement optionName = option.getChildWithName("name");
                XMLElement optionValue = option.getOptionalChildWithName("value");
                if (optionName.value_.equals("saveAs")) {
                    XMLElement parentSearchPath;
                    XMLElement objectName;
                    XMLElement objectClass = option.getOptionalChildWithName("objectClass");
                    if (objectClass != null) {
                        objectClass.xsiTypeNs_ = CMSOAPConstants.NS_BIBUS;
                        if ("ReportView".equals(objectClass.value_)) {
                            objectClass.value_ = "reportView";
                        }
                    }
                    if ((objectName = option.getOptionalChildWithName("objectName")) != null) {
                        objectName.xsiTypeNs_ = CMSOAPConstants.NS_BIBUS;
                        if (objectName.hasChildren()) {
                            for (XMLElement item : objectName.getChildren()) {
                                item.xsiTypeNs_ = CMSOAPConstants.NS_BIBUS;
                                XMLElement value = item.getOptionalChildWithName("value");
                                if (value == null) continue;
                                value.xsiTypeNs_ = CMSOAPConstants.NS_XMLSCHEMA;
                            }
                        }
                    }
                    if ((parentSearchPath = option.getOptionalChildWithName("parentSearchPath")) == null) continue;
                    parentSearchPath.xsiTypeNs_ = CMSOAPConstants.NS_XMLSCHEMA;
                    continue;
                }
                if (optionValue == null || optionValue.xsiType_ == null) continue;
                if (optionValue.xsiType_.equals(CMPropertyTypes.XML_BOOLEAN.getName()) || optionValue.xsiType_.equals(CMPropertyTypes.XML_INT.getName()) || optionValue.xsiType_.equals(CMPropertyTypes.XML_STRING.getName())) {
                    optionValue.xsiTypeNs_ = CMSOAPConstants.NS_XMLSCHEMA;
                    continue;
                }
                if (!optionValue.xsiType_.equalsIgnoreCase(CMPropertyTypes.BIBUS_LANGUAGEARRAY.getName()) && !optionValue.xsiType_.equalsIgnoreCase(CMPropertyTypes.BIBUS_STRINGARRAY.getName())) continue;
                optionValue = optionValue.getOptionalChildWithName("value");
                option.replaceChild(optionValue);
            }
            schedule.replaceChild(options);
        }
        return requestElement.makeXML(null, true, true);
    }

    static {
        idxReplicationStatusProp_ = -1;
        idxVersionProp_ = -1;
    }
}

