/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.SDSConnector;

import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.connectors.SDSConnector.SDSResponseException;
import com.cognos.cm.connectors.SDSConnector.SDSXMLGenerator;
import com.cognos.cm.connectors.SDSConnector.SynchronizationEntry;
import com.cognos.cm.dbstore.notification.CMDbStoreNotification;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScheduleReplicationThread
extends Thread {
    private static final String SDS_ACTION_ADD = "add";
    private static final String SDS_ACTION_UPDATE = "update";
    private static final String SDS_ACTION_DELETE = "delete";
    private SDSConnector conn_;
    public boolean shutDown_;
    private boolean schedulesSynchronized_;
    private ArrayList<CMDbStoreNotification> pendingNotifications_ = new ArrayList();
    private int maxSchedules_ = AdvancedSettings.SCHEDULEREPLICATIONMAXSCHEDULES;
    private int waitTime_ = 1;
    private SDSXMLGenerator xmlGen_;

    public ScheduleReplicationThread() {
        super("CRN.CM.ScheduleReplication");
        this.debug("CRN.CM.ScheduleReplication thread created.");
    }

    @Override
    public void run() {
        this.debug("CRN.CM.ScheduleReplication.run: ENTERED.");
        try {
            this.replicateSchedules();
        }
        finally {
            if (this.conn_ != null) {
                this.conn_.replicatorTerminated();
            }
        }
        this.debug("CRN.CM.ScheduleReplication.run: EXITED.");
    }

    public synchronized void runNow() {
        this.notify();
    }

    public synchronized void terminateReplication() {
        this.shutDown_ = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifications(List<CMDbStoreNotification> notifications) {
        ArrayList<CMDbStoreNotification> arrayList = this.pendingNotifications_;
        synchronized (arrayList) {
            for (CMDbStoreNotification notification : notifications) {
                if (notification.getObjectClass() != CMObjectClass.SCHEDULE) continue;
                int existingNotificationIndex = this.pendingNotifications_.indexOf(notification);
                if (existingNotificationIndex != -1) {
                    if (notification.getOperation() == 7) continue;
                    this.pendingNotifications_.add(existingNotificationIndex, notification);
                    continue;
                }
                this.pendingNotifications_.add(notification);
            }
        }
    }

    private boolean doDebug() {
        return CMIndications.logEnabled("Trace.CM.SDS", 10000);
    }

    private void debug(String text) {
        if (this.doDebug()) {
            CMIndications.CMTraceText("Trace.CM.SDS", 10000, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateSchedules() {
        do {
            try {
                boolean notificationsSent;
                ScheduleReplicationThread scheduleReplicationThread = this;
                synchronized (scheduleReplicationThread) {
                    this.wait(this.waitTime_);
                }
                this.setThreadExecutionContext();
                this.conn_ = SDSConnector.getConnector();
                if (this.shutDown_ || this.conn_ == null) continue;
                if (this.doDebug()) {
                    this.debug("CRN.CM.ScheduleReplication replicateSchedules ENTERED. isEnabled=" + SDSConnector.isEnabled() + " pending=" + this.getPendingNotificationsSize() + " waitTime_=" + this.waitTime_ + " maxSchedules_=" + this.maxSchedules_);
                }
                if (!SDSConnector.isEnabled()) {
                    this.shutDown_ = true;
                    continue;
                }
                if (!this.schedulesSynchronized_) {
                    this.synchronizeSchedules();
                    continue;
                }
                boolean bl = notificationsSent = this.notifyAddedSchedules() || this.notifyUpdatedSchedules() || this.notifyDeletedSchedules();
                if (this.maxSchedules_ < AdvancedSettings.SCHEDULEREPLICATIONMAXSCHEDULES) {
                    this.maxSchedules_ = Math.min(this.maxSchedules_ * 2, AdvancedSettings.SCHEDULEREPLICATIONMAXSCHEDULES);
                }
                if (notificationsSent) {
                    this.waitTime_ = AdvancedSettings.SCHEDULEREPLICATIONDELAY;
                    continue;
                }
                this.waitTime_ = 0;
            }
            catch (SDSResponseException ex) {
                boolean bLog = true;
                this.maxSchedules_ = 1;
                if (ex.bServer_) {
                    this.waitTime_ = this.waitTime_ < AdvancedSettings.SCHEDULEREPLICATIONMINRETRYPERIOD ? AdvancedSettings.SCHEDULEREPLICATIONMINRETRYPERIOD : Math.min(this.waitTime_ * 2, AdvancedSettings.SCHEDULEREPLICATIONMAXRETRYPERIOD);
                    if (ex.faultErrorCode_ != null) {
                        bLog = ScheduleReplicationThread.logThisErrorCode(ex.faultErrorCode_);
                    }
                }
                if (!bLog) continue;
                if (ex.bStayFatal) {
                    CMIndications.logException(ex);
                    continue;
                }
                this.logReplicationError(ex);
            }
            catch (InterruptedException e) {
                this.shutDown_ = true;
                this.logReplicationError(e);
            }
            catch (Exception ex) {
                this.logReplicationError(ex);
            }
            finally {
                CMExecutionContext.tearDown();
            }
        } while (!this.shutDown_);
        SDSConnector.replicationThread_ = null;
        this.debug("CRN.CM.ScheduleReplication replicateSchedules EXITED.");
    }

    private void logReplicationError(Exception ex) {
        CMException cme = new CMException(ex, "cmErrScheduleReplication");
        cme.setErrorLevel(40000);
        CMIndications.logException(cme);
    }

    private boolean notifyAddedSchedules() throws CMException {
        ArrayList<CMDbStoreNotification> notifications = this.getPendingNotifications(1);
        if (notifications.isEmpty()) {
            return false;
        }
        List<ICMStorePath> paths = this.getNotificationPaths(notifications);
        ArrayList<String> scheduleAdds = this.getScheduleProperties(paths, 1);
        if (scheduleAdds.size() > 0) {
            SDSConnector conn = SDSConnector.getConnector();
            List<String> taskIDs = null;
            try {
                taskIDs = conn.addNotify(scheduleAdds);
            }
            catch (SDSResponseException ex) {
                this.handleSDSResponseException(ex, notifications);
            }
            this.updateTaskIdsInStore(paths, taskIDs);
        }
        return scheduleAdds.size() > 0;
    }

    private boolean notifyUpdatedSchedules() throws CMException {
        ArrayList<CMDbStoreNotification> notifications = this.getPendingNotifications(7);
        if (notifications.size() == 0) {
            return false;
        }
        List<ICMStorePath> paths = this.getNotificationPaths(notifications);
        ArrayList<String> scheduleUpdates = this.getScheduleProperties(paths, 7);
        if (scheduleUpdates.size() > 0) {
            SDSConnector conn = SDSConnector.getConnector();
            try {
                conn.updateNotify(scheduleUpdates);
            }
            catch (SDSResponseException ex) {
                this.handleSDSResponseException(ex, notifications);
            }
        }
        return scheduleUpdates.size() > 0;
    }

    private boolean notifyDeletedSchedules() throws CMException {
        ArrayList<CMDbStoreNotification> notifications = this.getPendingNotifications(2);
        if (notifications.size() == 0) {
            return false;
        }
        ArrayList<String> deletedScheds = new ArrayList<String>();
        for (CMDbStoreNotification notification : notifications) {
            Map<CMProperty, Object> propValues = notification.getPropValues();
            Object taskID = propValues.get(CMProperty.TASKID);
            if (taskID == null) continue;
            deletedScheds.add((String)taskID);
        }
        if (deletedScheds.size() > 0) {
            SDSConnector conn = SDSConnector.getConnector();
            try {
                conn.deleteNotify(deletedScheds);
            }
            catch (SDSResponseException ex) {
                this.addNotifications(notifications);
            }
        }
        return deletedScheds.size() > 0;
    }

    private void handleSDSResponseException(SDSResponseException ex, List<CMDbStoreNotification> notifications) throws SDSResponseException {
        if (!this.clientError(ex) || this.maxSchedules_ > 1) {
            this.addNotifications(notifications);
            throw ex;
        }
        String path = notifications.get(0).getStoreID();
        path = CMStoreXPath.encodeStoreIdToPathString(path);
        CMIndications.logException(new CMException((Exception)ex, "cmCorruptedScheduleSpecification", new CMException.Parm("schedule", path)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskIdsInStore(List<ICMStorePath> schedulePaths, List<String> taskIDs) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        List<CMProperty> updateProps = Collections.singletonList(CMProperty.TASKID);
        List<Object> updateValues = null;
        if (taskIDs == null) {
            updateValues = Collections.singletonList("");
        }
        for (int i = 0; i < schedulePaths.size(); ++i) {
            if (taskIDs != null) {
                updateValues = Collections.singletonList(taskIDs.get(i));
            }
            CMStoreQueryResults results = null;
            try {
                ICMStorePath path = schedulePaths.get(i);
                path.setLockManagerUsageFlag(13);
                store.getLockManager().requestLocks(path);
                store.beginTransaction();
                results = store.executeQuery(path, null, null, 7, 512, null);
                store.update(results, updateProps, updateValues);
                store.commitTransaction();
                continue;
            }
            finally {
                if (results != null) {
                    results.release();
                }
                store.rollbackOpenTransaction();
                store.getLockManager().releaseLocks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getScheduleProperties(List<ICMStorePath> paths, int operation) throws CMException {
        ArrayList<String> result = new ArrayList<String>();
        CMStore store = CMExecutionContext.get().getStore();
        CMProperty[] props = SDSConnector.getReplicateProps();
        for (ICMStorePath path : paths) {
            CMStoreQueryResults results = null;
            try {
                String taskID;
                store.getLockManager().requestLocks(path);
                results = store.executeQuery(path, props, null, 0, 512, null);
                if (results == null || !results.next() || (taskID = this.generateScheduleXML(results, props, operation)) == null && operation != 1) continue;
                result.add(this.xmlGen_.getPropertyXML());
            }
            finally {
                if (results != null) {
                    results.release();
                }
                store.getLockManager().releaseLocks();
                path.clearLocksHaveBeenObtained();
            }
        }
        return result;
    }

    private String generateScheduleXML(CMStoreQueryResults results, CMProperty[] props, int operation) throws CMException {
        if (this.xmlGen_ == null) {
            this.xmlGen_ = new SDSXMLGenerator(results.getStore());
        }
        this.xmlGen_.init();
        String taskID = null;
        for (int i = 0; i < props.length; ++i) {
            Object objValue = results.getValue(i);
            if (props[i] == CMProperty.VERSION) {
                String version = objValue.toString();
                objValue = new Integer(Integer.parseInt(version)).toString();
            } else if (props[i] == CMProperty.TASKID && objValue != null) {
                if (operation == 1) continue;
                taskID = objValue.toString();
            }
            if (objValue == null) {
                objValue = SDSConnector.getSDSDefaultValue(props[i]);
            }
            if (objValue == null) continue;
            this.xmlGen_.emitProperty("", results, props[i], objValue, false);
        }
        return taskID;
    }

    private void setThreadExecutionContext() {
        CMExecutionContext.setUp();
        CMExecutionContext ctx = CMExecutionContext.get();
        String serverLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        ctx.setPreference(CMPreference.CONTENTLOCALE, serverLocale);
        ctx.setPreference(CMPreference.PRODUCTLOCALE, serverLocale);
        ctx.setBIBUSheader(CMExecutionContext.getDefaultBIBUSheader(serverLocale, serverLocale, "ScheduleReplication_SESS", "ScheduleReplication_REQ"));
        ctx.setRequestContext("ScheduleReplication_REQ");
        ctx.setSessionContext("ScheduleReplication_SESS");
    }

    private static boolean logThisErrorCode(String errorCode) {
        return !errorCode.equalsIgnoreCase("DISPATCHER_NOT_YET");
    }

    private void synchronizeSchedules() throws CMException {
        if (!SDSConnector.isEnabled()) {
            return;
        }
        long t1 = System.currentTimeMillis();
        Map<String, SynchronizationEntry> scheduleData = this.queryAllSchedules();
        if (scheduleData.size() != 0) {
            SDSConnector conn = SDSConnector.getConnector();
            XMLElement resultElement = conn.synchronizeSchedulesNotify(scheduleData.values());
            this.processSynchronizeSchedulesResult(resultElement, scheduleData);
        }
        this.schedulesSynchronized_ = true;
        this.waitTime_ = 1;
        if (this.doDebug()) {
            long duration = System.currentTimeMillis() - t1;
            this.debug("CRN.CM.ScheduleReplication synchronizeSchedules EXITED. duration=" + duration + " (ms)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SynchronizationEntry> queryAllSchedules() throws CMException {
        ArrayList<CMDbStoreNotification> notifications = new ArrayList<CMDbStoreNotification>();
        CMProperty[] props = new CMProperty[]{CMProperty.TASKID, CMProperty.VERSION, CMProperty.STOREID};
        OrderByField[] sortOrder = new OrderByField[]{new OrderByField(false, CMProperty.TASKID)};
        LinkedHashMap<String, SynchronizationEntry> scheduleData = new LinkedHashMap<String, SynchronizationEntry>();
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreQueryResults results = null;
        CMStoreXPath syncQuery = new CMStoreXPath("//schedule");
        try {
            this.debug("CRN.CM.ScheduleReplication: //schedule lock is acquired.");
            store.getLockManager().requestLocks(syncQuery);
            results = store.executeQuery(syncQuery, props, sortOrder, 0, 512, null);
            while (results.next()) {
                String taskID = ScheduleReplicationThread.getStringValue(results, 0);
                String version = ScheduleReplicationThread.getStringValue(results, 1);
                String storeID = ScheduleReplicationThread.getStringValue(results, 2);
                if (taskID != null && version != null) {
                    SynchronizationEntry entry = new SynchronizationEntry(taskID, version, storeID);
                    scheduleData.put(taskID, entry);
                    continue;
                }
                if (taskID != null) continue;
                CMDbStoreNotification notification = new CMDbStoreNotification(storeID, CMObjectClass.SCHEDULE, 1);
                notifications.add(notification);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            store.getLockManager().releaseLocks();
            this.debug("CRN.CM.ScheduleReplication: //schedule lock is released.");
        }
        if (notifications.size() > 0) {
            this.addNotifications(notifications);
        }
        return scheduleData;
    }

    private void processSynchronizeSchedulesResult(XMLElement resultElement, Map<String, SynchronizationEntry> scheduleData) throws CMException {
        if (resultElement == null || !resultElement.hasChildren()) {
            return;
        }
        ArrayList<CMDbStoreNotification> notifications = new ArrayList<CMDbStoreNotification>();
        for (XMLElement elItem : resultElement.getChildren()) {
            String sdsAction = elItem.getChildValueWithName("action");
            String taskID = elItem.getChildValueWithName("taskID");
            if (sdsAction.equals(SDS_ACTION_ADD) || sdsAction.equals(SDS_ACTION_UPDATE)) {
                SynchronizationEntry entry = scheduleData.get(taskID);
                if (entry == null) continue;
                int operation = sdsAction.equals(SDS_ACTION_UPDATE) ? 7 : 1;
                CMDbStoreNotification notification = new CMDbStoreNotification(entry.storeID, CMObjectClass.SCHEDULE, operation);
                notifications.add(notification);
                continue;
            }
            if (sdsAction.equals(SDS_ACTION_DELETE)) continue;
            CMIndications.logException(new CMException("cmErrScheduleReplication"));
        }
        if (notifications.size() > 0) {
            this.addNotifications(notifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CMDbStoreNotification> getPendingNotifications(int operation) {
        ArrayList<CMDbStoreNotification> notifications = new ArrayList<CMDbStoreNotification>();
        ArrayList<CMDbStoreNotification> arrayList = this.pendingNotifications_;
        synchronized (arrayList) {
            for (int i = 0; i < this.pendingNotifications_.size(); ++i) {
                CMDbStoreNotification notification = this.pendingNotifications_.get(i);
                if (notification.getOperation() == operation) {
                    notifications.add(notification);
                    this.pendingNotifications_.remove(i);
                    --i;
                }
                if (notifications.size() < this.maxSchedules_) continue;
                return notifications;
            }
        }
        return notifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPendingNotificationsSize() {
        ArrayList<CMDbStoreNotification> arrayList = this.pendingNotifications_;
        synchronized (arrayList) {
            return this.pendingNotifications_.size();
        }
    }

    private List<ICMStorePath> getNotificationPaths(List<CMDbStoreNotification> notifications) {
        ArrayList<ICMStorePath> paths = new ArrayList<ICMStorePath>();
        for (CMDbStoreNotification notification : notifications) {
            CMStoreXPath path = CMStoreXPath.fromStoreID(notification.getStoreID());
            paths.add(path);
        }
        return paths;
    }

    private boolean clientError(SDSResponseException ex) {
        return !ex.bServer_ || ex.faultErrorCode_ != null && ex.faultErrorCode_.indexOf("2107") != -1;
    }

    private static final String getStringValue(CMStoreQueryResults rs, int idx) throws CMException {
        String s;
        Object value = rs.getValue(idx);
        if (value != null && (s = value.toString()).length() != 0) {
            return s;
        }
        return null;
    }
}

