/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest;

import com.cognos.accman.jcam.crypto.BATrustedRequestSession;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;

public abstract class BusRESTMethod
extends BusMethod {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    protected static final String INDICES_ENDPOINT = "/indices";
    protected static final String SEARCH_ENDPOINT = "/search";
    protected static final String CM_INDEX_ENDPOINT = "/cm";
    protected static final String OBJECTS_ENDPOINT = "/objects";
    protected static final String BATCH_ENDPOINT = "/batch";

    @Override
    public void prepareRequest() throws CMException {
        this.setRequestHeader("Content-Length", String.valueOf(this.out.size()));
        this.setRequestHeader("Content-Type", "application/json; charset=utf-8");
    }

    @Override
    public void makeRequestTrusted(CAMFactory camFactory) throws CMException {
        try {
            BATrustedRequestSession batrs = camFactory.createBATrustedSession();
            this.setRequestHeader("X-CA-Authorization", batrs.generateToken("CM"));
        }
        catch (CAMCryptoException ex) {
            throw new CMException((Exception)((Object)ex), "cmFailCreateTrustToken", new CMException.Parm("ReqType", "Search"));
        }
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        this.out.writeTo(conn.getRequestOutputStream());
        return true;
    }

    @Override
    public void setBody(Object body) {
        try {
            ((JSONObject)body).serialize((OutputStream)this.out);
        }
        catch (IOException e) {
            CMIndications.logException(e);
        }
    }
}

