/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cm.connectors.AsyncBusConnectionHandler;
import com.cognos.cm.connectors.AsyncBusMethodProcessor;
import com.cognos.cm.connectors.AsyncResponseProcessor;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.rest.search.BusMethodProcessor;
import com.cognos.cm.connectors.rest.search.ResponseManager;
import com.cognos.cm.server.CMException;

public class BusConnectionHandler
extends AsyncBusConnectionHandler {
    private static ThreadLocal<ResponseManager> responseManager = new ThreadLocal<ResponseManager>(){

        @Override
        protected synchronized ResponseManager initialValue() {
            return new ResponseManager();
        }
    };

    public BusConnectionHandler(String searchUrl) throws CMException {
        super(searchUrl);
    }

    protected BusConnectionHandler(String searchUrl, int queueCapacity, int minThreads, int maxThreads) throws CMException {
        super(searchUrl, queueCapacity, minThreads, maxThreads);
    }

    private ResponseManager getResponseManager() {
        return responseManager.get();
    }

    public boolean isProcessing() {
        return this.getResponseManager().getOustandingRequests() != 0;
    }

    @Override
    protected AsyncBusMethodProcessor getBusMethodProcessor(BusMethod method, AsyncResponseProcessor responseProcessor) {
        BusMethodProcessor processor = new BusMethodProcessor(this.busPool, method, responseProcessor);
        this.getResponseManager().registerProcessor(processor);
        return processor;
    }

    public void executeSynchronously(BusMethod method, AsyncResponseProcessor responseProcessor) {
        method.addRequestHeaders(this.url.toString());
        AsyncBusMethodProcessor methodProcessor = this.getBusMethodProcessor(method, responseProcessor);
        try {
            method.prepareRequest();
            method.makeRequestTrusted(this.getCAMFactory());
            methodProcessor.execute();
        }
        catch (CMException e) {
            methodProcessor.setException(e);
            this.logError(e);
        }
    }

    public void clear() {
        this.getResponseManager().reset();
    }

    protected CAMFactory getCAMFactory() {
        return this.busPool.getCAMFactory();
    }
}

