/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.cm.connectors.AsyncResponseProcessor;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.rest.AsyncRESTResponseProcessor;
import com.cognos.cm.connectors.rest.search.BusConnectionHandler;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.ibm.json.java.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class Connector {
    private static final String BI_V1_ENDPOINT = "/bi/v1";
    private BusConnectionHandler connectionHandler;

    protected Connector() throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        String dispatcherUrl = config.getCognosProp("internalDispatcher");
        String url = this.buildConnectionURL(dispatcherUrl, BI_V1_ENDPOINT);
        this.connectionHandler = new BusConnectionHandler(url, AdvancedSettings.INDEX_ASYNCSERVICEBLOCKINGQUEUECAPACITY, AdvancedSettings.INDEX_ASYNCSERVICEMINTHREADS, AdvancedSettings.INDEX_ASYNCSERVICEMAXTHREADS);
    }

    protected Connector(BusConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public abstract void sendBatchRequest(JSONObject var1);

    private String buildConnectionURL(String dispatcherUrl, String suffix) {
        StringBuilder retUrl = new StringBuilder();
        try {
            URL dispatcher = new URL(dispatcherUrl);
            String protocol = dispatcher.getProtocol();
            String host = dispatcher.getHost();
            int port = dispatcher.getPort();
            retUrl.append(protocol);
            retUrl.append("://");
            retUrl.append(host);
            retUrl.append(":");
            retUrl.append(port);
            retUrl.append(suffix);
        }
        catch (MalformedURLException e) {
            CMIndications.logException(e);
        }
        return retUrl.toString();
    }

    public synchronized boolean isComplete() {
        if (this.connectionHandler != null) {
            return !this.connectionHandler.isProcessing();
        }
        return true;
    }

    public synchronized void clear() {
        if (this.connectionHandler != null) {
            this.connectionHandler.clear();
        }
    }

    protected synchronized void terminateConnector() {
        if (this.connectionHandler != null) {
            this.connectionHandler.terminate();
            this.connectionHandler = null;
        }
    }

    protected synchronized void executeSynchronously(BusMethod method) {
        this.executeSynchronously(method, new AsyncRESTResponseProcessor());
    }

    protected synchronized void executeSynchronously(BusMethod method, AsyncResponseProcessor responseProcessor) {
        if (this.connectionHandler != null) {
            this.connectionHandler.executeSynchronously(method, responseProcessor);
        }
    }
}

