/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.cm.connectors.rest.BusRESTMethod;
import com.cognos.cm.search.indexing.FieldSchema;
import com.cognos.cm.search.indexing.TraceLogger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class CreateCMIndexMethod
extends BusRESTMethod {
    private static final TraceLogger logger = new TraceLogger();
    private static List<FieldSchema> CMIndexFieldSchemaList = new ArrayList<FieldSchema>();

    public CreateCMIndexMethod(String indexId, String version) {
        JSONObject jsonObj = this.buildCMIndexJson(indexId, version);
        super.setBody(jsonObj);
    }

    public String getName() {
        return "POST";
    }

    @Override
    public void addRequestHeaders(String url) {
        String indicesEndPoint = url + "/indices";
        this.setPath(indicesEndPoint);
    }

    private JSONObject buildCMIndexJson(String indexId, String version) {
        JSONObject schemaObj = new JSONObject();
        schemaObj.put((Object)"id", (Object)"cm");
        schemaObj.put((Object)"uniqueid", (Object)"id");
        schemaObj.put((Object)"instance", (Object)indexId);
        schemaObj.put((Object)"version", (Object)version);
        JSONArray fieldsObj = new JSONArray();
        for (FieldSchema field : CMIndexFieldSchemaList) {
            JSONObject fieldObj = new JSONObject();
            fieldObj.put((Object)"name", (Object)field.getName());
            fieldObj.put((Object)"required", (Object)Boolean.toString(field.mandatorySchemaRequired()));
            fieldObj.put((Object)"type", (Object)field.getType());
            fieldObj.put((Object)"handling", (Object)field.getHandling());
            fieldObj.put((Object)"boost", (Object)field.getBoost());
            String analysis = field.getAnalysis();
            if (analysis != null) {
                fieldObj.put((Object)"analysis", (Object)analysis);
            }
            fieldsObj.add((Object)fieldObj);
        }
        schemaObj.put((Object)"fields", (Object)fieldsObj);
        this.log("CM.CreateCMIndexMethod: schema= " + schemaObj.toString());
        return schemaObj;
    }

    private void log(String text) {
        logger.logInfo(text);
    }

    static {
        CMIndexFieldSchemaList.add(new FieldSchema("id", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, true));
        CMIndexFieldSchemaList.add(new FieldSchema("type", FieldSchema.Type.STRING, FieldSchema.Handling.FACET, true));
        CMIndexFieldSchemaList.add(new FieldSchema("selfUrl", FieldSchema.Type.SELF_URL, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("name", FieldSchema.Type.MULTILINGUAL, new FieldSchema.Handling[]{FieldSchema.Handling.SEARCH, FieldSchema.Handling.SUGGEST}, true, 5, FieldSchema.Analysis.STEMMING, FieldSchema.Analysis.SPECIALCHARACTERS));
        CMIndexFieldSchemaList.add(new FieldSchema("description", FieldSchema.Type.MULTILINGUAL, new FieldSchema.Handling[]{FieldSchema.Handling.SEARCH}, false, 1, FieldSchema.Analysis.STEMMING, FieldSchema.Analysis.SPECIALCHARACTERS));
        CMIndexFieldSchemaList.add(new FieldSchema("permissions", FieldSchema.Type.SECURITY_POLICY, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("creationTime", FieldSchema.Type.DATE, FieldSchema.Handling.FACET, false));
        CMIndexFieldSchemaList.add(new FieldSchema("modificationTime", FieldSchema.Type.DATE, FieldSchema.Handling.FACET, false));
        CMIndexFieldSchemaList.add(new FieldSchema("owner", FieldSchema.Type.STRING, FieldSchema.Handling.FACET, false));
        CMIndexFieldSchemaList.add(new FieldSchema("tenantID", FieldSchema.Type.TENANT, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("ancestors", FieldSchema.Type.ANCESTORS, FieldSchema.Handling.SEARCH, true));
        CMIndexFieldSchemaList.add(new FieldSchema("content", FieldSchema.Type.CONTENT, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("hidden", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("disabled", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("credential", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("active", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("priority", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("requestedExecutionTime", FieldSchema.Type.DATE, FieldSchema.Handling.NONE, false));
        CMIndexFieldSchemaList.add(new FieldSchema("dispatcherID", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("status", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("user", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("history", FieldSchema.Type.STRING_ARRAY, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("snapShotEnabled", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("references", FieldSchema.Type.STRING_ARRAY, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("iconURI", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("defaultScreenTip", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("routingHints", FieldSchema.Type.STRING_ARRAY, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("tags", FieldSchema.Type.STRING_ARRAY, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("documentID", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("documentType", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
        CMIndexFieldSchemaList.add(new FieldSchema("version", FieldSchema.Type.STRING, FieldSchema.Handling.NONE, false));
        CMIndexFieldSchemaList.add(new FieldSchema("virtualParent", FieldSchema.Type.STRING, FieldSchema.Handling.SEARCH, false));
    }
}

