/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.rest.AsyncRESTResponseProcessor;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;

public class GetIndexSchemaResponseProcessor
extends AsyncRESTResponseProcessor {
    private static final TraceLogger logger = new TraceLogger();
    private String responseIndexUID = null;
    private String responseSchemaVersion = null;
    private boolean indexExists = true;
    private boolean success = false;

    public GetIndexSchemaResponseProcessor() {
        this.response = new AsyncRequestState(4);
    }

    @Override
    public void processStatusCodes(BusMethod method) {
        if (method.getStatusCode() != 200) {
            int waitTime = 30000;
            String msg = new StringBuffer().append("The request to ").append(method.getPath()).append(" failed: ").append(method.getStatusCode()).append(" - ").append(method.getStatusText()).append(". Will retry again in ").append(waitTime / 1000).append(" sec.").toString();
            CMIndications.Audit_Message(msg);
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.success = true;
        }
    }

    @Override
    public AsyncRequestState processResponse(InputStream responseStream) throws CMException {
        if (!this.success) {
            this.response.setRequestState(3);
            return this.response;
        }
        try {
            JSONObject json = JSONObject.parse((InputStream)responseStream);
            JSONObject index = (JSONObject)json.get((Object)"cm");
            if (index != null) {
                JSONObject schema = (JSONObject)index.get((Object)"schema");
                if (schema == null) {
                    return this.setInvalidResponse(json.toString());
                }
                this.responseIndexUID = (String)schema.get((Object)"instance");
                this.responseSchemaVersion = (String)schema.get((Object)"version");
                this.log("CM.GetIndexSchemaResponseProcessor: schema= " + index.toString());
            } else {
                this.indexExists = false;
                this.log("CM.GetIndexSchemaResponseProcessor: Index doesn't exist: " + json.toString());
            }
            this.response.setRequestState(1);
        }
        catch (IOException e) {
            this.setInvalidResponse(e.toString());
        }
        return this.response;
    }

    private AsyncRequestState setInvalidResponse(String message) {
        this.success = false;
        this.log("CM.GetIndexSchemaResponseProcessor: Invalid response: " + message);
        this.response.setRequestState(3);
        return this.response;
    }

    public boolean shouldDeleteIndex() {
        return this.indexExists || !this.success;
    }

    public boolean success() {
        return this.success;
    }

    private void log(String text) {
        logger.logInfo(text);
    }

    public String getSchemaVersion() {
        return this.responseSchemaVersion;
    }

    public String getIndexUID() {
        return this.responseIndexUID;
    }
}

