/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.cm.connectors.rest.search.BatchObjectsMethod;
import com.cognos.cm.connectors.rest.search.BusConnectionHandler;
import com.cognos.cm.connectors.rest.search.Connector;
import com.cognos.cm.connectors.rest.search.CreateCMIndexMethod;
import com.cognos.cm.connectors.rest.search.CreateObjectsMethod;
import com.cognos.cm.connectors.rest.search.DeleteCMIndexMethod;
import com.cognos.cm.connectors.rest.search.DeleteObjectsFilesMethod;
import com.cognos.cm.connectors.rest.search.DeleteObjectsMethod;
import com.cognos.cm.connectors.rest.search.GetIndexSchemaMethod;
import com.cognos.cm.connectors.rest.search.GetIndexSchemaResponseProcessor;
import com.cognos.cm.connectors.rest.search.IndexSynchronizationThread;
import com.cognos.cm.connectors.rest.search.SearchByCmidMethod;
import com.cognos.cm.connectors.rest.search.UpdateObjectsMethod;
import com.cognos.cm.connectors.rest.search.UpdatePermissionsMethod;
import com.cognos.cm.search.indexing.crawler.SearchResponseProcessor;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONObject;

public class IndexConnector
extends Connector {
    private IndexSynchronizationThread indexSyncThread;
    private static IndexConnector instance = null;

    public static synchronized IndexConnector getConnector() throws CMException {
        if (instance == null) {
            instance = new IndexConnector();
        }
        return instance;
    }

    protected static synchronized IndexConnector getConnector(BusConnectionHandler connectionHandler) {
        if (instance == null) {
            instance = new IndexConnector(connectionHandler);
        }
        return instance;
    }

    private IndexConnector() throws CMException {
    }

    private IndexConnector(BusConnectionHandler connectionHandler) {
        super(connectionHandler);
    }

    public synchronized void runIndexSynchronization() throws CMException {
        if (this.indexSyncThread == null) {
            this.indexSyncThread = new IndexSynchronizationThread();
            this.indexSyncThread.start();
        }
    }

    public static synchronized void terminate() {
        if (instance != null) {
            instance.terminateConnector();
            instance = null;
        }
    }

    public void createCMIndex(String unigueIndexId, String version) {
        CreateCMIndexMethod method = new CreateCMIndexMethod(unigueIndexId, version);
        this.executeSynchronously(method);
    }

    public void deleteCMIndex() {
        DeleteCMIndexMethod method = new DeleteCMIndexMethod();
        this.executeSynchronously(method);
    }

    public void getIndexSchema(GetIndexSchemaResponseProcessor responseProcessor) {
        GetIndexSchemaMethod method = new GetIndexSchemaMethod();
        this.executeSynchronously(method, responseProcessor);
    }

    public void searchDocumentsByCmid(int startId, int endId, SearchResponseProcessor responseProcessor) {
        SearchByCmidMethod method = new SearchByCmidMethod(startId, endId);
        this.executeSynchronously(method, responseProcessor);
    }

    @Override
    public void sendBatchRequest(JSONObject jsonPayload) {
        BatchObjectsMethod method = new BatchObjectsMethod();
        method.setBody(jsonPayload);
        this.executeSynchronously(method);
    }

    public void cmObjectsAdded(JSONObject jsonPayload) {
        CreateObjectsMethod method = new CreateObjectsMethod();
        method.setBody(jsonPayload);
        this.executeSynchronously(method);
    }

    public void cmObjectsUpdated(JSONObject jsonPayload) {
        UpdateObjectsMethod method = new UpdateObjectsMethod();
        method.setBody(jsonPayload);
        this.executeSynchronously(method);
    }

    public void cmPermissionsUpdated(JSONObject jsonPayload) {
        UpdatePermissionsMethod method = new UpdatePermissionsMethod();
        method.setBody(jsonPayload);
        this.executeSynchronously(method);
    }

    public void cmObjectsDeleted(JSONObject jsonPayload) {
        DeleteObjectsMethod method = new DeleteObjectsMethod();
        method.setBody(jsonPayload);
        this.executeSynchronously(method);
        DeleteObjectsFilesMethod method2 = new DeleteObjectsFilesMethod();
        method2.setBody(jsonPayload);
        this.executeSynchronously(method2);
    }
}

