/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.search;

import com.cognos.cm.backgroundTask.BackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.connectors.rest.search.GetIndexSchemaResponseProcessor;
import com.cognos.cm.connectors.rest.search.IndexConnector;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.NotificationManager;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.notification.SubscriptionManager;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.indexers.AddIndexer;
import com.cognos.cm.search.indexing.initialSync.IndexTree;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMUUID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class IndexSynchronizationThread
extends Thread {
    private IndexConnector connector;
    private AddIndexer indexer = new AddIndexer();
    public static final String INDEX_BACKGROUND_TASK = "indexTask";
    public static final String CRAWLER_TASK = "crawlerTask";
    private static final String CM_INDEX_UID = "CMIndexUID";
    private static final TraceLogger logger = new TraceLogger();

    public IndexSynchronizationThread() throws CMException {
        super("CM.IndexSynchronization");
        this.debug("CM.IndexSynchronization thread created.");
    }

    @Override
    public void run() {
        this.debug("CM.IndexSynchronization.run: ENTERED.");
        try {
            this.setThreadExecutionContext();
            this.synchronizeIndex();
            this.debug("CM.IndexSynchronization.run: SUCCESS.");
        }
        catch (Throwable th) {
            String stackTrace2 = CMIndications.getStacktraceText_Complete(th);
            CMIndications.Audit_Message("CM.IndexSynchronization.run: FAILED." + stackTrace2);
        }
        this.debug("CM.IndexSynchronization.run: EXITED.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeIndex() throws CMException, InterruptedException {
        long t1 = System.currentTimeMillis();
        try {
            this.connector = IndexConnector.getConnector();
            CMStore store = CMExecutionContext.get().getStore();
            ICMDbConnection con = ((ICMDbStore)store).getICMDbConnection();
            GetIndexSchemaResponseProcessor responseProcessor = new GetIndexSchemaResponseProcessor();
            while (!responseProcessor.success()) {
                this.connector.getIndexSchema(responseProcessor);
            }
            String cmIndexID = this.getIndexUID((CMDbConnection)con);
            boolean isNewCM = StringUtils.isEmpty((String)cmIndexID);
            if (this.shouldReIndex(cmIndexID, responseProcessor, (CMDbConnection)con)) {
                logger.logStartupAudit("cmIndexRecreation");
                this.enableIndexNotificationObserver(false);
                if (responseProcessor.shouldDeleteIndex()) {
                    this.connector.deleteCMIndex();
                    logger.logStartupAudit("cmIndexDeleted");
                }
                if (isNewCM) {
                    cmIndexID = new CMUUID().toStoreID();
                }
                this.connector.createCMIndex(cmIndexID, "1.20");
                logger.logStartupAudit("cmIndexCreated");
                this.indexObjects();
                if (isNewCM) {
                    this.updateIndexUID((CMDbConnection)con, cmIndexID);
                }
            } else {
                logger.logStartupAudit("cmIndexPerserved");
            }
            ((ICMDbStore)store).releaseICMDbConnection();
        }
        finally {
            this.startBackgroundTasks();
            long duration = System.currentTimeMillis() - t1;
            this.debug("CM.IndexSynchronization EXITED. Duration=" + duration + " (ms)");
        }
    }

    private String getIndexUID(CMDbConnection con) {
        String uid = null;
        try {
            uid = CMDbStoreSysProperties.getSysProp(con, CM_INDEX_UID);
            this.debug("CM.IndexSynchronization: CM uid, version = " + uid + ", " + "1.20");
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexUID(CMDbConnection con, String newUID) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, CM_INDEX_UID);
            CMDbStoreSysProperties.addSysProp(con, CM_INDEX_UID, newUID);
            con.commitTransaction();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        catch (CMException cmEx) {
            CMIndications.logException(cmEx);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception sqlEx) {}
            }
        }
    }

    private boolean shouldReIndex(String indexIDInCM, GetIndexSchemaResponseProcessor respProcessor, CMDbConnection con) {
        int indexQueueSize = this.getDbTableSize(con, "CMINDEXQUEUE");
        int objectsTableSize = this.getDbTableSize(con, "CMOBJECTS");
        String indexIDInSearch = respProcessor.getIndexUID();
        String schemaVersionInSearch = respProcessor.getSchemaVersion();
        if (StringUtils.isNotEmpty((String)indexIDInSearch) && StringUtils.isNotEmpty((String)schemaVersionInSearch)) {
            logger.logStartupAudit("cmIndexInfo", new CMException.Parm[]{new CMException.Parm("indexIDInCM", indexIDInCM), new CMException.Parm("indexIDInSearch", indexIDInSearch), new CMException.Parm("schemaVersionInCM", "1.20"), new CMException.Parm("schemaVersionInSearch", schemaVersionInSearch)});
        } else {
            logger.logStartupAudit("cmReIndexInfo", new CMException.Parm[]{new CMException.Parm("indexIDInCM", indexIDInCM), new CMException.Parm("schemaVersionInCM", "1.20")});
        }
        logger.logStartupAudit("cmIndexNotificationInfo", new CMException.Parm[]{new CMException.Parm("indexQueueName", "CMINDEXQUEUE"), new CMException.Parm("indexQueueSize", indexQueueSize), new CMException.Parm("objectsTableName", "CMOBJECTS"), new CMException.Parm("objectsTableSize", objectsTableSize)});
        if (indexIDInCM == null) {
            return true;
        }
        return !indexIDInCM.equals(respProcessor.getIndexUID()) || !"1.20".equals(respProcessor.getSchemaVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDbTableSize(CMDbConnection con, String tableName) {
        int count = -1;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select count(*) from " + tableName);
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this.debug(e.toString());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    this.debug(ex.toString());
                }
            }
        }
        return count;
    }

    private boolean doDebug() {
        return CMIndications.logEnabled("Trace.CM.INDEX", 10000);
    }

    private void debug(String text) {
        if (this.doDebug()) {
            CMIndications.CMTraceText("Trace.CM.INDEX", 10000, text);
        }
    }

    private void enableIndexNotificationObserver(boolean enable) {
        SubscriptionManager sm = SubscriptionManager.getInstance();
        Subscription s = sm.getSubscription("searchIndexing");
        String notificationImplementation = s.getNotificationImplementation();
        NotificationManager nm = NotificationManager.getInstance();
        NotificationObserver indexingObserver = nm.getObserver(notificationImplementation);
        indexingObserver.enable(enable);
    }

    private void indexObjects() throws CMException, InterruptedException {
        logger.logStartupAudit("cmIndexingObjects");
        long tStart = System.currentTimeMillis();
        IndexTree tree = this.indexer.buildIndexTree("/", AdvancedSettings.INDEX_MAXRETRIES);
        this.enableIndexNotificationObserver(true);
        this.startIndexingTask();
        int count = this.indexer.index(tree);
        long duration = (System.currentTimeMillis() - tStart) / 1000L;
        logger.logStartupAudit("cmIndexInitialSyncResults", new CMException.Parm[]{new CMException.Parm("objectsIndexed", count), new CMException.Parm("duration", duration)});
    }

    private void startBackgroundTasks() throws CMException {
        this.startIndexingTask();
        this.startCrawlerTask();
    }

    private void startIndexingTask() throws CMException {
        this.startBackgroundTask(INDEX_BACKGROUND_TASK, "cmBackgroundIndexTaskStarted");
    }

    private void startCrawlerTask() throws CMException {
        this.startBackgroundTask(CRAWLER_TASK, "cmCrawlerTaskStarted");
    }

    protected void startBackgroundTask(String taskName, String msgCode) throws CMException {
        IBackgroundTasksManager taskMgr = BackgroundTasksManager.getManager();
        if (!taskMgr.isTaskRunning(taskName)) {
            taskMgr.startTask(taskName, false);
            logger.logStartupAudit(msgCode);
        }
    }

    private void setThreadExecutionContext() {
        CMExecutionContext.setUp();
        CMExecutionContext ctx = CMExecutionContext.get();
        String serverLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        ctx.setPreference(CMPreference.CONTENTLOCALE, serverLocale);
        ctx.setPreference(CMPreference.PRODUCTLOCALE, serverLocale);
        ctx.setBIBUSheader(CMExecutionContext.getDefaultBIBUSheader(serverLocale, serverLocale, "IndexSynchronization_SESS", "IndexSynchronization_REQ"));
        ctx.setRequestContext("IndexSynchronization_REQ");
        ctx.setSessionContext("IndexSynchronization_SESS");
    }
}

