/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.connectors.rest.synchromesh;

import com.cognos.cm.backgroundTask.BackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.rest.search.Connector;
import com.cognos.cm.connectors.rest.synchromesh.SynchromeshBatchMethod;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONObject;

public class SynchromeshConnector
extends Connector {
    private static final TraceLogger LOG = new TraceLogger("Trace.CM.SYNCHROMESH");
    private static final String SYNCHROMESH_TASK = "synchromeshTask";
    private static SynchromeshConnector instance = null;

    private SynchromeshConnector() throws CMException {
    }

    public static synchronized SynchromeshConnector getConnector() throws CMException {
        if (instance == null) {
            instance = new SynchromeshConnector();
        }
        return instance;
    }

    public void startSynchromeshTask() throws CMException {
        IBackgroundTasksManager taskMgr = BackgroundTasksManager.getManager();
        if (!taskMgr.isTaskRunning(SYNCHROMESH_TASK)) {
            taskMgr.startTask(SYNCHROMESH_TASK, false);
            LOG.logStartupAudit("cmSynchromeshTaskStarted");
        }
    }

    public static synchronized void terminate() {
        if (instance != null) {
            instance.terminateConnector();
            instance = null;
        }
    }

    @Override
    public void sendBatchRequest(JSONObject jsonPayload) {
        SynchromeshBatchMethod method = new SynchromeshBatchMethod();
        ((BusMethod)method).setBody(jsonPayload);
        this.logRequest(jsonPayload);
        this.executeSynchronously(method);
    }

    private void logRequest(JSONObject payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending batch request: " + payload);
        }
    }
}

