/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.constants;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.properties.CMStringNameValuePair;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public final class PortalOptionEnum {
    private static HashMap allOptions_ = new HashMap();
    public static final PortalOptionEnum AUTOMATIC_PAGE_REFRESH = new PortalOptionEnum("automaticPageRefresh", "portalOptionInt", CMSOAPConstants.NS_XMLSCHEMA, "int", CMPreference.AUTOMATICPAGEREFRESH);
    public static final PortalOptionEnum LINES_PER_PAGE = new PortalOptionEnum("linesPerPage", "portalOptionInt", CMSOAPConstants.NS_XMLSCHEMA, "int", CMPreference.LINESPERPAGE);
    public static final PortalOptionEnum COLUMNS_PER_PAGE = new PortalOptionEnum("columnsPerPage", "portalOptionInt", CMSOAPConstants.NS_XMLSCHEMA, "int", CMPreference.COLUMNSPERPAGE);
    public static final PortalOptionEnum DISPLAY_MODE = new PortalOptionEnum("displayMode", "portalOptionDisplayMode", CMSOAPConstants.NS_BIBUS, "portalDisplayModeEnum", CMPreference.DISPLAYMODE);
    public static final PortalOptionEnum LIST_VIEW_SEPARATOR = new PortalOptionEnum("listViewSeparator", "portalOptionListSeparator", CMSOAPConstants.NS_BIBUS, "portalListSeparatorEnum", CMPreference.LISTVIEWSEPARATOR);
    public static final PortalOptionEnum SHOW_HINTS = new PortalOptionEnum("showHints", "portalOptionString", CMSOAPConstants.NS_BIBUS, "string", CMPreference.SHOWHINTS);
    public static final PortalOptionEnum SHOW_OPTION_SUMMARY = new PortalOptionEnum("showOptionSummary", "portalOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.SHOWOPTIONSUMMARY);
    public static final PortalOptionEnum SKIN = new PortalOptionEnum("skin", "portalOptionSearchPathSingleObject", CMSOAPConstants.NS_BIBUS, "searchPathSingleObject", CMPreference.SKIN);
    public static final PortalOptionEnum SHOW_WELCOME_PAGE = new PortalOptionEnum("showWelcomePage", "portalOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.SHOWWELCOMEPAGE);
    public static final PortalOptionEnum SHOW_HIDDEN_OBJECTS = new PortalOptionEnum("showHiddenObjects", "portalOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.SHOWHIDDENOBJECTS);
    public static final PortalOptionEnum ACCESSIBILITYFEATURE = new PortalOptionEnum("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures", "genericOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.ACCESSIBILITYFEATURE);
    public static final PortalOptionEnum BIDIRECTIONALFEATURESENABLED = new PortalOptionEnum("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled", "genericOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.BIDIRECTIONALFEATURESENABLED);
    public static final PortalOptionEnum BASETEXTDIRECTION = new PortalOptionEnum("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection", "genericOptionAnyURI", CMSOAPConstants.NS_XMLSCHEMA, "string", CMPreference.BASETEXTDIRECTION);
    public static final PortalOptionEnum BACKGROUNDSESSIONLOGGING = new PortalOptionEnum("backgroundSessionLogging", "genericOptionAnyURI", CMSOAPConstants.NS_XMLSCHEMA, "string", CMPreference.BACKGROUNDSESSIONLOGGING);
    public static final PortalOptionEnum IS_TOOLBAR_DOCKED = new PortalOptionEnum("isToolbarDocked", "genericOptionBoolean", CMSOAPConstants.NS_XMLSCHEMA, "boolean", CMPreference.IS_TOOLBAR_DOCKED);
    private final String name_;
    private final String type_;
    private final String valueType_;
    private final CMSOAPConstants.XMLNamespace valueNamespace_;
    private final CMPreference userPreference_;

    public static PortalOptionEnum find(String name, String type) {
        PortalOptionEnum option = (PortalOptionEnum)allOptions_.get(name);
        if (option != null && type != null && type.equals(option.type())) {
            return option;
        }
        return null;
    }

    private PortalOptionEnum(String name, String type, CMSOAPConstants.XMLNamespace valueNamespace, String valueType, CMPreference preference) {
        this.name_ = name;
        this.type_ = type;
        this.valueNamespace_ = valueNamespace;
        this.valueType_ = valueType;
        this.userPreference_ = preference;
        allOptions_.put(name, this);
    }

    public String name() {
        return this.name_;
    }

    public String type() {
        return this.type_;
    }

    public String valueType() {
        return this.valueType_;
    }

    public CMSOAPConstants.XMLNamespace valueNamespace() {
        return this.valueNamespace_;
    }

    public CMPreference getMappedUserPreference() {
        return this.userPreference_;
    }

    public static String extractUserPreferenceValueFromCMDbStoreStringNameValuePair(CMStringNameValuePair pair) {
        String value = pair.getValue();
        if (null == value) {
            return null;
        }
        String retValue = null;
        XMLElement xmlValueParent = null;
        try {
            xmlValueParent = CMXMLUtils.convertXMLString2XMLElement(value);
            if (xmlValueParent != null) {
                retValue = xmlValueParent.getChildValueWithName("value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }
}

