/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.List;
import java.util.Map;

public abstract class AbstractInternalConsistencyTask
extends Task {
    protected ICMLockManager lockManager;
    private boolean isInconsistent;
    private boolean performedInconsistencyCheck;
    private boolean reportOnConsistent;

    public AbstractInternalConsistencyTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        super(store, runOptions);
        this.lockManager = lockManager;
        this.reportOnConsistent = true;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void execute() throws CMException {
        CMDbConnection dbcon = null;
        try {
            dbcon = CMDbStoreFactory.getConnection();
            if (this.shouldCheckInternalInconsistency()) {
                this.performedInconsistencyCheck = true;
                List<CMException> details = this.checkForInternalInconsistencies(dbcon);
                if (!details.isEmpty()) {
                    this.setInconsistent(true);
                    this.reportErrors(details, "fatal");
                }
            }
            if (this.shouldRepairInternalInconsistencies()) {
                this.repairInternalInconsistencies(dbcon);
            }
            if (!this.isInconsistent() && this.reportOnConsistent) {
                CMException error = new CMException("cmConsistentCS");
                this.reportError(error, "info");
            }
        }
        catch (CMException e) {
            this.reportError(e, "fatal");
            throw e;
        }
        finally {
            if (dbcon != null) {
                CMDbStoreFactory.releaseConnection(dbcon);
            }
            this.lockManager.releaseLocks();
        }
    }

    protected abstract List<CMException> checkForInternalInconsistencies(CMDbConnection var1) throws CMConfigurationException, CMException;

    protected abstract void repairInternalInconsistencies(CMDbConnection var1) throws CMConfigurationException, CMException;

    protected boolean shouldRepairInternalInconsistencies() {
        return this.hasOption(ContentTaskOption.repairInternalInconsistencies) && this.isOptionOn(ContentTaskOption.repairInternalInconsistencies);
    }

    protected boolean shouldCheckInternalInconsistency() {
        return this.hasOption(ContentTaskOption.checkInternalInconsistencies) && this.isOptionOn(ContentTaskOption.checkInternalInconsistencies);
    }

    protected boolean isOptionOn(ContentTaskOption option) {
        boolean isOn = false;
        try {
            isOn = this.isBooleanOptionOn(option);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return isOn;
    }

    public ICMLockManager getLockManager() {
        return this.lockManager;
    }

    public boolean isInconsistent() {
        return this.isInconsistent;
    }

    public void setInconsistent(boolean isInconsistent) {
        this.isInconsistent = isInconsistent;
    }

    public boolean getHavePerformedInconsistencyCheck() {
        return this.performedInconsistencyCheck;
    }

    protected void setHavePerformedInconsistencyCheck(boolean performed) {
        this.performedInconsistencyCheck = performed;
    }

    public boolean isReportOnConsistent() {
        return this.reportOnConsistent;
    }

    public void setReportOnConsistent(boolean reportOnConsistent) {
        this.reportOnConsistent = reportOnConsistent;
    }
}

