/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.contentTasks.RunnableErrorsReporter;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.util.CMDateUtils;
import java.util.ArrayList;

public class CMRunnableErrorsReporter
extends RunnableErrorsReporter {
    private CMStore store_;
    private CMStorePath spRunHistoryStorePath_;
    private ICMLockManager lockMgr_;
    private static int count_ = 0;

    public CMRunnableErrorsReporter(CMStore store, ICMLockManager lockManager, CMStorePath spRunHistoryStorePath) {
        this.store_ = store;
        this.lockMgr_ = lockManager;
        this.spRunHistoryStorePath_ = spRunHistoryStorePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHistoryDetail(String detail, String severity) throws CMException {
        ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        if (detail != null) {
            propNames.add(CMProperty.DETAIL);
            propValues.add(detail);
        }
        String now = CMDateUtils.getIsoDate();
        propNames.add(CMProperty.DETAILTIME);
        propValues.add(now);
        if (severity != null && severity.length() > 0) {
            propNames.add(CMProperty.SEVERITY);
            propValues.add(severity);
        }
        now = now + "." + new Integer(count_).toString();
        ++count_;
        CMDbStoreString objectName = new CMDbStoreString(now);
        this.lockMgr_.releaseLocks();
        this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
        this.spRunHistoryStorePath_.setLockManagerUsageFlag(11);
        this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
        try {
            boolean closeTransaction = false;
            if (!this.store_.inTransaction()) {
                this.store_.beginTransaction();
                closeTransaction = true;
            }
            CMStoreQueryResults addResult = null;
            try {
                addResult = this.store_.addObject(this.spRunHistoryStorePath_, (CMBasePropertyValue)objectName, CMObjectClass.HISTORYDETAIL, propNames, propValues);
                if (closeTransaction) {
                    this.store_.commitTransaction();
                }
            }
            finally {
                if (addResult != null) {
                    addResult.release();
                }
                if (closeTransaction && this.store_.inTransaction()) {
                    try {
                        this.store_.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            this.lockMgr_.releaseLocks();
            this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
        }
    }

    @Override
    public boolean isComplete() throws CMException {
        return true;
    }
}

