/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.CAM.AAAException;
import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.NamespaceManager;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ConsistencyCheckTask
extends Task {
    private CMProperty[] PROPERTIES_SECURITYREF = new CMProperty[]{CMProperty.CREATIONTIME, CMProperty.SEARCHPATH, CMProperty.OBJECTCLASS, CMProperty._FIRSTLOGONNAME};
    private static final int ACTION_NONE = 0;
    private static final int ACTION_CHECK = 1;
    private static final int ACTION_FIX = 2;
    private int actionForSec_ = 0;
    private static final String OBJ_QUERY_SUFFIX = "//*[@objectClass='account' or @objectClass='role' or @objectClass='group']";
    private ArrayList<String> effectiveNSsToCheck_ = null;
    private ArrayList<String> namespaceIdsToCheck_ = null;
    private ICMLockManager lockMgr;

    public ConsistencyCheckTask(CMStore store, Map<String, Object> runOptions) {
        super(store, runOptions);
        this.lockMgr = store.getLockManager();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void execute() throws CMException {
        try {
            this.executeConsistencyCheck();
        }
        catch (CMException e) {
            this.reportError(e, "error");
            this.setSucceeded(false);
        }
        finally {
            this.lockMgr.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeConsistencyCheck() throws CMException {
        this.setEffectiveAction();
        if (this.actionForSec_ == 0) {
            return;
        }
        this.setEffectiveNSToPerform();
        if (this.effectiveNSsToCheck_ == null) {
            throw new CMException("cmNotAuthenticatedAll");
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        for (String sNSSearchPath : this.effectiveNSsToCheck_) {
            String nsId = CMCAMIDHelper.CAMIDFromSearchPath(sNSSearchPath);
            for (String objPath : this.collectInvalidCAMIDs(sNSSearchPath)) {
                String objectId = CMCAMIDHelper.CAMIDFromSearchPath(objPath);
                ResultObjProps objProp = this.getSecurityRefDetail(nsId, objectId);
                if (this.actionForSec_ == 1) {
                    this.addConsistencyCheckResultToHistoryDetail(objProp, "cmProxyObjObsolete", null, "info");
                    continue;
                }
                if (this.actionForSec_ != 2) continue;
                String sPath = "/directory/namespace[@id=" + CMStoreXPath.attributeQuoteString(nsId) + "]//*[@id=" + CMStoreXPath.attributeQuoteString(objectId) + "]";
                String oldIpfCategory = ctx.getIPFCategory();
                try {
                    ctx.setIPFCategory("Audit.RTUsage.CM");
                    CMStoreXPath path = new CMStoreXPath(sPath, 15);
                    this.lockMgr.requestLocks(path);
                    delete.setClassName();
                    delete.deleteObjects(path, true, false, null, true);
                    CMIndications.Audit_Access("DELETE", "ACCOUNT", objPath);
                    this.addConsistencyCheckResultToHistoryDetail(objProp, "cmProxyObjDeleted", null, "info");
                }
                catch (CMException e) {
                    this.addConsistencyCheckResultToHistoryDetail(objProp, "cmProxyObjNotDeleted", e, "warn");
                }
                finally {
                    this.lockMgr.releaseLocks();
                    ctx.setIPFCategory(oldIpfCategory);
                }
            }
        }
        if (AdvancedSettings.CLEANOBSOLETENAMESPACES && this.actionForSec_ == 2) {
            this.cleanNamespaces();
        }
    }

    private ArrayList<String> collectInvalidCAMIDs(String sNSSearchPath) throws CMException {
        ArrayList<String> CAMIDList_OBSOLETE = new ArrayList<String>();
        for (String camid : this.getCAMIDListFromCM(sNSSearchPath)) {
            try {
                if (null != AccMan.normalizeExternalSearch(camid)) continue;
                CAMIDList_OBSOLETE.add(camid);
            }
            catch (Exception ae) {
                CMException ex = new CMException(ae, "cmErrSearchInExternalNamespace", new CMException.Parm("PATH", camid));
                this.reportError(ex, "error");
            }
        }
        return CAMIDList_OBSOLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getStoreIDs() throws CMException {
        CMStoreQueryResults queryResults = null;
        try {
            CMProperty[] prop = new CMProperty[]{CMProperty.STOREID};
            ArrayList<String> storeIDArray = new ArrayList<String>();
            CMStoreXPath hasPolPath = new CMStoreXPath("//*[hasProperty(\"policies\")]");
            this.lockMgr.requestLocks(hasPolPath);
            queryResults = this.getStore().executeQuery(hasPolPath, prop, null, 0, 512, null, -1, -1);
            while (queryResults.next()) {
                storeIDArray.add(queryResults.getValue(0).toString());
            }
            ArrayList<String> arrayList = storeIDArray;
            return arrayList;
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            this.lockMgr.releaseLocks();
        }
    }

    private byte[] getRepairedPolicies(Object value) throws CMException {
        if (value == null) {
            return null;
        }
        boolean updateRequired = false;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        XMLElement policiesVal = null;
        try {
            String propValueXML = CMServlet.AAA.DescribePolicy(null, (byte[])value, "<properties xmlns=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item></properties>", CMExecutionContext.get().getCAMAdditionalInfo());
            XMLElement root = CMXMLUtils.convertXMLString2XMLElement(propValueXML);
            policiesVal = root.getChild("policies", "value");
            if (policiesVal != null && policiesVal.children_ != null) {
                Iterator<XMLElement> it = policiesVal.children_.iterator();
                while (it.hasNext()) {
                    CMStoreXPath path;
                    XMLElement item = it.next();
                    XMLElement elPath = item.getChild("securityObject", "searchPath", "value");
                    if (elPath == null || !RequestHandler.isThirdPartyReference(path = new CMStoreXPath(elPath.value_)) || RequestHandler.isNamespaceValid(map, path, this.getStore())) continue;
                    it.remove();
                    updateRequired = true;
                }
            }
        }
        catch (AAAException ex) {
            throw new CMException((Exception)((Object)ex), "cmNoReadPolicy");
        }
        catch (CMException cme1) {
            return null;
        }
        return updateRequired ? this.getPoliciesBytes(policiesVal) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanNamespaces() throws CMException {
        ArrayList<CMProperty> updateProps = new ArrayList<CMProperty>();
        updateProps.add(CMProperty.POLICIES);
        ArrayList<Object> updateValues = new ArrayList<Object>();
        updateValues.add(null);
        CMProperty[] qprops = new CMProperty[]{CMProperty.POLICIES};
        for (String storeID : this.getStoreIDs()) {
            CMStoreQueryResults qresults = null;
            CMStoreXPath targetPath = new CMStoreXPath("storeID(\"" + storeID + "\")", 13);
            try {
                Object propValue;
                byte[] newPolicies;
                this.lockMgr.requestLocks(targetPath);
                this.getStore().beginTransaction();
                qresults = this.getStore().executeQuery(targetPath, qprops, null, 0, 33280, null, -1, -1);
                if (qresults.next() && (newPolicies = this.getRepairedPolicies(propValue = qresults.getValue(0))) != null) {
                    updateValues.set(0, newPolicies);
                    this.getStore().update(qresults, updateProps, updateValues);
                }
                this.getStore().commitTransaction();
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
                try {
                    this.getStore().rollbackOpenTransaction();
                }
                catch (Exception exception) {}
                this.lockMgr.releaseLocks();
            }
        }
    }

    private byte[] getPoliciesBytes(XMLElement newPolicies) {
        CMExecutionContext context = CMExecutionContext.get();
        AznUtil azn = new AznUtil(CMServlet.AAA, context.getAccManPassportID(), context.getCAMAdditionalInfo());
        byte[] buff = null;
        StringBuffer policyBuf = new StringBuffer("<");
        policyBuf.append(CMProperty.POLICIES.getName()).append(" ").append("xsi").append(":").append("type").append("=\"").append("cm").append(":").append(CMProperty.POLICIES.getType().getName()).append("\"").append(XMLElement.getCMPrefixes()).append(" >").append(newPolicies.makeXML(null, true, false)).append("</").append(CMProperty.POLICIES.getName()).append(">");
        try {
            buff = azn.createPolicy(CMProperty.POLICIES.getName(), policyBuf.toString());
        }
        catch (AAAException aAAException) {
            // empty catch block
        }
        return buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultObjProps getSecurityRefDetail(String sNamespaceId, String sObjId) throws CMException {
        String sSearchPath = "/directory/namespace[@id=" + CMStoreXPath.attributeQuoteString(sNamespaceId) + "]//*[@id=" + CMStoreXPath.attributeQuoteString(sObjId) + "]";
        CMStoreXPath objectContext = null;
        objectContext = new CMStoreXPath(sSearchPath);
        CMStoreQueryResults results = null;
        try {
            ResultObjProps objProp;
            this.lockMgr.requestLocks(objectContext);
            results = this.getStore().executeQuery(objectContext, this.PROPERTIES_SECURITYREF, null, 0, 0, null);
            if (!results.next()) {
                ResultObjProps resultObjProps = null;
                return resultObjProps;
            }
            String sDefaultName = null;
            String sObjectType = null;
            String sPath = null;
            String sFirstLogonName = null;
            String sNSName = this.getNSNameFromNSId(sNamespaceId);
            if (results.getValue(0) != null) {
                sDefaultName = results.getValue(0).toString();
            }
            if (results.getValue(1) != null) {
                sPath = results.getValue(1).toString();
            }
            if (results.getValue(2) != null) {
                sObjectType = results.getValue(2).toString();
            }
            if (results.getValue(3) != null) {
                sFirstLogonName = results.getValue(3).toString();
            }
            ResultObjProps resultObjProps = objProp = new ResultObjProps(sDefaultName, sObjectType, sPath, sNSName, sFirstLogonName);
            return resultObjProps;
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getCAMIDListFromCM(String sNamespaceSearchPath) throws CMException {
        String sNamespaceIdToCheck = CMCAMIDHelper.CAMIDFromSearchPath(sNamespaceSearchPath);
        String searchPath = "/directory/namespace[@id=" + CMStoreXPath.attributeQuoteString(sNamespaceIdToCheck) + "]" + OBJ_QUERY_SUFFIX;
        CMStoreXPath objectContext = null;
        ArrayList<String> CAMIDList_CM = new ArrayList<String>();
        try {
            objectContext = new CMStoreXPath(searchPath);
        }
        catch (CMStoreParseException e) {
            this.reportWarningOnNamespace(sNamespaceIdToCheck);
            return CAMIDList_CM;
        }
        CMStoreQueryResults results = null;
        int qPermissions = 0;
        CMProperty[] queryProps = new CMProperty[]{CMProperty.SEARCHPATH};
        try {
            this.lockMgr.requestLocks(objectContext);
            results = this.getStore().executeQuery(objectContext, queryProps, null, 0, qPermissions, null);
            while (results.next()) {
                String path = results.getValue(0).toString();
                if (path == null) continue;
                CAMIDList_CM.add(path);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr.releaseLocks();
        }
        return CAMIDList_CM;
    }

    private ArrayList<String> getValidNamespaceSearchPaths() throws CMException {
        ArrayList<String> validNamespaces = new ArrayList<String>();
        CMExecutionContext currContext = CMExecutionContext.get();
        for (CMObjectReference ref : currContext.getCurrentUserIdentity()) {
            String searchPath;
            if (ref.getObjectClass() != CMObjectClass.NAMESPACE || CMCAMIDHelper.isCognosNamespace(searchPath = ref.getSearchPath())) continue;
            validNamespaces.add(searchPath);
        }
        return validNamespaces.isEmpty() ? null : validNamespaces;
    }

    private void getNamespacesToCheck() throws CMException {
        ArrayList<String> validNamespaces = this.getValidNamespaceSearchPaths();
        if (validNamespaces == null) {
            return;
        }
        if (this.namespaceIdsToCheck_ == null || this.namespaceIdsToCheck_.isEmpty()) {
            this.effectiveNSsToCheck_ = validNamespaces;
            for (String sNSId : this.collectUnAuthenticatedNSes(validNamespaces)) {
                this.reportWarningOnNamespace(sNSId);
            }
        } else {
            this.effectiveNSsToCheck_ = new ArrayList();
            for (String namespaceToCheck : this.namespaceIdsToCheck_) {
                if (namespaceToCheck == null) continue;
                if (validNamespaces.contains(namespaceToCheck)) {
                    this.effectiveNSsToCheck_.add(namespaceToCheck);
                    continue;
                }
                String sNamespaceId = CMCAMIDHelper.CAMIDFromSearchPath(namespaceToCheck);
                this.reportWarningOnNamespace(sNamespaceId);
            }
        }
    }

    private void setNamespaces(String sContext) throws CMException {
        XMLElement valueXml;
        XMLElement root = CMXMLUtils.convertXMLString2XMLElement(sContext);
        if (root != null && (valueXml = root.getOptionalChildWithName("value")) != null && valueXml.getChildren() != null) {
            for (XMLElement xmlEl : valueXml.getChildren()) {
                String sValue;
                if (xmlEl == null || xmlEl.value_ == null || (sValue = xmlEl.value_).length() == 0) continue;
                if (this.namespaceIdsToCheck_ == null) {
                    this.namespaceIdsToCheck_ = new ArrayList();
                }
                CMStoreXPath path = (CMStoreXPath)CMStoreXPath.parse(sValue);
                String nsPath = CMCAMIDHelper.normalizeSecurityReference(this.getStore(), path, false, false, false, true).toString();
                this.namespaceIdsToCheck_.add(nsPath);
            }
        }
    }

    private void setEffectiveAction() throws CMException {
        CMException cmEx;
        if (this.hasOption(ContentTaskOption.repairSecurityReferences)) {
            try {
                if (this.isBooleanOptionOn(ContentTaskOption.repairSecurityReferences)) {
                    this.actionForSec_ = 2;
                }
            }
            catch (CMException e) {
                cmEx = new CMException(e, "cmNoRepair");
                this.reportError(cmEx, "error");
            }
        }
        if (this.actionForSec_ != 2 && this.hasOption(ContentTaskOption.checkSecurityReferences)) {
            try {
                if (this.isBooleanOptionOn(ContentTaskOption.checkSecurityReferences)) {
                    this.actionForSec_ = 1;
                }
            }
            catch (CMException e) {
                cmEx = new CMException(e, "cmNoCheck");
                this.reportError(cmEx, "error");
            }
        }
    }

    private void setEffectiveNSToPerform() throws CMException {
        Object sSecurityRefCtx = this.getRunOptionValue(ContentTaskOption.securityReferencesContext);
        if (sSecurityRefCtx != null) {
            this.setNamespaces(sSecurityRefCtx.toString());
        }
        this.getNamespacesToCheck();
    }

    private ArrayList<String> collectUnAuthenticatedNSes(ArrayList<String> allAuthenticatedNSes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String sNSId : this.getNamespaceManager().listNamespaces()) {
            if (!CMCAMIDHelper.CAMIDIsExternal(sNSId)) continue;
            String sCAMIDInSingleQuote = "CAMID('" + sNSId + "')";
            String sCAMIDInDoubleQuote = "CAMID(\"" + sNSId + "\")";
            if (allAuthenticatedNSes.contains(sCAMIDInSingleQuote) || allAuthenticatedNSes.contains(sCAMIDInDoubleQuote)) continue;
            list.add(sNSId);
        }
        return list;
    }

    private boolean doesNamespaceExist(String namespace) {
        return this.getNamespaceManager().isActiveNamespace(namespace);
    }

    private void reportWarningOnNamespace(String sNamespaceId) throws CMException {
        String errCode;
        CMException.Parm[] parms;
        String sNamespaceName = this.getNSNameFromNSId(sNamespaceId);
        if (this.doesNamespaceExist(sNamespaceId)) {
            parms = new CMException.Parm[]{new CMException.Parm("NAME", sNamespaceId)};
            errCode = "cmNamespaceNonExistent";
        } else {
            parms = new CMException.Parm[]{new CMException.Parm("ID", sNamespaceId), new CMException.Parm("Name", sNamespaceName)};
            errCode = "cmNotAuthenticatedToTheNamespace";
        }
        this.reportError(errCode, "error", parms);
        this.setSucceeded(false);
    }

    private String getNSNameFromNSId(String sNamespaceId) {
        CMCAMNamespace ns = this.getNamespaceManager().getNamespace(sNamespaceId);
        return ns != null && ns.isActive() ? ns.getName() : "";
    }

    private NamespaceManager getNamespaceManager() {
        return CMServlet.namespaceManager;
    }

    private void addConsistencyCheckResultToHistoryDetail(ResultObjProps props, String sErrorCode, Exception ex, String sSeverity) throws CMException {
        if (props == null) {
            return;
        }
        this.reportError(props.getExceptionForMessage(sErrorCode, ex), sSeverity);
    }

    private class ResultObjProps {
        private String objName_ = null;
        private String objType_ = null;
        private String objPath_ = null;
        private String nsName_ = null;
        private String firstLogonName_ = null;
        private Locale contentLocale = CMExecutionContext.get().getRequestLocale("contentLocale").toLocale();

        public ResultObjProps(String objectName, String objectType, String searchPath, String namespaceName, String firstLogonName) {
            this.objName_ = objectName;
            this.objType_ = objectType;
            this.objPath_ = searchPath;
            this.nsName_ = namespaceName;
            this.firstLogonName_ = firstLogonName == null ? CMError.getMessage("cmProxyUnknownName", null, this.contentLocale) : firstLogonName;
        }

        public CMException getExceptionForMessage(String sErrorCode, Exception ex) {
            CMException.Parm[] params = new CMException.Parm[]{new CMException.Parm("NAME", this.firstLogonName_), new CMException.Parm("TIME", this.objName_), new CMException.Parm("TYPE", this.objType_), new CMException.Parm("PATH", this.objPath_), new CMException.Parm("NAME", this.nsName_)};
            return ex == null ? new CMException(sErrorCode, params) : new CMException(ex, sErrorCode, params);
        }
    }
}

