/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.plugin.Interface.CMPlugin;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.CMDataUpgradeManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPluginManager;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DataUpgradeTask
extends Task {
    private ArrayList<String> classesToUpgrade_ = null;
    private ArrayList<String> effectiveClassesToUpgrade_ = new ArrayList();
    private int countUpgraded_;
    private int countUpToDate_;
    private int countTotal_;
    private static final String SPEC_REF_PROP = "metadataModelPackage";
    protected ICMLockManager lockManager;

    public DataUpgradeTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        super(store, runOptions);
        this.lockManager = lockManager;
    }

    @Override
    public Task.Lock getLock() {
        return new Task.LockNoOp();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void execute() throws CMException {
        this.classesToUpgrade_ = this.getUpgradeClasses();
        if (this.classesToUpgrade_ == null || this.classesToUpgrade_.isEmpty()) {
            return;
        }
        Map<String, CMPluginDescriptor> descMap = this.getDescriptorsForClassesToUpgrade();
        if (descMap == null) {
            CMException ex = new CMException("cmMissingPluginInfo");
            this.reportError(ex, "error");
            return;
        }
        for (int i = 0; i < this.effectiveClassesToUpgrade_.size(); ++i) {
            this.countUpgraded_ = 0;
            this.countUpToDate_ = 0;
            this.countTotal_ = 0;
            String sClass = this.effectiveClassesToUpgrade_.get(i);
            HashSet<String> storeIds = this.getStoreIdsForUpgrade(sClass);
            if (storeIds.isEmpty()) {
                this.addSummaryReport(sClass);
                continue;
            }
            this.countTotal_ = storeIds.size();
            this.upgrade(storeIds, sClass, descMap.get(sClass));
            this.addSummaryReport(sClass);
        }
    }

    private Map<String, CMPluginDescriptor> getDescriptorsForClassesToUpgrade() throws CMException {
        HashMap<String, CMPluginDescriptor> descMap = null;
        Map<String, CMPluginDescriptor> allDescMap = this.getDescriptorsForAllSupportedClasses();
        if (allDescMap == null) {
            return null;
        }
        descMap = new HashMap<String, CMPluginDescriptor>();
        for (int i = 0; i < this.classesToUpgrade_.size(); ++i) {
            String sClass = this.classesToUpgrade_.get(i);
            if (allDescMap.containsKey(sClass)) {
                descMap.put(sClass, allDescMap.get(sClass));
                this.effectiveClassesToUpgrade_.add(sClass);
                continue;
            }
            CMException cmEx = new CMException("cmMissingPluginInfo");
            this.reportError(cmEx, "error");
        }
        return descMap;
    }

    private Map<String, CMPluginDescriptor> getDescriptorsForAllSupportedClasses() {
        HashMap<String, CMPluginDescriptor> descMap = null;
        CMPluginManager pluginMgr = CMPluginManager.getInstance();
        if (!pluginMgr.hasPlugins()) {
            return null;
        }
        descMap = new HashMap<String, CMPluginDescriptor>();
        List<CMPluginDescriptor> descs = pluginMgr.getPluginDescriptors();
        ListIterator<CMPluginDescriptor> descIt = descs.listIterator();
        while (descIt.hasNext()) {
            List sClassName;
            CMPluginDescriptor desc = (CMPluginDescriptor)descIt.next();
            if (desc == null || !desc.forContentTask() || (sClassName = desc.getClassNamesForDeployment()) == null) continue;
            ListIterator sClsIt = sClassName.listIterator();
            while (sClsIt.hasNext()) {
                CMPluginDescriptor oldDesc;
                String sClsName = (String)sClsIt.next();
                if (sClsName == null) continue;
                if (descMap.containsKey(sClsName) && Float.parseFloat((oldDesc = (CMPluginDescriptor)descMap.get(sClsName)).getVersion()) > Float.parseFloat(desc.getVersion())) {
                    desc = oldDesc;
                }
                descMap.put(sClsName, desc);
            }
        }
        return descMap;
    }

    private ArrayList<String> getUpgradeClasses() throws CMException {
        ArrayList<String> sClasses = null;
        String sClassesInOption = this.getRunOptionValue(ContentTaskOption.upgradeClasses).toString();
        sClasses = CMXMLUtils.convertXMLElementArray2StringArray(sClassesInOption);
        return sClasses;
    }

    private HashSet<String> getStoreIdsForUpgrade(String sObjClassName) throws CMException {
        ArrayList<String> upgradeContext;
        HashSet<String> storeIds = new HashSet<String>();
        Object contextInOption = this.getRunOptionValue(ContentTaskOption.upgradeClassesContext);
        Object refContextInOption = this.getRunOptionValue(ContentTaskOption.upgradeClassesReferenceContext);
        if (!(contextInOption != null && contextInOption.toString().length() != 0 || refContextInOption != null && refContextInOption.toString().length() != 0)) {
            String sSearchPath = "//" + sObjClassName;
            try {
                CMStoreXPath storePath = new CMStoreXPath(sSearchPath);
                this.addStoreIDs(storeIds, storePath);
            }
            catch (CMStoreParseException storePath) {
            }
            catch (Throwable e) {
                this.addHistoryDetail(e.getLocalizedMessage(), "error");
            }
            return storeIds;
        }
        if (contextInOption != null) {
            try {
                upgradeContext = CMXMLUtils.convertXMLElementArray2StringArray((String)contextInOption);
                if (upgradeContext != null && !upgradeContext.isEmpty()) {
                    for (int i = 0; i < upgradeContext.size(); ++i) {
                        String path = upgradeContext.get(i).toString();
                        try {
                            path = this.buildSearchPathForContext(path, sObjClassName);
                            CMStoreXPath storePath = new CMStoreXPath(path);
                            this.addStoreIDs(storeIds, storePath);
                            continue;
                        }
                        catch (CMStoreParseException e) {
                            this.reportError(e, "error");
                        }
                    }
                }
            }
            catch (CMException e) {
                this.reportError(e, "error");
            }
        }
        if (refContextInOption != null) {
            try {
                upgradeContext = CMXMLUtils.convertXMLElementArray2StringArray((String)refContextInOption);
                if (upgradeContext != null && !upgradeContext.isEmpty() && (sObjClassName.equals(CMObjectClass.REPORT.getName()) || sObjClassName.equals(CMObjectClass.QUERY.getName()) || sObjClassName.equals("interactiveReport"))) {
                    String path = this.buildSearchPathForRefContext(sObjClassName, SPEC_REF_PROP, upgradeContext);
                    try {
                        CMStoreXPath storePath = new CMStoreXPath(path);
                        this.addStoreIDs(storeIds, storePath);
                    }
                    catch (CMStoreParseException e) {
                        CMException ex = new CMException((Exception)e, "cmFailedQueryForUpgrade", new CMException.Parm("PATH", path));
                        this.reportError(ex, "error");
                    }
                }
            }
            catch (CMException e) {
                this.reportError(e, "error");
            }
        }
        return storeIds;
    }

    private String buildSearchPathForContext(String sPath, String sObjectClass) {
        String sRet = null;
        sRet = sPath + "//*[@objectClass='" + sObjectClass + "']";
        return sRet;
    }

    private String buildSearchPathForRefContext(String sObjectClass, String refProp, ArrayList<String> refContext) {
        String sRet = null;
        StringBuffer buf = new StringBuffer("//");
        buf.append(sObjectClass);
        buf.append("[containsReferences(@");
        buf.append(refProp);
        for (int i = 0; i < refContext.size(); ++i) {
            String sPackagePath = refContext.get(i);
            if (sPackagePath == null) continue;
            buf.append(", ");
            buf.append(sPackagePath);
        }
        buf.append(")]");
        sRet = buf.toString();
        return sRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoreIDs(HashSet<String> storeIds, CMStorePath storePath) throws CMException {
        storePath.setLockManagerUsageFlag(10);
        this.lockManager.requestLocks(storePath);
        CMStoreQueryResults results = null;
        boolean isSysAdmin = CMExecutionContext.get().getCurrentUserIsAdministrator();
        int qPermissions = 0;
        qPermissions = isSysAdmin ? 512 : (qPermissions |= 3);
        CMStore store = CMExecutionContext.get().getStore();
        try {
            results = store.executeQuery(storePath, null, null, 0, qPermissions, null);
            if (results != null) {
                while (results.next()) {
                    int objId = results.getObjectID();
                    String storeId = store.getObjectStoreID(objId);
                    if (storeId == null) continue;
                    storeIds.add(storeId);
                }
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockManager.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade(HashSet<String> storeIds, String sClass, CMPluginDescriptor pluginDescriptor) throws CMException {
        if (pluginDescriptor == null) {
            return;
        }
        List properties = pluginDescriptor.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        CMStore store = CMExecutionContext.get().getStore();
        CMPropertySet propSet = store.getPropertySets().getPropertySet();
        ArrayList<CMProperty> propList = new ArrayList<CMProperty>();
        CMObjectClasses objClasses = store.getObjectClasses();
        CMObjectClass objCls = objClasses.getClassByName(sClass);
        ListIterator propIt = properties.listIterator();
        while (propIt.hasNext()) {
            CMProperty prop;
            String propName = (String)propIt.next();
            if (propName == null || propName.length() <= 0 || (prop = propSet.getProperty(propName, objCls)) == null) continue;
            propList.add(prop);
        }
        if (propList.size() <= 0) {
            return;
        }
        CMProperty[] props = new CMProperty[propList.size()];
        propList.toArray(props);
        for (String storeId : storeIds) {
            String searchPath;
            CMUpgradeResult upgradeResult;
            CMStoreQueryResults oneObjRes;
            int qPermissions;
            CMStoreXPath storePath;
            block32: {
                block33: {
                    storePath = null;
                    storePath = CMStoreXPath.fromStoreID(storeId);
                    storePath.setLockManagerUsageFlag(13);
                    this.lockManager.requestLocks(storePath);
                    boolean isSysAdmin = CMExecutionContext.get().getCurrentUserIsAdministrator();
                    qPermissions = 0;
                    qPermissions = isSysAdmin ? 512 : (qPermissions |= 3);
                    oneObjRes = null;
                    oneObjRes = store.executeQuery(storePath, props, null, 0, qPermissions, null);
                    if (oneObjRes == null || !oneObjRes.next()) continue;
                    boolean bReportPlugin = false;
                    boolean bQueryPlugin = false;
                    boolean bSetReportUpgradeFlag = false;
                    if (sClass.equalsIgnoreCase(CMObjectClass.REPORT.getName()) || "interactiveReport".equals(sClass)) {
                        bReportPlugin = true;
                        bSetReportUpgradeFlag = true;
                    } else if (sClass.equalsIgnoreCase(CMObjectClass.QUERY.getName())) {
                        bQueryPlugin = true;
                        bSetReportUpgradeFlag = true;
                    }
                    CMUpgradeData data = CMDataUpgradeManager.getDataFromCMResult(oneObjRes, props, bReportPlugin, bQueryPlugin, bSetReportUpgradeFlag, false);
                    CMPluginManager pluginMgr = CMPluginManager.getInstance();
                    CMPlugin plugin = pluginMgr.getPlugin(pluginDescriptor.getPluginID());
                    upgradeResult = null;
                    if (plugin instanceof CMUpgradePlugin) {
                        try {
                            upgradeResult = ((CMUpgradePlugin)plugin).upgrade(data);
                            break block32;
                        }
                        catch (Throwable ex) {
                            searchPath = oneObjRes.getSearchPath();
                            oneObjRes.release();
                            oneObjRes = null;
                            CMException e = new CMException(ex, "cmPluginFailUpgrade", new CMException.Parm("Name", pluginDescriptor.getPluginName()), new CMException.Parm("Path", searchPath));
                            this.reportError(e, "error");
                            if (oneObjRes != null) {
                                oneObjRes.release();
                                oneObjRes = null;
                            }
                            if (store.inTransaction()) {
                                store.rollbackTransaction();
                            }
                            this.lockManager.releaseLocks();
                            continue;
                        }
                    }
                    if (oneObjRes != null) {
                        oneObjRes.release();
                        oneObjRes = null;
                    }
                    if (!store.inTransaction()) break block33;
                    store.rollbackTransaction();
                }
                this.lockManager.releaseLocks();
                return;
            }
            try {
                if (upgradeResult == null) {
                    ++this.countUpToDate_;
                    continue;
                }
                int status = upgradeResult.getUpgradeStatus();
                if (status == 1) {
                    oneObjRes.release();
                    oneObjRes = null;
                    store.beginTransaction();
                    oneObjRes = store.executeQuery(storePath, props, null, 0, qPermissions, null);
                    oneObjRes.next();
                    CMDataUpgradeManager.upgradeDataInCM(oneObjRes, props, upgradeResult, store);
                    ++this.countUpgraded_;
                    store.commitTransaction();
                } else if (status == 0) {
                    ++this.countUpToDate_;
                    continue;
                }
                searchPath = oneObjRes.getSearchPath();
                oneObjRes.release();
                oneObjRes = null;
                List msgs = upgradeResult.getMessages();
                if (msgs != null) {
                    for (CMUpgradeMessage msgObj : msgs) {
                        int severity;
                        CMException ex1 = new CMException("cmPluginMessage", new CMException.Parm("Path", searchPath), new CMException.Parm("Message", msgObj.getMessage()));
                        ex1.ErrorLevel = severity = msgObj.getSeverity();
                        String errCode = null;
                        errCode = status == 1 ? "cmDataUpgraded" : "cmDataNotUpgraded";
                        CMException ex2 = new CMException(ex1, errCode);
                        ex2.ErrorLevel = severity;
                        this.reportError(ex2, CMDataUpgradeUtils.convertIPFLevelToSeverityEnum(severity));
                    }
                } else if (status == 2) {
                    CMException ex = new CMException("cmPluginNoMessage", new CMException.Parm("Path", searchPath));
                    ex.ErrorLevel = 40000;
                    this.reportError(ex, "error");
                }
                if (upgradeResult.getNextAction() != 2) continue;
                return;
            }
            catch (Throwable ex) {
                CMIndications.logException(ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (oneObjRes != null) {
                    oneObjRes.release();
                    oneObjRes = null;
                }
                if (store.inTransaction()) {
                    store.rollbackTransaction();
                }
                this.lockManager.releaseLocks();
            }
        }
    }

    private void addSummaryReport(String sClass) throws CMException {
        int failed = this.countTotal_ - this.countUpgraded_ - this.countUpToDate_;
        String sTotal = Integer.toString(this.countTotal_);
        String sUpgraded = Integer.toString(this.countUpgraded_);
        String sUpToDate = Integer.toString(this.countUpToDate_);
        String sFailed = Integer.toString(failed);
        CMException e = new CMException("cmDataUpgradeSummary", new CMException.Parm("NUM", sTotal), new CMException.Parm("TYPE", sClass), new CMException.Parm("NUM1", sUpgraded), new CMException.Parm("NUM2", sFailed), new CMException.Parm("NUM3", sUpToDate));
        this.reportError(e, "info");
    }
}

