/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.contentTasks.AbstractInternalConsistencyTask;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreConsistency;
import com.cognos.cm.dbstore.CMDbStoreConsistencyUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.List;
import java.util.Map;

public class DbInternalConsistencyTask
extends AbstractInternalConsistencyTask {
    public DbInternalConsistencyTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        super(store, lockManager, runOptions);
    }

    @Override
    protected List<CMException> checkForInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        CMDbStoreConsistency dbconsistency = this.createDbConsistency(dbcon);
        return dbconsistency.checkInternalInconsistencies();
    }

    @Override
    protected void repairInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        CMDbStoreConsistency dbconsistency;
        List<CMException> details;
        if (!this.getHavePerformedInconsistencyCheck() && !(details = (dbconsistency = this.createDbConsistency(dbcon)).repairInternalInconsistencies(false)).isEmpty()) {
            for (CMException ex : details) {
                CMIndications.logException(ex);
            }
            this.setInconsistent(true);
        }
        if (this.isInconsistent()) {
            this.addFixActionToDb(dbcon);
            CMException error = new CMException("cmFoundInconsistentCS");
            this.reportError(error, "fatal");
        }
    }

    protected void addFixActionToDb(CMDbConnection dbcon) {
        CMDbStoreConsistencyUtil.Action action = new CMDbStoreConsistencyUtil.Action(CMDbStoreConsistencyUtil.ActionId.ACTION_FIX);
        CMDbStoreConsistencyUtil.addAction(dbcon, action);
    }

    protected CMDbStoreConsistency createDbConsistency(CMDbConnection dbcon) {
        return new CMDbStoreConsistency(dbcon);
    }
}

