/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.contentTasks.AbstractInternalConsistencyTask;
import com.cognos.cm.contentTasks.DbInternalConsistencyTask;
import com.cognos.cm.contentTasks.IRunnableErrorsReporter;
import com.cognos.cm.contentTasks.MultiTenancyConsistencyTask;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InternalConsistencyTask
extends AbstractInternalConsistencyTask {
    private List<AbstractInternalConsistencyTask> tasks = new ArrayList<AbstractInternalConsistencyTask>();

    public InternalConsistencyTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        super(store, lockManager, runOptions);
        DbInternalConsistencyTask dbCheck = this.createDbTask(store, lockManager, runOptions);
        dbCheck.setReportOnConsistent(false);
        this.tasks.add(dbCheck);
        if (MultiTenancyUtils.get().isMultiTenantInstall(store)) {
            MultiTenancyConsistencyTask multiTenancyCheck = this.createMultiTenancyTask(store, lockManager, runOptions);
            multiTenancyCheck.setReportOnConsistent(false);
            this.tasks.add(multiTenancyCheck);
        }
    }

    @Override
    public void execute() throws CMException {
        CMExecutionContext context = CMExecutionContext.get();
        if (!context.getCurrentUserIsAdministrator() && this.shouldRepairInternalInconsistencies()) {
            throw new CMException("cmMustBeSysAdmin");
        }
        super.execute();
    }

    @Override
    protected List<CMException> checkForInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        ArrayList<CMException> details = new ArrayList<CMException>();
        for (AbstractInternalConsistencyTask task : this.tasks) {
            details.addAll(task.checkForInternalInconsistencies(dbcon));
        }
        return details;
    }

    @Override
    protected void repairInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        boolean isInconsistent = false;
        for (AbstractInternalConsistencyTask task : this.tasks) {
            task.repairInternalInconsistencies(dbcon);
            isInconsistent |= task.isInconsistent();
        }
        this.setInconsistent(isInconsistent);
    }

    @Override
    public void setErrorsReporter(IRunnableErrorsReporter errorsReporter) {
        super.setErrorsReporter(errorsReporter);
        for (AbstractInternalConsistencyTask task : this.tasks) {
            task.setErrorsReporter(this.getErrorsReporter());
        }
    }

    protected MultiTenancyConsistencyTask createMultiTenancyTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        MultiTenancyConsistencyTask task = new MultiTenancyConsistencyTask(store, lockManager, runOptions);
        task.setErrorsReporter(this.getErrorsReporter());
        return task;
    }

    protected DbInternalConsistencyTask createDbTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        DbInternalConsistencyTask task = new DbInternalConsistencyTask(store, lockManager, runOptions);
        task.setErrorsReporter(this.getErrorsReporter());
        return task;
    }
}

