/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.contentTasks.AbstractInternalConsistencyTask;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multitenancy.TenantContainmentConsistencyCheck;
import com.cognos.cm.multitenancy.TenantContainmentConsistencyRepair;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import java.util.List;
import java.util.Map;

public class MultiTenancyConsistencyTask
extends AbstractInternalConsistencyTask {
    private Map<String, String> tenantConsistencyCheckResults;

    public MultiTenancyConsistencyTask(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) {
        super(store, lockManager, runOptions);
    }

    @Override
    protected List<CMException> checkForInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        boolean provideDetails = CMExecutionContext.get().getCurrentUserIsAdministrator();
        TenantContainmentConsistencyCheck tenantCheck = this.createTenancyCheck(dbcon);
        List<CMException> results = tenantCheck.checkTenantContainmentConsistency(provideDetails);
        this.tenantConsistencyCheckResults = tenantCheck.getChildToParentInconsistentStoreIds();
        return results;
    }

    @Override
    protected void repairInternalInconsistencies(CMDbConnection dbcon) throws CMConfigurationException, CMException {
        List<CMException> details;
        if (!this.getHavePerformedInconsistencyCheck() && !(details = this.checkForInternalInconsistencies(dbcon)).isEmpty()) {
            this.reportErrors(details, "info");
            this.setInconsistent(true);
        }
        if (this.isInconsistent()) {
            TenantContainmentConsistencyRepair tenantRepair = this.createTenancyRepair();
            List<CMException> repairSteps = tenantRepair.repairInconsistencies();
            this.reportErrors(repairSteps, "info");
            this.setInconsistent(false);
            CMException repairedMultiTenant = new CMException("cmRepairedTenantHierarchy");
            this.reportError(repairedMultiTenant, "info");
        }
    }

    protected TenantContainmentConsistencyCheck createTenancyCheck(CMDbConnection dbcon) {
        return new TenantContainmentConsistencyCheck(this.getStore(), dbcon);
    }

    protected TenantContainmentConsistencyRepair createTenancyRepair() {
        return new TenantContainmentConsistencyRepair(this.getStore(), this.tenantConsistencyCheckResults);
    }
}

