/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.contentTasks.IRunnableErrorsReporter;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;

public abstract class RunnableErrorsReporter
implements IRunnableErrorsReporter {
    protected Throwable throwable;

    @Override
    public abstract void addHistoryDetail(String var1, String var2) throws CMException;

    @Override
    public abstract boolean isComplete() throws CMException;

    @Override
    public void reportError(CMException ex, String severity) throws CMException {
        this.logException(ex, severity);
        this.addHistoryDetailForException(ex, severity);
    }

    private void addHistoryDetailForException(CMException ex, String severity) {
        this.removeStackTraceFromException(ex);
        try {
            String sMessage = ex.getFullMessage();
            this.addHistoryDetail(sMessage, severity);
        }
        catch (Throwable e) {
            CMIndications.logException(new CMException(e, "cmFailedAddHistoryDetail"));
        }
    }

    private void removeStackTraceFromException(CMException ex) {
        if (ex.cause_ != null) {
            ex.ex_ = (Exception)ex.cause_;
            ex.cause_ = null;
        }
    }

    private void logException(Throwable ex, String severity) {
        if (severity.equals("error") || severity.equals("fatal")) {
            CMIndications.logException(ex);
            this.throwable = ex;
        }
    }

    public Throwable getThrowableLogged() {
        return this.throwable;
    }

    @Override
    public void reportError(String errCode, String severity, CMException.Parm[] parms) throws CMException {
        CMException ex = new CMException(errCode, parms);
        this.reportError(ex, severity);
    }

    @Override
    public void reportErrorThrowable(String errCode, String severity, CMException.Parm[] parms, Throwable t) {
        this.logException(t, severity);
        CMException ex = new CMException(errCode, parms);
        this.addHistoryDetailForException(ex, severity);
    }
}

