/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.IRunnableErrorsReporter;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Task {
    private Map<String, Object> runOptions;
    protected IRunnableErrorsReporter errorsReporter;
    private boolean succeded = true;
    private CMStore store;
    protected static Lock lock = new Lock();

    public Task(CMStore store, Map<String, Object> runOptions) {
        this.store = store;
        this.runOptions = runOptions;
    }

    public CMStore getStore() {
        return this.store;
    }

    public Lock getLock() {
        return lock;
    }

    public Map<String, Object> getRunOptions() {
        return this.runOptions;
    }

    public void setErrorsReporter(IRunnableErrorsReporter errorsReporter) {
        this.errorsReporter = errorsReporter;
    }

    public IRunnableErrorsReporter getErrorsReporter() {
        return this.errorsReporter;
    }

    protected void setSucceeded(boolean succeeded) {
        this.succeded = succeeded;
    }

    public boolean isSucceeded() {
        return this.succeded;
    }

    public abstract void execute() throws CMException;

    public abstract void initialize() throws CMException;

    public void reportErrors(List<CMException> errors, String severity) throws CMException {
        for (CMException error : errors) {
            this.reportError(error, severity);
        }
    }

    public void reportError(CMException ex, String severity) throws CMException {
        if (this.errorsReporter != null) {
            this.errorsReporter.reportError(ex, severity);
        }
    }

    public void reportError(String errCode, String severity, CMException.Parm[] parms) throws CMException {
        if (this.errorsReporter != null) {
            this.errorsReporter.reportError(errCode, severity, parms);
        }
    }

    public void addHistoryDetail(String detail, String severity) throws CMException {
        if (this.errorsReporter != null) {
            this.errorsReporter.addHistoryDetail(detail, severity);
        }
    }

    public boolean isBooleanOptionOn(ContentTaskOption option) throws CMException {
        XMLElement root;
        Object value = this.getRunOptionValue(option);
        String sValue = value == null ? null : value.toString();
        boolean bSet = false;
        if (sValue != null && (root = CMXMLUtils.convertXMLString2XMLElement(sValue)) != null) {
            bSet = root.getOptionalChildBooleanValueWithName("value", true);
        }
        return bSet;
    }

    public boolean getBooleanOption(ContentTaskOption option, boolean defaultValue) throws CMException {
        XMLElement root;
        boolean result = defaultValue;
        String sValue = (String)this.getRunOptionValue(option.name());
        if (sValue != null && (root = CMXMLUtils.convertXMLString2XMLElement(sValue)) != null) {
            result = root.getOptionalChildBooleanValueWithName("value", defaultValue);
        }
        return result;
    }

    public ArrayList<String> getTaskContext(ContentTaskOption option) throws CMException {
        ArrayList<String> stringOptions;
        ArrayList<String> contextSearchPaths = new ArrayList<String>();
        Object contextInOption = this.getRunOptionValue(option);
        if (contextInOption != null && (stringOptions = CMXMLUtils.convertXMLElementArray2StringArray((String)contextInOption)) != null) {
            contextSearchPaths.addAll(stringOptions);
        }
        return contextSearchPaths;
    }

    public String getTaskStringOptionValue(String optionName) throws CMException {
        XMLElement root;
        String value = null;
        Object optionValueXML = this.getRunOptions().get(optionName);
        if (optionValueXML != null && (root = CMXMLUtils.convertXMLString2XMLElement((String)optionValueXML)) != null) {
            value = root.getChildValueWithName("value");
        }
        return value;
    }

    public boolean hasOption(ContentTaskOption option) {
        return this.runOptions.containsKey(option.name());
    }

    public Object getRunOptionValue(ContentTaskOption option) {
        return this.runOptions.get(option.name());
    }

    public <T> T getRunOptionValue(String option) {
        return (T)this.runOptions.get(option);
    }

    public static class LockNoOp
    extends Lock {
        @Override
        public boolean aquire() {
            return true;
        }

        @Override
        public void release() {
        }
    }

    public static class Lock {
        private volatile boolean isLocked = false;

        public synchronized boolean aquire() {
            if (this.isLocked) {
                return false;
            }
            this.isLocked = true;
            return this.isLocked;
        }

        public synchronized void release() {
            this.isLocked = false;
        }
    }
}

