/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.ConsistencyCheckTask;
import com.cognos.cm.contentTasks.DataUpgradeTask;
import com.cognos.cm.contentTasks.InternalConsistencyTask;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTask;
import com.cognos.cm.contentTasks.cleanupTask.StoreWithLockManager;
import com.cognos.cm.contentTasks.csutilization.CreateContentStoreUtilizationInfo;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.Map;

public class TaskFactory {
    public Task[] getTasks(CMStore store, ICMLockManager lockManager, Map<String, Object> runOptions) throws CMException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        if (this.containsOption(runOptions, ContentTaskOption.checkSecurityReferences) || this.containsOption(runOptions, ContentTaskOption.repairSecurityReferences)) {
            taskList.add(new ConsistencyCheckTask(store, runOptions));
        }
        if (this.containsOption(runOptions, ContentTaskOption.upgradeClasses)) {
            taskList.add(new DataUpgradeTask(store, lockManager, runOptions));
        }
        if (this.containsOption(runOptions, ContentTaskOption.checkInternalInconsistencies) || this.containsOption(runOptions, ContentTaskOption.repairInternalInconsistencies)) {
            taskList.add(new InternalConsistencyTask(store, lockManager, runOptions));
        }
        if (this.containsOption(runOptions, ContentTaskOption.cleanupContent) && this.isBooleanOptionOn(runOptions, ContentTaskOption.cleanupContent)) {
            taskList.add(new CleanupTask(new StoreWithLockManager(store, lockManager), runOptions));
        }
        if (this.containsOption(runOptions, ContentTaskOption.createContentStoreUtilizationInfo)) {
            taskList.add(new CreateContentStoreUtilizationInfo(store, runOptions));
        }
        Task[] tasks = new Task[taskList.size()];
        for (int i = 0; i < taskList.size(); ++i) {
            tasks[i] = (Task)taskList.get(i);
        }
        return tasks;
    }

    private boolean containsOption(Map<String, Object> runOptions, ContentTaskOption option) {
        return runOptions.containsKey(option.name());
    }

    private boolean isBooleanOptionOn(Map<String, Object> runOptions, ContentTaskOption option) throws CMException {
        XMLElement root;
        boolean bSet = false;
        String value = runOptions.get(option.name()).toString();
        if (value != null && (root = CMXMLUtils.convertXMLString2XMLElement(value)) != null) {
            bSet = root.getOptionalChildBooleanValueWithName("value", true);
        }
        return bSet;
    }
}

