/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.cleanupTask.ITaskErrorReporter;
import com.cognos.cm.server.CMException;
import com.cognos.pogo.util.NameValuePair;

public class ActionReporter
implements IActionReporter {
    private ITaskErrorReporter taskReporter;
    protected String totalSuccessAndFailuresMessage;
    private long successCounter;
    private long failureCounter;

    public ActionReporter(ITaskErrorReporter taskReporter, String totalSuccessAndFailuresMessage) {
        this.taskReporter = taskReporter;
        this.totalSuccessAndFailuresMessage = totalSuccessAndFailuresMessage;
        this.resetSuccessCounter();
        this.resetFailureCounter();
        taskReporter.addActionReporter(this);
    }

    @Override
    public void reportSuccess(String successMessage, CMException.Parm[] parms) throws CMException {
        ++this.successCounter;
        this.taskReporter.reportSuccess(successMessage, parms);
    }

    @Override
    public void reportSuccess(String successMessage, String objectSearchPath) throws CMException {
        ++this.successCounter;
        this.taskReporter.reportSuccess(successMessage, objectSearchPath);
    }

    @Override
    public void reportFailure(String failureMessage, Throwable t, String searchPath) throws CMException {
        ++this.failureCounter;
        this.taskReporter.reportFailure(searchPath, t, failureMessage);
    }

    @Override
    public void reportFailure(String failureMessage, CMException.Parm[] parms) throws CMException {
        ++this.failureCounter;
        this.taskReporter.reportTaskError(failureMessage, "error", parms);
    }

    @Override
    public void reportFailureThrowable(String failureMessage, Throwable t, String searchPath) throws CMException {
        ++this.failureCounter;
        this.taskReporter.reportFailureThrowable(searchPath, t, failureMessage);
    }

    @Override
    public void reportFailureThrowable(String failureMessage, Throwable t, CMException.Parm[] parms) throws CMException {
        ++this.failureCounter;
        this.taskReporter.reportTaskErrorThrowable(failureMessage, "error", parms, t);
    }

    @Override
    public long getSuccessCounter() {
        return this.successCounter;
    }

    @Override
    public long getFailureCounter() {
        return this.failureCounter;
    }

    @Override
    public String getTotalSuccessAndFailuresMessage(String searchPath) {
        NameValuePair[] parms = new CMException.Parm[]{new CMException.Parm("SEARCHPATH", searchPath), new CMException.Parm("NUMBERERROR", String.valueOf(this.getFailureCounter())), new CMException.Parm("NUMBERSUCCESS", String.valueOf(this.getSuccessCounter()))};
        return CMError.getMessage(this.totalSuccessAndFailuresMessage, parms, null);
    }

    @Override
    public void resetFailureCounter() {
        this.failureCounter = 0L;
    }

    @Override
    public void resetSuccessCounter() {
        this.successCounter = 0L;
    }
}

