/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.TaskObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;

public class AddToWorkflowAction
extends TaskObjectAction {
    private String workflowName;
    private IActionReporter actionReporter;

    public AddToWorkflowAction(String workflowName, ITaskContext taskContext, IActionReporter actionReporter) {
        super(taskContext);
        this.workflowName = workflowName;
        this.actionReporter = actionReporter;
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        try {
            if (this.simulatedException.doCreateSimulatedException(AdvancedSettings.CLEANUPTASKTESTVARIABLE, this.workflowName)) {
                this.simulatedException.throwNewSimulatedException(this.toString());
            }
            this.getQueueManager().put(this.getStore(), objectSearchPath, this.workflowName, null);
            this.actionReporter.reportSuccess("cmAddToFlowSuccessMessage", this.createSuccessParamters(objectSearchPath));
        }
        catch (CMException ce) {
            this.actionReporter.reportFailure("cmAddToFlowFailureMessage", this.createErrorParamters(objectSearchPath, ce));
            throw ce;
        }
        catch (Throwable t) {
            this.actionReporter.reportFailureThrowable("cmAddToFlowFailureMessage", t, this.createErrorParamters(objectSearchPath, t));
            throw new CMException(t, "cmAddToFlowFailureMessage");
        }
        finally {
            this.simulatedException.incrementCounter();
        }
    }

    private CMException.Parm[] createSuccessParamters(String objectSearchPath) {
        return new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath), new CMException.Parm("WORKFLOW", this.workflowName)};
    }

    private CMException.Parm[] createErrorParamters(String objectSearchPath, Throwable t) {
        return new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath), new CMException.Parm("WORKFLOW", this.workflowName), new CMException.Parm("EXCEPTION", t)};
    }

    protected ICMQueueManager getQueueManager() {
        return CMQueueManager.getManager();
    }

    @Override
    protected CleanupTaskContext getTaskContext() {
        return (CleanupTaskContext)super.getTaskContext();
    }

    private ICMDbConnection getConnection() throws CMException {
        ICMDbStore dbStore = (ICMDbStore)this.getStore();
        return dbStore.getICMDbConnection();
    }
}

