/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.contentTasks.actions.DescendantsAction;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.IArchivableVersionAction;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectAction;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.ICMObjectClasses;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;

public class ArchivableRunnableAction
extends DescendantsAction {
    private CMObjectClass archivableVersionClass;
    private CleanupTaskContext context;
    private IContentObjectAction archivingRequiredVersionAction;
    private IContentObjectAction archivingNotRequiredVersionAction;
    private IArchivableVersionAction archivableVersionAction;
    private IActionReporter skipActionReporter;
    private boolean runnableIsValidParentForArchivableVersionClass;

    public ArchivableRunnableAction(IContentFilter filter, IArchivableVersionAction archivableVersionAction, CMObjectClass archivableVersionClass, CleanupTaskContext context, IContentObjectAction archivingRequiredVersionAction, IContentObjectAction archivingNotRequiredVersionAction, IActionReporter actionReporter) {
        super(filter);
        this.archivableVersionAction = archivableVersionAction;
        this.context = context;
        this.archivingRequiredVersionAction = archivingRequiredVersionAction;
        this.archivingNotRequiredVersionAction = archivingNotRequiredVersionAction;
        this.archivableVersionClass = archivableVersionClass;
        this.skipActionReporter = actionReporter;
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        if (this.isConfiguredForArchival(objectSearchPath)) {
            super.execute(objectSearchPath);
        } else if (this.runnableIsValidParentForArchivableVersionClass) {
            this.skipActionReporter.reportSuccess("cmSkipAddToFlowMessage", objectSearchPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConfiguredForArchival(String objectSearchPath) throws CMException {
        CMStore store = this.context.getStoreWithLockManager().getStore();
        ICMLockManager lockManager = this.context.getStoreWithLockManager().getLockManager();
        ICMStorePath searchStorePath = this.createStorePath(objectSearchPath);
        boolean isConfiguredForArchival = false;
        try {
            lockManager.requestLocks(searchStorePath);
            store.beginTransaction();
            CMObjectClass runnableObjectClass = this.queryObjectClass(store, searchStorePath);
            this.runnableIsValidParentForArchivableVersionClass = runnableObjectClass.isValidChildClass(this.archivableVersionClass);
            if (this.runnableIsValidParentForArchivableVersionClass) {
                isConfiguredForArchival = this.context.getRepositoryRules().hasRepositoryRuleForClass(searchStorePath, this.archivableVersionClass);
            }
            store.commitTransaction();
            boolean bl = isConfiguredForArchival;
            return bl;
        }
        finally {
            if (store.inTransaction()) {
                store.rollbackTransaction();
            }
            lockManager.releaseLocks();
        }
    }

    protected ICMStorePath createStorePath(String objectSearchPath) throws CMStoreParseException {
        return new CMStoreXPath(objectSearchPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMObjectClass queryObjectClass(CMStore store, ICMStorePath objectStorePath) throws CMException {
        CMStoreQueryResults queryResults = null;
        try {
            queryResults = store.executeQuery(objectStorePath, new CMProperty[]{CMProperty.OBJECTCLASS}, null, 0, 0, null);
            if (queryResults.next()) {
                CMObjectClass cMObjectClass = (CMObjectClass)queryResults.getValue(0);
                return cMObjectClass;
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
        }
        return null;
    }

    @Override
    protected void executeActionOnDescendant(String descendantSearchPath) throws CMException {
        this.archivableVersionAction.execute(descendantSearchPath);
        if (this.archivableVersionAction.lastVersionShouldBeArchived()) {
            this.getArchivingRequiredVersionAction().execute(descendantSearchPath);
        } else if (this.getArchivingNotRequiredVersionAction() != null) {
            this.getArchivingNotRequiredVersionAction().execute(descendantSearchPath);
        }
    }

    public IContentObjectAction getArchivingRequiredVersionAction() {
        return this.archivingRequiredVersionAction;
    }

    public IContentObjectAction getArchivingNotRequiredVersionAction() {
        return this.archivingNotRequiredVersionAction;
    }

    protected ICMObjectClasses getObjectClasses() {
        return this.context.getStoreWithLockManager().getStore().getObjectClasses();
    }
}

