/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.contentTasks.actions.DescendantsAction;
import com.cognos.cm.contentTasks.actions.IArchivableVersionAction;
import com.cognos.cm.contentTasks.actions.IOnHoldAction;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.server.CMException;

public class ArchivableVersionAction
extends DescendantsAction
implements IArchivableVersionAction {
    private boolean lastVersionShouldBeArchived;
    private IOnHoldAction descendantAction;

    public ArchivableVersionAction(IContentFilter filter, IOnHoldAction descendantAction) {
        super(filter);
        this.descendantAction = descendantAction;
        this.lastVersionShouldBeArchived = false;
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        this.lastVersionShouldBeArchived = false;
        super.execute(objectSearchPath);
    }

    @Override
    protected void executeActionOnDescendant(String descendantSearchPath) throws CMException {
        this.descendantAction.execute(descendantSearchPath);
        if (this.descendantAction.lastObjectPutOnHold()) {
            this.lastVersionShouldBeArchived = true;
        }
    }

    @Override
    public boolean lastVersionShouldBeArchived() {
        return this.lastVersionShouldBeArchived;
    }
}

